/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.fx.utils;

import javafx.scene.shape.Arc;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.Ellipse;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.QuadCurve;
import javafx.scene.shape.QuadCurveTo;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import org.eclipse.gef.geometry.planar.CubicCurve;
import org.eclipse.gef.geometry.planar.IGeometry;
import org.eclipse.gef.geometry.planar.Line;
import org.eclipse.gef.geometry.planar.Path;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.geometry.planar.Polygon;
import org.eclipse.gef.geometry.planar.Polyline;
import org.eclipse.gef.geometry.planar.QuadraticCurve;
import org.eclipse.gef.geometry.planar.RoundedRectangle;

public class Geometry2Shape {
    public static Arc toArc(org.eclipse.gef.geometry.planar.Arc arc) {
        return new Arc(arc.getX() + arc.getWidth() / 2.0, arc.getY() + arc.getHeight() / 2.0, arc.getWidth() / 2.0, arc.getHeight() / 2.0, arc.getStartAngle().deg(), arc.getAngularExtent().deg());
    }

    public static javafx.scene.shape.CubicCurve toCubicCurve(CubicCurve cubic) {
        return new javafx.scene.shape.CubicCurve(cubic.getX1(), cubic.getY1(), cubic.getCtrlX1(), cubic.getCtrlY1(), cubic.getCtrlX2(), cubic.getCtrlY2(), cubic.getX2(), cubic.getY2());
    }

    public static Ellipse toEllipse(org.eclipse.gef.geometry.planar.Ellipse ellipse) {
        return new Ellipse(ellipse.getX() + ellipse.getWidth() / 2.0, ellipse.getY() + ellipse.getHeight() / 2.0, ellipse.getWidth() / 2.0, ellipse.getHeight() / 2.0);
    }

    public static javafx.scene.shape.Line toLine(Line line) {
        return new javafx.scene.shape.Line(line.getX1(), line.getY1(), line.getX2(), line.getY2());
    }

    public static javafx.scene.shape.Path toPath(Path path) {
        javafx.scene.shape.Path fxPath = new javafx.scene.shape.Path(Geometry2Shape.toPathElements(path));
        fxPath.setFillRule(path.getWindingRule() == 0 ? FillRule.EVEN_ODD : FillRule.NON_ZERO);
        return fxPath;
    }

    public static PathElement[] toPathElements(Path path) {
        Path.Segment[] segments = path.getSegments();
        PathElement[] elements = new PathElement[segments.length];
        int i = 0;
        while (i < segments.length) {
            Point[] points = segments[i].getPoints();
            switch (segments[i].getType()) {
                case 0: {
                    elements[i] = new MoveTo(points[0].x, points[0].y);
                    break;
                }
                case 1: {
                    elements[i] = new LineTo(points[0].x, points[0].y);
                    break;
                }
                case 2: {
                    elements[i] = new QuadCurveTo(points[0].x, points[0].y, points[1].x, points[1].y);
                    break;
                }
                case 3: {
                    elements[i] = new CubicCurveTo(points[0].x, points[0].y, points[1].x, points[1].y, points[2].x, points[2].y);
                    break;
                }
                case 4: {
                    elements[i] = new ClosePath();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown Path.Segment: <" + segments[i] + ">");
                }
            }
            ++i;
        }
        return elements;
    }

    public static javafx.scene.shape.Polygon toPolygon(Polygon polygon) {
        return new javafx.scene.shape.Polygon(polygon.getCoordinates());
    }

    public static javafx.scene.shape.Polyline toPolyline(Polyline polyline) {
        return new javafx.scene.shape.Polyline(polyline.getCoordinates());
    }

    public static QuadCurve toQuadCurve(QuadraticCurve quadCurve) {
        return new QuadCurve(quadCurve.getX1(), quadCurve.getY1(), quadCurve.getCtrlX(), quadCurve.getCtrlY(), quadCurve.getX2(), quadCurve.getY2());
    }

    public static Rectangle toRectangle(org.eclipse.gef.geometry.planar.Rectangle rect) {
        return new Rectangle(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    public static Rectangle toRectangle(RoundedRectangle roundedRect) {
        Rectangle rectangle = new Rectangle(roundedRect.getX(), roundedRect.getY(), roundedRect.getWidth(), roundedRect.getHeight());
        rectangle.setArcWidth(roundedRect.getArcWidth());
        rectangle.setArcHeight(roundedRect.getArcHeight());
        return rectangle;
    }

    public static Shape toShape(IGeometry geometry) {
        if (geometry instanceof org.eclipse.gef.geometry.planar.Arc) {
            return Geometry2Shape.toArc((org.eclipse.gef.geometry.planar.Arc)geometry);
        }
        if (geometry instanceof CubicCurve) {
            return Geometry2Shape.toCubicCurve((CubicCurve)geometry);
        }
        if (geometry instanceof org.eclipse.gef.geometry.planar.Ellipse) {
            return Geometry2Shape.toEllipse((org.eclipse.gef.geometry.planar.Ellipse)geometry);
        }
        if (geometry instanceof Line) {
            return Geometry2Shape.toLine((Line)geometry);
        }
        if (geometry instanceof Path) {
            return Geometry2Shape.toPath((Path)geometry);
        }
        if (geometry instanceof Polygon) {
            return Geometry2Shape.toPolygon((Polygon)geometry);
        }
        if (geometry instanceof Polyline) {
            return Geometry2Shape.toPolyline((Polyline)geometry);
        }
        if (geometry instanceof QuadraticCurve) {
            QuadraticCurve quad = (QuadraticCurve)geometry;
            return Geometry2Shape.toQuadCurve(quad);
        }
        if (geometry instanceof org.eclipse.gef.geometry.planar.Rectangle) {
            return Geometry2Shape.toRectangle((org.eclipse.gef.geometry.planar.Rectangle)geometry);
        }
        if (geometry instanceof RoundedRectangle) {
            return Geometry2Shape.toRectangle((RoundedRectangle)geometry);
        }
        return Geometry2Shape.toPath(geometry.toPath());
    }
}

