/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoHandler;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.internal.db.DBStore;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.commit.CDOCommitInfoUtil;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBDatabase;
import org.eclipse.net4j.db.IDBPreparedStatement;
import org.eclipse.net4j.db.IDBResultSet;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class CommitInfoTable
extends Lifecycle {
    private static final String COMMIT_INFOS = "cdo_commit_infos";
    private static final String TIMESTAMP = "commit_time";
    private static final String PREVIOUS_TIMESTAMP = "previous_time";
    private static final String BRANCH = "branch_id";
    private static final String USER = "user_id";
    private static final String COMMENT = "commit_comment";
    private static final String MERGED_BRANCH = "merged_branch";
    private static final String MERGED_TIMESTAMP = "merged_time";
    private DBStore store;
    private boolean withMergeSource;
    private IDBTable table;
    private String sqlInsert;

    public CommitInfoTable(DBStore store) {
        this.store = store;
    }

    public void writeCommitInfo(IDBStoreAccessor accessor, CDOBranch branch, long timeStamp, long previousTimeStamp, String userID, String comment, CDOBranchPoint mergeSource, OMMonitor monitor) {
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlInsert, IDBPreparedStatement.ReuseProbability.HIGH);
        try {
            try {
                stmt.setLong(1, timeStamp);
                stmt.setLong(2, previousTimeStamp);
                stmt.setInt(3, branch.getID());
                stmt.setString(4, userID);
                stmt.setString(5, comment);
                if (this.withMergeSource) {
                    if (mergeSource != null) {
                        stmt.setInt(6, mergeSource.getBranch().getID());
                        stmt.setLong(7, mergeSource.getTimeStamp());
                    } else {
                        stmt.setNull(6, DBType.INTEGER.getCode());
                        stmt.setNull(7, DBType.BIGINT.getCode());
                    }
                }
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadCommitInfos(IDBStoreAccessor accessor, CDOBranch branch, long startTime, long endTime, CDOCommitInfoHandler handler) {
        int count = CDOCommitInfoUtil.decodeCount((long)endTime);
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append(TIMESTAMP);
        builder.append(", ");
        builder.append(PREVIOUS_TIMESTAMP);
        builder.append(", ");
        builder.append(USER);
        builder.append(", ");
        builder.append(COMMENT);
        if (branch == null) {
            builder.append(", ");
            builder.append(BRANCH);
        }
        if (this.withMergeSource) {
            builder.append(", ");
            builder.append(MERGED_BRANCH);
            builder.append(", ");
            builder.append(MERGED_TIMESTAMP);
        }
        builder.append(" FROM ");
        builder.append(COMMIT_INFOS);
        boolean where = false;
        if (branch != null) {
            builder.append(where ? " AND " : " WHERE ");
            builder.append(BRANCH);
            builder.append("=");
            builder.append(branch.getID());
            where = true;
        }
        if (startTime != 0L) {
            builder.append(where ? " AND " : " WHERE ");
            builder.append(TIMESTAMP);
            builder.append(count < 0 ? "<=" : ">=");
            builder.append(startTime);
            where = true;
        }
        if (endTime > 0L) {
            builder.append(where ? " AND " : " WHERE ");
            builder.append(TIMESTAMP);
            builder.append("<=");
            builder.append(endTime);
            where = true;
        }
        builder.append(" ORDER BY ");
        builder.append(TIMESTAMP);
        builder.append(count < 0 || 0L <= endTime && endTime <= startTime ? " DESC" : " ASC");
        String sql = builder.toString();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(sql, IDBPreparedStatement.ReuseProbability.LOW);
        IDBResultSet resultSet = null;
        InternalRepository repository = this.store.getRepository();
        InternalCDOBranchManager branchManager = repository.getBranchManager();
        InternalCDOCommitInfoManager commitInfoManager = repository.getCommitInfoManager();
        count = Math.abs(count);
        try {
            try {
                resultSet = stmt.executeQuery();
                while (count-- > 0) {
                    if (!resultSet.next()) {
                        return;
                    }
                    int column = 0;
                    long timeStamp = resultSet.getLong(++column);
                    long previousTimeStamp = resultSet.getLong(++column);
                    String userID = resultSet.getString(++column);
                    String comment = resultSet.getString(++column);
                    CDOBranch infoBranch = branch;
                    if (infoBranch == null) {
                        int id = resultSet.getInt(++column);
                        infoBranch = branchManager.getBranch(id);
                    }
                    CDOBranchPoint mergeSource = null;
                    if (this.withMergeSource) {
                        int id = resultSet.getInt(++column);
                        if (!resultSet.wasNull()) {
                            InternalCDOBranch mergedBranch = branchManager.getBranch(id);
                            long mergedTimeStamp = resultSet.getLong(++column);
                            mergeSource = mergedBranch.getPoint(mergedTimeStamp);
                        }
                    }
                    CDOCommitInfo commitInfo = commitInfoManager.createCommitInfo(infoBranch, timeStamp, previousTimeStamp, userID, comment, mergeSource, null);
                    handler.handleCommitInfo(commitInfo);
                }
                return;
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        finally {
            DBUtil.close((ResultSet)resultSet);
            DBUtil.close((Statement)stmt);
        }
    }

    public void rawExport(Connection connection, CDODataOutput out, long fromCommitTime, long toCommitTime) throws IOException {
        out.writeBoolean(this.withMergeSource);
        String where = " WHERE commit_time BETWEEN " + fromCommitTime + " AND " + toCommitTime;
        DBUtil.serializeTable((ExtendedDataOutput)out, (Connection)connection, (IDBTable)this.table, null, (String)where);
    }

    public void rawImport(Connection connection, CDODataInput in, long fromCommitTime, long toCommitTime, OMMonitor monitor) throws IOException {
        boolean actualWithMergeSource = in.readBoolean();
        if (actualWithMergeSource != this.withMergeSource) {
            throw new IllegalStateException("Commit info data mismatch. Expected: " + (this.withMergeSource ? "with" : "without") + " merge source. Actual: " + (actualWithMergeSource ? "with" : "without") + " merge source.");
        }
        DBUtil.deserializeTable((ExtendedDataInput)in, (Connection)connection, (IDBTable)this.table, (OMMonitor)monitor.fork());
    }

    public void repairAfterCrash(Connection connection) {
        IDBField timeStampField = this.table.getField(TIMESTAMP);
        long lastCommitTime = DBUtil.selectMaximumLong((Connection)connection, (IDBField)timeStampField, (String[])new String[0]);
        long lastNonLocalCommitTime = DBUtil.selectMaximumLong((Connection)connection, (IDBField)timeStampField, (String[])new String[]{"0<=branch_id"});
        if (lastNonLocalCommitTime == 0L) {
            lastNonLocalCommitTime = lastCommitTime;
        }
        this.store.setLastCommitTime(lastCommitTime);
        this.store.setLastNonLocalCommitTime(lastNonLocalCommitTime);
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        InternalRepository repository = this.store.getRepository();
        this.withMergeSource = repository.getCommitInfoStorage() == CDOCommonRepository.CommitInfoStorage.WITH_MERGE_SOURCE;
        IDBDatabase database = this.store.getDatabase();
        this.table = database.getSchema().getTable(COMMIT_INFOS);
        if (this.table == null) {
            database.updateSchema(new IDBDatabase.RunnableWithSchema(){

                public void run(IDBSchema schema) {
                    CommitInfoTable.this.table = schema.addTable(CommitInfoTable.COMMIT_INFOS);
                    CommitInfoTable.this.table.addField(CommitInfoTable.TIMESTAMP, DBType.BIGINT, true);
                    CommitInfoTable.this.table.addField(CommitInfoTable.PREVIOUS_TIMESTAMP, DBType.BIGINT);
                    CommitInfoTable.this.table.addField(CommitInfoTable.BRANCH, DBType.INTEGER);
                    CommitInfoTable.this.table.addField(CommitInfoTable.USER, DBType.VARCHAR);
                    CommitInfoTable.this.table.addField(CommitInfoTable.COMMENT, DBType.VARCHAR);
                    CommitInfoTable.this.table.addIndex(IDBIndex.Type.PRIMARY_KEY, new String[]{CommitInfoTable.TIMESTAMP});
                    CommitInfoTable.this.table.addIndex(IDBIndex.Type.NON_UNIQUE, new String[]{CommitInfoTable.BRANCH});
                    if (CommitInfoTable.this.withMergeSource) {
                        CommitInfoTable.this.table.addField(CommitInfoTable.MERGED_BRANCH, DBType.INTEGER);
                        CommitInfoTable.this.table.addField(CommitInfoTable.MERGED_TIMESTAMP, DBType.BIGINT);
                        CommitInfoTable.this.table.addIndex(IDBIndex.Type.NON_UNIQUE, new String[]{CommitInfoTable.MERGED_BRANCH, CommitInfoTable.MERGED_TIMESTAMP});
                    }
                }
            });
        } else if (this.withMergeSource && this.table.getField(MERGED_BRANCH) == null) {
            database.updateSchema(new IDBDatabase.RunnableWithSchema(){

                public void run(IDBSchema schema) {
                    IDBTable table = schema.getTable(CommitInfoTable.COMMIT_INFOS);
                    table.addField(CommitInfoTable.MERGED_BRANCH, DBType.INTEGER);
                    table.addField(CommitInfoTable.MERGED_TIMESTAMP, DBType.BIGINT);
                    table.addIndex(IDBIndex.Type.NON_UNIQUE, new String[]{CommitInfoTable.MERGED_BRANCH, CommitInfoTable.MERGED_TIMESTAMP});
                }
            });
        }
        StringBuilder builder = new StringBuilder();
        builder.append("INSERT INTO ");
        builder.append(COMMIT_INFOS);
        builder.append("(");
        builder.append(TIMESTAMP);
        builder.append(", ");
        builder.append(PREVIOUS_TIMESTAMP);
        builder.append(", ");
        builder.append(BRANCH);
        builder.append(", ");
        builder.append(USER);
        builder.append(", ");
        builder.append(COMMENT);
        if (this.withMergeSource) {
            builder.append(", ");
            builder.append(MERGED_BRANCH);
            builder.append(", ");
            builder.append(MERGED_TIMESTAMP);
        }
        builder.append(") VALUES (?, ?, ?, ?, ?");
        if (this.withMergeSource) {
            builder.append(", ?, ?");
        }
        builder.append(")");
        this.sqlInsert = builder.toString();
    }

    protected void doDeactivate() throws Exception {
        this.sqlInsert = null;
        this.table = null;
        super.doDeactivate();
    }
}

