/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.cmake.is.core.participant;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.cdt.cmake.is.core.internal.ParseContext;
import org.eclipse.cdt.cmake.is.core.participant.IArglet;
import org.eclipse.cdt.cmake.is.core.participant.IParserHandler;
import org.eclipse.cdt.cmake.is.core.participant.IResponseFileArglet;
import org.eclipse.cdt.cmake.is.core.participant.IToolCommandlineParser;
import org.eclipse.cdt.cmake.is.core.participant.builtins.IBuiltinsDetectionBehavior;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;

public class DefaultToolCommandlineParser
implements IToolCommandlineParser {
    private static final boolean DEBUG = Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.cdt.cmake.is.core/debug/arglets"));
    private final IArglet[] argumentParsers;
    private final IResponseFileArglet responseFileArglet;
    private final IBuiltinsDetectionBehavior builtinsDetection;

    public DefaultToolCommandlineParser(IResponseFileArglet responseFileArglet, IBuiltinsDetectionBehavior builtinsDetectionBehavior, IArglet ... argumentParsers) {
        this.builtinsDetection = builtinsDetectionBehavior;
        this.argumentParsers = Objects.requireNonNull(argumentParsers, "argumentParsers");
        this.responseFileArglet = responseFileArglet;
    }

    @Override
    public IToolCommandlineParser.IResult processArgs(IPath cwd, String args) {
        ParserHandler ph = new ParserHandler(cwd);
        return ph.parseArguments(this.responseFileArglet, args);
    }

    @Override
    public Optional<IBuiltinsDetectionBehavior> getIBuiltinsDetectionBehavior() {
        return Optional.of(this.builtinsDetection);
    }

    public String toString() {
        return "[" + this.getClass().getName() + ", argumentParsers=" + Arrays.toString(this.argumentParsers) + "]";
    }

    private static int skipArgument(String buildOutput) {
        int consumed = buildOutput.indexOf(32);
        if (consumed != -1) {
            return consumed;
        }
        return buildOutput.length();
    }

    private class ParserHandler
    implements IParserHandler {
        private final IPath cwd;
        private final ParseContext result = new ParseContext();

        public ParserHandler(IPath cwd) {
            this.cwd = Objects.requireNonNull(cwd, "cwd");
        }

        private IToolCommandlineParser.IResult parseArguments(IResponseFileArglet responseFileArglet, String args) {
            while (!(args = args.stripLeading()).isEmpty()) {
                int consumed;
                boolean argParsed = false;
                if (DEBUG) {
                    System.out.printf(">> PARSING next argument in '%s ...'%n", args.substring(0, Math.min(50, args.length())));
                }
                IArglet[] iArgletArray = DefaultToolCommandlineParser.this.argumentParsers;
                int n = DefaultToolCommandlineParser.this.argumentParsers.length;
                int n2 = 0;
                while (n2 < n) {
                    IArglet tap = iArgletArray[n2];
                    if (DEBUG) {
                        System.out.printf("   Trying parser %s%n", tap.getClass().getSimpleName());
                    }
                    if ((consumed = tap.processArgument(this.result, this.cwd, args)) > 0) {
                        if (DEBUG) {
                            System.out.printf("<< PARSED argument '%s'%n", args.substring(0, consumed));
                        }
                        args = args.substring(consumed);
                        argParsed = true;
                        break;
                    }
                    ++n2;
                }
                if (!argParsed && responseFileArglet != null) {
                    if (DEBUG) {
                        System.out.printf("   Trying parser %s%n", responseFileArglet.getClass().getSimpleName());
                    }
                    if ((consumed = responseFileArglet.process(this, args)) > 0) {
                        if (DEBUG) {
                            System.out.printf("<< PARSED ARGUMENT '%s'%n", args.substring(0, consumed));
                        }
                        args = args.substring(consumed);
                        argParsed = true;
                    }
                }
                if (argParsed || args.isEmpty()) continue;
                if (DEBUG) {
                    System.out.printf("<< IGNORING next argument in '%s ...' (no matching parser found)%n", args.substring(0, Math.min(50, args.length())));
                }
                if ((consumed = DefaultToolCommandlineParser.skipArgument(args)) <= 0) continue;
                args = args.substring(consumed);
            }
            return this.result;
        }

        @Override
        public void parseArguments(String args) {
            this.parseArguments(null, args);
        }

        @Override
        public IPath getCompilerWorkingDirectory() {
            return this.cwd;
        }
    }
}

