/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.ide.ui.launching.strategy;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.common.ide.authoring.AcceleoWorkspaceUtil;
import org.eclipse.acceleo.engine.service.AbstractAcceleoGenerator;
import org.eclipse.acceleo.engine.utils.AcceleoLaunchingUtil;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.URI;

public class AcceleoLaunchOperation
implements IWorkspaceRunnable {
    private final IProject project;
    private final String qualifiedName;
    private String model;
    private File targetFolder;
    private List<String> args;

    public AcceleoLaunchOperation(IProject project, String qualifiedName, String model, File targetFolder, List<String> args) {
        this.project = project;
        this.qualifiedName = qualifiedName;
        this.model = model;
        this.targetFolder = targetFolder;
        this.args = args;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        try {
            AcceleoWorkspaceUtil.INSTANCE.addWorkspaceContribution(this.project);
            Class generatorClass = AcceleoWorkspaceUtil.INSTANCE.getClass(this.qualifiedName, false);
            if (generatorClass == null) {
                Status status = new Status(4, "org.eclipse.acceleo.ide.ui", AcceleoUIMessages.getString("AcceleoLaunchOperation.ClassNotFound", this.qualifiedName, this.project.getName()));
                AcceleoUIActivator.getDefault().getLog().log((IStatus)status);
                return;
            }
            try {
                AbstractAcceleoGenerator generator = null;
                if (AbstractAcceleoGenerator.class.isAssignableFrom(generatorClass)) {
                    generator = this.safeInstantiate(generatorClass);
                }
                long start = System.currentTimeMillis();
                if (generator != null) {
                    monitor.subTask(AcceleoUIMessages.getString("AcceleoLaunchOperation.Initialize"));
                    URI modelURI = URI.createFileURI((String)ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.model)).getLocation().toString());
                    modelURI = URI.createURI((String)URI.decode((String)modelURI.toString()));
                    generator.initialize(modelURI, this.targetFolder, new ArrayList());
                    for (String argument : this.args) {
                        generator.addPropertiesFile(argument);
                    }
                    monitor.worked(10);
                    IContainer target = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)new Path(this.targetFolder.getAbsolutePath()));
                    String generationID = "";
                    if (target == null) {
                        try {
                            IContainer[] iContainers = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(new java.net.URI("file:/" + this.targetFolder.getAbsolutePath().replace("\\", "/")));
                            if (iContainers.length > 0) {
                                generationID = AcceleoLaunchingUtil.computeLaunchConfigID((String)this.project.getName(), (String)this.qualifiedName, (String)this.model, (String)iContainers[0].getFullPath().toString(), this.args);
                            }
                        }
                        catch (URISyntaxException e) {
                            AcceleoUIActivator.log(e, true);
                        }
                    } else {
                        generationID = AcceleoLaunchingUtil.computeLaunchConfigID((String)this.project.getName(), (String)this.qualifiedName, (String)this.model, (String)target.getFullPath().toString(), this.args);
                    }
                    generator.setGenerationID(generationID);
                    generator.doGenerate(BasicMonitor.toMonitor((IProgressMonitor)monitor));
                } else {
                    Method main = generatorClass.getDeclaredMethod("main", String[].class);
                    String[] invocationArgs = new String[2 + this.args.size()];
                    invocationArgs[0] = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(this.model).toString();
                    invocationArgs[1] = this.targetFolder.getAbsolutePath();
                    int i = 0;
                    while (i < this.args.size()) {
                        invocationArgs[i + 2] = this.args.get(i);
                        ++i;
                    }
                    main.invoke(null, new Object[]{invocationArgs});
                }
                long end = System.currentTimeMillis();
                System.out.println(String.valueOf((end - start) / 1000L) + "s");
            }
            catch (NoSuchMethodException e) {
                Status status = new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e);
                AcceleoUIActivator.getDefault().getLog().log((IStatus)status);
            }
            catch (IllegalArgumentException e) {
                Status status = new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e);
                AcceleoUIActivator.getDefault().getLog().log((IStatus)status);
            }
            catch (IllegalAccessException e) {
                Status status = new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e);
                AcceleoUIActivator.getDefault().getLog().log((IStatus)status);
            }
            catch (InvocationTargetException e) {
                Status status = new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e);
                AcceleoUIActivator.getDefault().getLog().log((IStatus)status);
            }
            catch (IOException e) {
                Status status = new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e);
                AcceleoUIActivator.getDefault().getLog().log((IStatus)status);
            }
        }
        finally {
            AcceleoWorkspaceUtil.INSTANCE.reset();
        }
    }

    protected AbstractAcceleoGenerator safeInstantiate(Class<?> generatorClass) {
        AbstractAcceleoGenerator generator = null;
        try {
            generator = (AbstractAcceleoGenerator)generatorClass.newInstance();
        }
        catch (InstantiationException e) {
            Status status = new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e);
            AcceleoUIActivator.getDefault().getLog().log((IStatus)status);
        }
        catch (IllegalAccessException e) {
            Status status = new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e);
            AcceleoUIActivator.getDefault().getLog().log((IStatus)status);
        }
        return generator;
    }
}

