(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "vscode-languageserver", "../parser/yamlParser07"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    /*---------------------------------------------------------------------------------------------
     *  Copyright (c) Red Hat, Inc. All rights reserved.
     *  Licensed under the MIT License. See License.txt in the project root for license information.
     *--------------------------------------------------------------------------------------------*/
    const vscode_languageserver_1 = require("vscode-languageserver");
    const yamlParser07_1 = require("../parser/yamlParser07");
    function getFoldingRanges(document, context) {
        if (!document) {
            return;
        }
        const result = [];
        const doc = yamlParser07_1.parse(document.getText());
        for (const ymlDoc of doc.documents) {
            ymlDoc.visit((node) => {
                var _a;
                if ((node.type === 'property' && node.valueNode.type === 'array') ||
                    (node.type === 'object' && ((_a = node.parent) === null || _a === void 0 ? void 0 : _a.type) === 'array')) {
                    const startPos = document.positionAt(node.offset);
                    let endPos = document.positionAt(node.offset + node.length);
                    const textFragment = document.getText(vscode_languageserver_1.Range.create(startPos, endPos));
                    const newLength = textFragment.length - textFragment.trimRight().length;
                    if (newLength > 0) {
                        endPos = document.positionAt(node.offset + node.length - newLength);
                    }
                    result.push(vscode_languageserver_1.FoldingRange.create(startPos.line, endPos.line, startPos.character, endPos.character));
                }
                if (node.type === 'property' && node.valueNode.type === 'object') {
                    const startPos = document.positionAt(node.offset);
                    const endPos = document.positionAt(node.offset + node.length);
                    result.push(vscode_languageserver_1.FoldingRange.create(startPos.line, endPos.line, startPos.character, endPos.character));
                }
                return true;
            });
        }
        const rangeLimit = context && context.rangeLimit;
        if (typeof rangeLimit !== 'number' || result.length <= rangeLimit) {
            return result;
        }
        return result.slice(0, context.rangeLimit - 1);
    }
    exports.getFoldingRanges = getFoldingRanges;
});
//# sourceMappingURL=yamlFolding.js.map