/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionClassAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractCompositePartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractCyclicPartialRegionsAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.CompositePartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.CyclicPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionedTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionsAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.RootPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TransformationPartitioner;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtschedule.CyclicPartition;
import org.eclipse.qvtd.pivot.qvtschedule.LoadingPartition;
import org.eclipse.qvtd.pivot.qvtschedule.Partition;

public class CyclicPartitionsAnalysis
extends AbstractCyclicPartialRegionsAnalysis<PartitionsAnalysis> {
    protected final @NonNull TransformationPartitioner transformationPartitioner;
    protected final @NonNull Iterable<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>> leafPartitionAnalyses;
    protected final @NonNull Map<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>, @NonNull CyclicPartition> partitionAnalysis2cyclicPartition = new HashMap<PartialRegionAnalysis<PartitionsAnalysis>, CyclicPartition>();
    protected final @NonNull Map<@NonNull PartialRegionClassAnalysis<@NonNull PartitionsAnalysis>, @NonNull CyclicPartition> classAnalysis2cyclicPartition = new HashMap<PartialRegionClassAnalysis<PartitionsAnalysis>, CyclicPartition>();

    public CyclicPartitionsAnalysis(@NonNull TransformationPartitioner transformationPartitioner, @NonNull Iterable<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>> leafPartitionAnalyses) {
        this.transformationPartitioner = transformationPartitioner;
        this.leafPartitionAnalyses = leafPartitionAnalyses;
    }

    public @NonNull RootPartitionAnalysis analyze(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis) {
        Map<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>, @NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>>> leafPartitionAnalysis2predecessors = CompilerUtil.computeTransitivePredecessors(this.leafPartitionAnalyses, TransformationPartitioner.PARTITION_IMMEDIATE_PREDECESSORS, TransformationPartitioner.PARTITION_TRANSITIVE_PREDECESSORS);
        for (PartialRegionAnalysis<PartitionsAnalysis> leafPartitionAnalysis : leafPartitionAnalysis2predecessors.keySet()) {
            Partition partition = leafPartitionAnalysis.getPartition();
            if (partition instanceof LoadingPartition) continue;
            Set<@NonNull PartialRegionAnalysis<@NonNull PRA>> predecessors = leafPartitionAnalysis2predecessors.get(leafPartitionAnalysis);
            assert (predecessors != null);
            if (!predecessors.isEmpty()) continue;
            CompilerUtil.addPartitionError(partitionedTransformationAnalysis.getScheduleManager().getProblemHandler(), partition, "has no predecessors", new Object[0]);
        }
        Map<@NonNull PartialRegionAnalysis<@NonNull PRA>, @NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PRA>>> leafPartitionAnalysis2successors = CompilerUtil.computeTransitiveSuccessors(leafPartitionAnalysis2predecessors, TransformationPartitioner.PARTITION_TRANSITIVE_SUCCESSORS);
        HashSet<@NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>>> intersections = new HashSet<Set<PartialRegionAnalysis<PartitionsAnalysis>>>();
        for (PartialRegionAnalysis<PartitionsAnalysis> leafPartitionAnalysis : this.leafPartitionAnalyses) {
            Set<@NonNull PartialRegionAnalysis<@NonNull PRA>> predecessors = leafPartitionAnalysis2predecessors.get(leafPartitionAnalysis);
            Set<@NonNull PartialRegionAnalysis<@NonNull PRA>> successors = leafPartitionAnalysis2successors.get(leafPartitionAnalysis);
            HashSet<@NonNull PartialRegionAnalysis<@NonNull PRA>> intersection = new HashSet(predecessors);
            intersection.retainAll(successors);
            if (intersection.isEmpty()) continue;
            intersections.add(intersection);
        }
        if (intersections.isEmpty()) {
            String rootName = "\u00abroot\u00bb";
            return RootPartitionAnalysis.createRootPartitionAnalysis(partitionedTransformationAnalysis, this.transformationPartitioner.getTransformationAnalysis(), rootName, leafPartitionAnalysis2predecessors);
        }
        intersections.add(Sets.newHashSet(this.leafPartitionAnalyses));
        return this.createAcyclicPartitionHierarchy(partitionedTransformationAnalysis, intersections, leafPartitionAnalysis2predecessors);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull Set<@NonNull PartialRegionClassAnalysis<@NonNull PartitionsAnalysis>> computeClassAnalysisDependencies(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis, @NonNull Iterable<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>> nestedPartitions) {
        HashSet<@NonNull @NonNull E> consumedClassAnalyses = new HashSet();
        HashSet<@NonNull @NonNull E> superProducedClassAnalyses = new HashSet();
        for (PartialRegionAnalysis<PartitionsAnalysis> nestedPartitionAnalysis : nestedPartitions) {
            Iterable<PartialRegionClassAnalysis<PartitionsAnalysis>> superProducedClassAnalyses2;
            Iterable<@NonNull PartialRegionClassAnalysis<@NonNull PartitionsAnalysis>> consumedClassAnalyses2 = nestedPartitionAnalysis.getConsumedClassAnalyses();
            if (consumedClassAnalyses2 != null) {
                Iterables.addAll(consumedClassAnalyses, consumedClassAnalyses2);
            }
            if ((superProducedClassAnalyses2 = nestedPartitionAnalysis.getSuperProducedClassAnalyses()) == null) continue;
            Iterables.addAll(superProducedClassAnalyses, superProducedClassAnalyses2);
        }
        HashSet<@NonNull PartialRegionClassAnalysis<@NonNull PartitionsAnalysis>> cyclicClassAnalyses = new HashSet<PartialRegionClassAnalysis<PartitionsAnalysis>>(consumedClassAnalyses);
        cyclicClassAnalyses.retainAll(superProducedClassAnalyses);
        return cyclicClassAnalyses;
    }

    /*
     * Could not resolve type clashes
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull RootPartitionAnalysis createAcyclicPartitionHierarchy(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis, @NonNull Iterable<@NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>>> partitionings, @NonNull Map<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>, @NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>>> partition2predecessors) {
        ArrayList<@NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>>> sortedPartitionings = new ArrayList<Set<PartialRegionAnalysis<PartitionsAnalysis>>>();
        HashMap<@NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>>, @NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>>> partitioning2predecessors = new HashMap<Set<PartialRegionAnalysis<PartitionsAnalysis>>, Set<PartialRegionAnalysis<PartitionsAnalysis>>>();
        for (Set<PartialRegionAnalysis<PartitionsAnalysis>> partitioning : partitionings) {
            sortedPartitionings.add(partitioning);
            HashSet<@NonNull @NonNull E> predecessors = new HashSet();
            for (PartialRegionAnalysis<PartitionsAnalysis> partitionAnalysis : partitioning) {
                predecessors.addAll(partition2predecessors.get(partitionAnalysis));
            }
            partitioning2predecessors.put(partitioning, predecessors);
        }
        Collections.sort(sortedPartitionings, new PartitioningComparator(partitioning2predecessors));
        ArrayList<@NonNull AbstractCompositePartitionAnalysis> acyclicPartitionHierarchy = new ArrayList<AbstractCompositePartitionAnalysis>();
        int iMax = sortedPartitionings.size();
        assert (iMax >= 2);
        assert (((Set)sortedPartitionings.get(iMax - 1)).equals(Sets.newHashSet(this.leafPartitionAnalyses)));
        int i = 0;
        while (i < iMax - 1) {
            CyclicPartition oldCycleAnalysis;
            @NonNull @NonNull Set nestedPartitioning = (Set)sortedPartitionings.get(i);
            String cycleName = "\u00abcycle-" + i + "\u00bb";
            Set<@NonNull PartialRegionClassAnalysis<@NonNull PartitionsAnalysis>> cyclicClassAnalyses = this.computeClassAnalysisDependencies(partitionedTransformationAnalysis, nestedPartitioning);
            CyclicPartitionAnalysis nestedCyclicPartitionAnalysis = CyclicPartitionAnalysis.createCyclicPartitionAnalysis(partitionedTransformationAnalysis, cycleName, nestedPartitioning, partition2predecessors);
            CyclicPartition nestedCyclicPartition = (CyclicPartition)nestedCyclicPartitionAnalysis.getPartition();
            acyclicPartitionHierarchy.add(nestedCyclicPartitionAnalysis);
            for (PartialRegionAnalysis nestedPartition : nestedPartitioning) {
                oldCycleAnalysis = this.partitionAnalysis2cyclicPartition.put(nestedPartition, nestedCyclicPartition);
                assert (oldCycleAnalysis == null);
                partition2predecessors.remove(nestedPartition);
            }
            partition2predecessors.put(nestedCyclicPartitionAnalysis, (Set<PartialRegionAnalysis<PartitionsAnalysis>>)nestedCyclicPartitionAnalysis.getExplicitPredecessors());
            for (PartialRegionClassAnalysis cyclicClassAnalysis : cyclicClassAnalyses) {
                oldCycleAnalysis = this.classAnalysis2cyclicPartition.put(cyclicClassAnalysis, nestedCyclicPartition);
                assert (oldCycleAnalysis == null);
            }
            int j = i + 1;
            while (j < iMax) {
                @NonNull @NonNull Set nestingPartitioning = (Set)sortedPartitionings.get(j);
                int oldSize = nestingPartitioning.size();
                if (nestingPartitioning.removeAll(nestedPartitioning)) {
                    int newSize = nestingPartitioning.size();
                    assert (oldSize - newSize == nestedPartitioning.size());
                    nestingPartitioning.add(nestedCyclicPartitionAnalysis);
                }
                ++j;
            }
            for (PartialRegionAnalysis partition : partition2predecessors.keySet()) {
                Set<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>> predecessors = partition2predecessors.get(partition);
                assert (predecessors != null);
                int oldSize = predecessors.size();
                if (!predecessors.removeAll(nestedPartitioning)) continue;
                int newSize = predecessors.size();
                assert (oldSize - newSize == nestedPartitioning.size());
                predecessors.add(nestedCyclicPartitionAnalysis);
            }
            ++i;
        }
        String rootName = "\u00abroot\u00bb";
        RootPartitionAnalysis rootPartitionAnalysis = RootPartitionAnalysis.createRootPartitionAnalysis(partitionedTransformationAnalysis, this.transformationPartitioner.getTransformationAnalysis(), rootName, partition2predecessors);
        acyclicPartitionHierarchy.add(rootPartitionAnalysis);
        if (TransformationPartitioner.PARTITION_CYCLES.isActive()) {
            for (CompositePartitionAnalysis cyclicPartitionAnalysis : acyclicPartitionHierarchy) {
                TransformationPartitioner.PARTITION_CYCLES.println(cyclicPartitionAnalysis.getName());
                this.showCycles(TransformationPartitioner.PARTITION_CYCLES, cyclicPartitionAnalysis.getPartitionAnalyses());
            }
        }
        return rootPartitionAnalysis;
    }

    protected static class PartitioningComparator
    implements Comparator<Set<PartialRegionAnalysis<PartitionsAnalysis>>> {
        private final @NonNull Map<@NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>>, @NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>>> partitioning2predecessors;
        private @Nullable Map<@NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>>, @NonNull String> partitioning2tieBreaker = null;

        public PartitioningComparator(@NonNull Map<@NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>>, @NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>>> partitioning2predecessors) {
            this.partitioning2predecessors = partitioning2predecessors;
        }

        @Override
        public int compare(@NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>> o1, @NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>> o2) {
            int s2;
            Set<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>> predecessors1 = this.partitioning2predecessors.get(o1);
            Set<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>> predecessors2 = this.partitioning2predecessors.get(o2);
            assert (predecessors1 != null);
            assert (predecessors2 != null);
            int s1 = predecessors1.size();
            if (s1 == (s2 = predecessors2.size())) {
                s1 = o1.size();
                s2 = o2.size();
            }
            if (s1 != s2) {
                return s1 - s2;
            }
            String n1 = this.getTieBreaker(o1);
            String n2 = this.getTieBreaker(o2);
            return n1.compareTo(n2);
        }

        private @NonNull String getTieBreaker(@NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>> analyses) {
            String tieBreaker;
            Map<@NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>>, @NonNull String> partitioning2tieBreaker2 = this.partitioning2tieBreaker;
            if (partitioning2tieBreaker2 == null) {
                this.partitioning2tieBreaker = partitioning2tieBreaker2 = new HashMap<Set<PartialRegionAnalysis<PartitionsAnalysis>>, String>();
            }
            if ((tieBreaker = partitioning2tieBreaker2.get(analyses)) == null) {
                ArrayList<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>> sortedAnalyses = new ArrayList<PartialRegionAnalysis<PartitionsAnalysis>>(analyses);
                Collections.sort(sortedAnalyses, NameUtil.NAMEABLE_COMPARATOR);
                tieBreaker = String.valueOf(sortedAnalyses);
                partitioning2tieBreaker2.put(analyses, tieBreaker);
            }
            return tieBreaker;
        }
    }
}

