/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.PS_File;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.PS_Function;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.PS_HwpcEvent;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.PS_PModule;

public class PS_HwpcProfile {
    private String mapper;
    private PS_HwpcEvent hwpcEvent;
    private long period;
    private long totalSamples;
    private List<PS_PModule> moduleList = new ArrayList<PS_PModule>();

    PS_HwpcProfile() {
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append(super.toString());
        res.append("Profile Information\n");
        res.append("  Event Info:\n");
        res.append(this.hwpcEvent.toString());
        res.append("\n");
        res.append("  Period: " + this.period + "\n");
        res.append("  Total number of samples: " + this.totalSamples + "\n");
        res.append("Module Counts (" + this.moduleList.size() + " modules)\n");
        for (PS_PModule tmpModule : this.moduleList) {
            res.append("Module: " + tmpModule.getName() + "\n");
            for (PS_File tmpFile : tmpModule.getFiles()) {
                res.append("  File: " + tmpFile.getName() + "\n");
                for (PS_Function tmpFunction : tmpFile.getFunctions()) {
                    res.append("    Function: " + tmpFunction.getName() + "\n");
                    for (Map.Entry<Integer, Long> entry : tmpFunction.getMap().entrySet()) {
                        res.append("      Line number: " + entry.getKey() + ", number of samples: " + entry.getValue() + "\n");
                    }
                }
            }
        }
        return res.toString();
    }

    public String getMapper() {
        return this.mapper;
    }

    public PS_HwpcEvent getHwpcEvent() {
        return this.hwpcEvent;
    }

    public long getPeriod() {
        return this.period;
    }

    public long getTotalSamples() {
        return this.totalSamples;
    }

    public List<PS_PModule> getModules() {
        return this.moduleList;
    }

    public Map<String, Map<String, Map<String, Map<Long, Long>>>> getNestedModuleMap() {
        TreeMap<String, Map<String, Map<String, Map<Long, Long>>>> nestedModuleMap = new TreeMap<String, Map<String, Map<String, Map<Long, Long>>>>();
        for (PS_PModule tmpModule : this.moduleList) {
            String module = tmpModule.getName();
            for (PS_File tmpFile : tmpModule.getFiles()) {
                String file = tmpFile.getName();
                for (PS_Function tmpFunction : tmpFile.getFunctions()) {
                    String func = tmpFunction.getName();
                    for (Map.Entry<Integer, Long> entry : tmpFunction.getMap().entrySet()) {
                        TreeMap<Long, Long> nestedLineMap;
                        TreeMap nestedFuncMap;
                        int line = entry.getKey();
                        Long numSamples = entry.getValue();
                        TreeMap nestedFileMap = (TreeMap)nestedModuleMap.get(module);
                        if (nestedFileMap == null) {
                            nestedFileMap = new TreeMap();
                            nestedModuleMap.put(module, nestedFileMap);
                        }
                        if ((nestedFuncMap = (TreeMap)nestedFileMap.get(file)) == null) {
                            nestedFuncMap = new TreeMap();
                            nestedFileMap.put(file, nestedFuncMap);
                        }
                        if ((nestedLineMap = (TreeMap<Long, Long>)nestedFuncMap.get(func)) == null) {
                            nestedLineMap = new TreeMap<Long, Long>();
                            nestedFuncMap.put(func, nestedLineMap);
                        }
                        Long value = (Long)nestedLineMap.get(line);
                        nestedLineMap.put(Long.valueOf(line), value == null ? numSamples : numSamples + value);
                    }
                }
            }
        }
        return nestedModuleMap;
    }

    void setMapper(String in) {
        this.mapper = in;
    }

    void setHwpcEvent(PS_HwpcEvent in) {
        this.hwpcEvent = in;
    }

    void setPeriod(long in) {
        this.period = in;
    }

    void setTotalSamples(long in) {
        this.totalSamples = in;
    }

    void setModules(List<PS_PModule> in) {
        this.moduleList = in;
    }
}

