/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jface.dialogs;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.passage.lic.api.access.PermissionEmitterRegistry;
import org.eclipse.passage.lic.internal.jface.dialogs.LicensingRegistryPage;
import org.eclipse.passage.lic.internal.jface.i18n.JFaceMessages;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ConditionTypePage
extends LicensingRegistryPage<PermissionEmitterRegistry> {
    public ConditionTypePage() {
        super(PermissionEmitterRegistry.class);
    }

    @Override
    protected void createContent(Composite parent, PermissionEmitterRegistry registry) {
        Iterable conditionTypes = registry.getSupportedConditionTypes();
        GridDataFactory groupData = GridDataFactory.fillDefaults().align(4, 1).grab(true, false);
        for (String type : conditionTypes) {
            Group group = new Group(parent, 0);
            group.setText(registry.getConditionTypeName(type));
            group.setData((Object)type);
            group.setLayout((Layout)new GridLayout(1, false));
            group.setLayoutData((Object)groupData.create());
            Label description = new Label((Composite)group, 64);
            description.setText(registry.getConditionTypeDescription(type));
        }
    }

    @Override
    protected String getConfigurationErrorMessage() {
        return JFaceMessages.ConditionTypePage_e_not_available;
    }
}

