/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.SubmoduleConfig;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.pgm.AbstractFetchCommand;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.TagOpt;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Command(common=true, usage="usage_updateRemoteRefsFromAnotherRepository")
class Fetch
extends AbstractFetchCommand
implements FetchCommand.Callback {
    @Option(name="--timeout", metaVar="metaVar_seconds", usage="usage_abortConnectionIfNoActivity")
    int timeout = -1;
    @Option(name="--fsck", usage="usage_performFsckStyleChecksOnReceive")
    private Boolean fsck;
    @Option(name="--prune", usage="usage_pruneStaleTrackingRefs")
    private Boolean prune;
    @Option(name="--dry-run")
    private boolean dryRun;
    @Option(name="--thin", usage="usage_fetchThinPack")
    private Boolean thin;
    @Option(name="--quiet", usage="usage_quiet")
    private Boolean quiet;
    @Option(name="--tags", usage="usage_tags", aliases={"-t"})
    private Boolean tags;
    @Option(name="--force", usage="usage_forcedFetch", aliases={"-f"})
    private Boolean force;
    private SubmoduleConfig.FetchRecurseSubmodulesMode recurseSubmodules;
    @Argument(index=0, metaVar="metaVar_uriish")
    private String remote = "origin";
    @Argument(index=1, metaVar="metaVar_refspec")
    private List<RefSpec> toget;

    Fetch() {
    }

    @Option(name="--no-fsck")
    void nofsck(boolean ignored) {
        this.fsck = Boolean.FALSE;
    }

    @Option(name="--no-thin")
    void nothin(boolean ignored) {
        this.thin = Boolean.FALSE;
    }

    @Option(name="--no-tags", usage="usage_notags", aliases={"-n"})
    void notags(boolean ignored) {
        this.tags = Boolean.FALSE;
    }

    @Option(name="--recurse-submodules", usage="usage_recurseSubmodules")
    void recurseSubmodules(String mode) {
        if (mode != null && !mode.isEmpty()) {
            SubmoduleConfig.FetchRecurseSubmodulesMode[] fetchRecurseSubmodulesModeArray = SubmoduleConfig.FetchRecurseSubmodulesMode.values();
            int n = fetchRecurseSubmodulesModeArray.length;
            int n2 = 0;
            while (n2 < n) {
                SubmoduleConfig.FetchRecurseSubmodulesMode m = fetchRecurseSubmodulesModeArray[n2];
                if (m.matchConfigValue(mode)) {
                    this.recurseSubmodules = m;
                    return;
                }
                ++n2;
            }
            throw Fetch.die(MessageFormat.format(CLIText.get().invalidRecurseSubmodulesMode, mode));
        }
        this.recurseSubmodules = SubmoduleConfig.FetchRecurseSubmodulesMode.YES;
    }

    @Option(name="--no-recurse-submodules", usage="usage_noRecurseSubmodules")
    void noRecurseSubmodules(boolean ignored) {
        this.recurseSubmodules = SubmoduleConfig.FetchRecurseSubmodulesMode.NO;
    }

    @Override
    protected void run() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Git git = new Git(this.db);){
                FetchResult result;
                FetchCommand fetch = git.fetch();
                if (this.fsck != null) {
                    fetch.setCheckFetchedObjects(this.fsck.booleanValue());
                }
                if (this.prune != null) {
                    fetch.setRemoveDeletedRefs(this.prune.booleanValue());
                }
                if (this.toget != null) {
                    fetch.setRefSpecs(this.toget);
                }
                if (this.tags != null) {
                    fetch.setTagOpt(this.tags != false ? TagOpt.FETCH_TAGS : TagOpt.NO_TAGS);
                }
                if (this.timeout >= 0) {
                    fetch.setTimeout(this.timeout);
                }
                fetch.setDryRun(this.dryRun);
                fetch.setRemote(this.remote);
                if (this.thin != null) {
                    fetch.setThin(this.thin.booleanValue());
                }
                if (this.quiet == null || !this.quiet.booleanValue()) {
                    fetch.setProgressMonitor((ProgressMonitor)new TextProgressMonitor((Writer)this.errw));
                }
                fetch.setRecurseSubmodules(this.recurseSubmodules).setCallback((FetchCommand.Callback)this);
                if (this.force != null) {
                    fetch.setForceUpdate(this.force.booleanValue());
                }
                if ((result = fetch.call()).getTrackingRefUpdates().isEmpty() && result.submoduleResults().isEmpty()) {
                    return;
                }
                this.showFetchResult(result);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | GitAPIException e) {
            throw Fetch.die(e.getMessage(), e);
        }
    }

    public void fetchingSubmodule(String name) {
        try {
            this.outw.println(MessageFormat.format(CLIText.get().fetchingSubmodule, name));
            this.outw.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

