/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.transaction;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.transaction.CDOSavepoint;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.transaction.CDOXATransaction;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewSet;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.internal.cdo.transaction.CDOSingleTransactionStrategyImpl;
import org.eclipse.emf.internal.cdo.transaction.CDOXACommitContextImpl;
import org.eclipse.emf.internal.cdo.transaction.CDOXASavepointImpl;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.CDOTransactionStrategy;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.emf.spi.cdo.InternalCDOUserSavepoint;
import org.eclipse.emf.spi.cdo.InternalCDOXASavepoint;
import org.eclipse.emf.spi.cdo.InternalCDOXATransaction;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.om.monitor.EclipseMonitor;
import org.eclipse.net4j.util.om.monitor.SubProgressMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class CDOXATransactionImpl
implements InternalCDOXATransaction {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_TRANSACTION, CDOXATransactionImpl.class);
    private static boolean SEQUENTIAL_EXECUTION = true;
    private List<InternalCDOTransaction> transactions = new ArrayList<InternalCDOTransaction>();
    private boolean allowRequestFromTransactionEnabled = true;
    private ExecutorService executorService = this.createExecutorService();
    private Map<InternalCDOTransaction, InternalCDOXATransaction.InternalCDOXACommitContext> activeContexts = new HashMap<InternalCDOTransaction, InternalCDOXATransaction.InternalCDOXACommitContext>();
    private Map<InternalCDOTransaction, Set<CDOID>> requestedCDOIDs = new HashMap<InternalCDOTransaction, Set<CDOID>>();
    private InternalCDOXASavepoint lastSavepoint;
    private InternalCDOXASavepoint firstSavepoint = this.lastSavepoint = this.createSavepoint(null);
    private CDOTransactionStrategy transactionStrategy = this.createTransactionStrategy();
    private CDOXAInternalAdapter internalAdapter = this.createInternalAdapter();

    @Override
    public boolean isAllowRequestFromTransactionEnabled() {
        return this.allowRequestFromTransactionEnabled;
    }

    @Override
    public void setAllowRequestFromTransactionEnabled(boolean on) {
        this.allowRequestFromTransactionEnabled = on;
    }

    @Override
    public void add(InternalCDOTransaction transaction) {
        transaction.setTransactionStrategy(this.transactionStrategy);
    }

    @Override
    public void remove(InternalCDOTransaction transaction) {
        if (transaction != null) {
            transaction.setTransactionStrategy(null);
        }
    }

    @Override
    public synchronized void add(CDOViewSet viewSet) {
        CDOXATransaction transSet = CDOUtil.getXATransaction(viewSet);
        if (transSet != null) {
            throw new IllegalArgumentException(Messages.getString("CDOXATransactionImpl.0"));
        }
        viewSet.eAdapters().add((Object)this.internalAdapter);
        for (InternalCDOTransaction transaction : this.getTransactions(viewSet)) {
            this.add(transaction);
        }
    }

    @Override
    public synchronized void remove(CDOViewSet viewSet) {
        CDOXATransaction transSet = CDOUtil.getXATransaction(viewSet);
        if (transSet != this) {
            throw new IllegalArgumentException(Messages.getString("CDOXATransactionImpl.1"));
        }
        for (InternalCDOTransaction transaction : this.getTransactions(viewSet)) {
            this.remove(transaction);
        }
        viewSet.eAdapters().remove((Object)this.internalAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(InternalCDOTransaction transaction, CDOID object) {
        Map<InternalCDOTransaction, Set<CDOID>> map = this.requestedCDOIDs;
        synchronized (map) {
            Set<CDOID> ids = this.requestedCDOIDs.get(transaction);
            if (ids == null) {
                ids = new HashSet<CDOID>();
                this.requestedCDOIDs.put(transaction, ids);
            }
            ids.add(object);
        }
    }

    public CDOID[] get(InternalCDOTransaction transaction) {
        Set<CDOID> ids = this.requestedCDOIDs.get(transaction);
        return ids.toArray(new CDOID[ids.size()]);
    }

    @Override
    public InternalCDOXATransaction.InternalCDOXACommitContext getCommitContext(CDOTransaction transaction) {
        return this.activeContexts.get(transaction);
    }

    /*
     * Unable to fully structure code
     */
    private void send(Collection<InternalCDOXATransaction.InternalCDOXACommitContext> xaContexts, IProgressMonitor progressMonitor) throws InterruptedException, ExecutionException {
        xaContextSize = xaContexts.size();
        if (progressMonitor != null) {
            progressMonitor.beginTask("", xaContextSize);
        }
        try {
            futures = new HashMap<Future<Object>, InternalCDOXATransaction.InternalCDOXACommitContext>();
            for (InternalCDOXATransaction.InternalCDOXACommitContext xaContext : xaContexts) {
                if (progressMonitor != null) {
                    xaContext.setProgressMonitor((IProgressMonitor)new EclipseMonitor.SynchronizedSubProgressMonitor(progressMonitor, 1));
                }
                future = this.executorService.submit(xaContext);
                futures.put(future, xaContext);
            }
            nbProcessDone = 0;
            do {
                it = futures.entrySet().iterator();
                while (it.hasNext()) {
                    entry = it.next();
                    future = (Future)entry.getKey();
                    xaContext = (InternalCDOXATransaction.InternalCDOXACommitContext)entry.getValue();
                    try {
                        future.get(1000L, TimeUnit.MILLISECONDS);
                        ++nbProcessDone;
                        it.remove();
                        if (!CDOXATransactionImpl.TRACER.isEnabled()) continue;
                        CDOXATransactionImpl.TRACER.format("Got {0}", new Object[]{xaContext});
                    }
                    catch (TimeoutException ex) {
                        if (!CDOXATransactionImpl.TRACER.isEnabled()) continue;
                        CDOXATransactionImpl.TRACER.format("Waiting for {0}", new Object[]{xaContext});
                    }
                }
            } while (xaContextSize != nbProcessDone);
        }
        finally {
            if (progressMonitor != null) {
                progressMonitor.done();
            }
            ** for (xaContext : xaContexts)
        }
lbl-1000:
        // 1 sources

        {
            xaContext.setProgressMonitor(null);
            continue;
        }
lbl40:
        // 1 sources

    }

    private void cleanUp() {
        this.activeContexts.clear();
        this.requestedCDOIDs.clear();
    }

    private List<InternalCDOTransaction> getTransactions(CDOViewSet viewSet) {
        ArrayList<InternalCDOTransaction> transactions = new ArrayList<InternalCDOTransaction>();
        CDOView[] cDOViewArray = viewSet.getViews();
        int n = cDOViewArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOView view = cDOViewArray[n2];
            if (view instanceof InternalCDOTransaction) {
                transactions.add((InternalCDOTransaction)view);
            }
            ++n2;
        }
        return transactions;
    }

    @Override
    public CDOCommitInfo commit() throws CommitException {
        return this.commit(null);
    }

    @Override
    public CDOCommitInfo commit(IProgressMonitor monitor) throws CommitException {
        this.commitPrepare(monitor);
        int phase = 0;
        try {
            try {
                while (phase <= 2) {
                    this.commitPhase(monitor);
                    ++phase;
                }
            }
            catch (Exception ex) {
                this.commitException(monitor, phase, ex);
                this.commitFinally(monitor);
            }
        }
        finally {
            this.commitFinally(monitor);
        }
        return null;
    }

    public void commitPrepare(IProgressMonitor progressMonitor) {
        if (progressMonitor != null) {
            progressMonitor.beginTask(Messages.getString("CDOXATransactionImpl.4"), 3);
        }
        for (InternalCDOTransaction transaction : this.transactions) {
            InternalCDOTransaction.InternalCDOCommitContext context = transaction.createCommitContext();
            CDOXACommitContextImpl xaContext = this.createXACommitContext(context);
            xaContext.setState(CDOXAPhase1State.INSTANCE);
            this.activeContexts.put(transaction, xaContext);
        }
    }

    public void commitPhase(IProgressMonitor progressMonitor) throws InterruptedException, ExecutionException {
        this.send(this.activeContexts.values(), (IProgressMonitor)(progressMonitor != null ? new SubProgressMonitor(progressMonitor, 1) : null));
    }

    public void commitException(IProgressMonitor progressMonitor, int phase, Exception ex) throws CommitException {
        if (phase < 2) {
            for (InternalCDOXATransaction.InternalCDOXACommitContext xaContext : this.activeContexts.values()) {
                xaContext.setState(CDOXACancel.INSTANCE);
            }
            try {
                this.send(this.activeContexts.values(), (IProgressMonitor)(progressMonitor != null ? new SubProgressMonitor(progressMonitor, 2 - phase) : null));
            }
            catch (InterruptedException ex1) {
                throw WrappedException.wrap((Exception)ex1);
            }
            catch (ExecutionException ex1) {
                OM.LOG.warn((Throwable)ex1);
            }
        }
        throw new CommitException(ex);
    }

    public void commitFinally(IProgressMonitor progressMonitor) {
        this.cleanUp();
        if (progressMonitor != null) {
            progressMonitor.done();
        }
    }

    @Override
    public InternalCDOXASavepoint getLastSavepoint() {
        return this.lastSavepoint;
    }

    @Override
    public void rollback() {
        this.rollback(this.firstSavepoint);
    }

    @Override
    public void rollback(InternalCDOXASavepoint savepoint) {
        if (!savepoint.isValid()) {
            throw new IllegalArgumentException(String.valueOf(Messages.getString("CDOXATransactionImpl.7")) + savepoint);
        }
        List<CDOSavepoint> savepoints = savepoint.getSavepoints();
        if (savepoints == null) {
            savepoints = this.getListSavepoints();
        }
        for (CDOSavepoint indexSavePoint : savepoints) {
            InternalCDOTransaction transaction = (InternalCDOTransaction)indexSavePoint.getTransaction();
            CDOSingleTransactionStrategyImpl.INSTANCE.rollback(transaction, (InternalCDOUserSavepoint)((Object)indexSavePoint));
        }
        this.lastSavepoint = savepoint;
        this.lastSavepoint.setNextSavepoint(null);
        this.lastSavepoint.setSavepoints(null);
    }

    @Override
    public InternalCDOXASavepoint setSavepoint() {
        List<CDOSavepoint> savepoints = this.getListSavepoints();
        for (CDOSavepoint savepoint : savepoints) {
            InternalCDOTransaction transaction = (InternalCDOTransaction)savepoint.getTransaction();
            CDOSingleTransactionStrategyImpl.INSTANCE.setSavepoint(transaction);
        }
        this.getLastSavepoint().setSavepoints(savepoints);
        this.lastSavepoint = this.createSavepoint(this.getLastSavepoint());
        return this.lastSavepoint;
    }

    public String toString() {
        return MessageFormat.format("CDOXATransaction[size={0}]", this.transactions.size());
    }

    protected CDOXACommitContextImpl createXACommitContext(InternalCDOTransaction.InternalCDOCommitContext context) {
        return new CDOXACommitContextImpl(this, context);
    }

    protected CDOXATransactionStrategyImpl createTransactionStrategy() {
        return new CDOXATransactionStrategyImpl(this);
    }

    protected CDOXAInternalAdapter createInternalAdapter() {
        return new CDOXAInternalAdapter(this);
    }

    protected CDOXASavepointImpl createSavepoint(InternalCDOXASavepoint lastSavepoint) {
        return new CDOXASavepointImpl(this, lastSavepoint);
    }

    protected final ExecutorService createExecutorService() {
        if (SEQUENTIAL_EXECUTION) {
            return new AbstractExecutorService(){

                @Override
                public void execute(Runnable command) {
                    command.run();
                }

                @Override
                public List<Runnable> shutdownNow() {
                    return null;
                }

                @Override
                public void shutdown() {
                }

                @Override
                public boolean isTerminated() {
                    return false;
                }

                @Override
                public boolean isShutdown() {
                    return false;
                }

                @Override
                public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
                    return false;
                }
            };
        }
        return Executors.newFixedThreadPool(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CDOSavepoint> getListSavepoints() {
        List<InternalCDOTransaction> list = this.transactions;
        synchronized (list) {
            ArrayList<CDOSavepoint> savepoints = new ArrayList<CDOSavepoint>();
            for (InternalCDOTransaction transaction : this.transactions) {
                savepoints.add(transaction.getLastSavepoint());
            }
            return savepoints;
        }
    }

    public static class CDOXACancel
    extends InternalCDOXATransaction.InternalCDOXACommitContext.CDOXAState {
        public static final CDOXACancel INSTANCE = new CDOXACancel();

        @Override
        public void handle(InternalCDOXATransaction.InternalCDOXACommitContext xaContext, IProgressMonitor progressMonitor) throws Exception {
            CDOSessionProtocol sessionProtocol = xaContext.getTransaction().getSession().getSessionProtocol();
            CDOSessionProtocol.CommitTransactionResult result = sessionProtocol.commitXATransactionCancel(xaContext, EclipseMonitor.convert((IProgressMonitor)progressMonitor));
            this.check_result(result);
        }

        public String toString() {
            return "CANCEL";
        }
    }

    public static class CDOXAInternalAdapter
    implements Adapter {
        private InternalCDOXATransaction xaTransaction;

        public CDOXAInternalAdapter(InternalCDOXATransaction xaTransaction) {
            this.xaTransaction = xaTransaction;
        }

        public InternalCDOXATransaction getXATransaction() {
            return this.xaTransaction;
        }

        public Notifier getTarget() {
            return null;
        }

        public boolean isAdapterForType(Object type) {
            return false;
        }

        public void notifyChanged(Notification notification) {
            switch (notification.getEventType()) {
                case 3: {
                    if (!(notification.getNewValue() instanceof InternalCDOTransaction)) break;
                    this.getXATransaction().add((InternalCDOTransaction)notification.getNewValue());
                    break;
                }
                case 4: {
                    if (!(notification.getOldValue() instanceof InternalCDOTransaction)) break;
                    this.getXATransaction().remove((InternalCDOTransaction)notification.getNewValue());
                }
            }
        }

        public void setTarget(Notifier newTarget) {
        }
    }

    public static class CDOXAPhase1State
    extends InternalCDOXATransaction.InternalCDOXACommitContext.CDOXAState {
        public static final CDOXAPhase1State INSTANCE = new CDOXAPhase1State();

        @Override
        public void handle(InternalCDOXATransaction.InternalCDOXACommitContext xaContext, IProgressMonitor progressMonitor) throws Exception {
            xaContext.preCommit();
            CDOSessionProtocol.CommitTransactionResult result = null;
            if (xaContext.getTransaction().isDirty()) {
                CDOSessionProtocol sessionProtocol = xaContext.getTransaction().getSession().getSessionProtocol();
                result = sessionProtocol.commitXATransactionPhase1(xaContext, EclipseMonitor.convert((IProgressMonitor)progressMonitor));
                this.check_result(result);
            }
            xaContext.setResult(result);
            xaContext.setState(CDOXAPhase2State.INSTANCE);
        }

        public String toString() {
            return "PHASE1";
        }
    }

    public static class CDOXAPhase2State
    extends InternalCDOXATransaction.InternalCDOXACommitContext.CDOXAState {
        public static final CDOXAPhase2State INSTANCE = new CDOXAPhase2State();

        @Override
        public void handle(InternalCDOXATransaction.InternalCDOXACommitContext xaContext, IProgressMonitor progressMonitor) throws Exception {
            if (xaContext.getTransaction().isDirty()) {
                CDOSessionProtocol sessionProtocol = xaContext.getTransaction().getSession().getSessionProtocol();
                CDOSessionProtocol.CommitTransactionResult result = sessionProtocol.commitXATransactionPhase2(xaContext, EclipseMonitor.convert((IProgressMonitor)progressMonitor));
                this.check_result(result);
            }
            xaContext.setState(CDOXAPhase3State.INSTANCE);
        }

        public String toString() {
            return "PHASE2";
        }
    }

    public static class CDOXAPhase3State
    extends InternalCDOXATransaction.InternalCDOXACommitContext.CDOXAState {
        public static final CDOXAPhase3State INSTANCE = new CDOXAPhase3State();

        @Override
        public void handle(InternalCDOXATransaction.InternalCDOXACommitContext xaContext, IProgressMonitor progressMonitor) throws Exception {
            if (xaContext.getTransaction().isDirty()) {
                CDOSessionProtocol sessionProtocol = xaContext.getTransaction().getSession().getSessionProtocol();
                CDOSessionProtocol.CommitTransactionResult result = sessionProtocol.commitXATransactionPhase3(xaContext, EclipseMonitor.convert((IProgressMonitor)progressMonitor));
                this.check_result(result);
            }
            xaContext.postCommit(xaContext.getResult());
            xaContext.setState(null);
        }

        public String toString() {
            return "PHASE3";
        }
    }

    private final class CDOXATransactionStrategyImpl
    implements CDOTransactionStrategy {
        private InternalCDOXATransaction xaTransaction;

        public CDOXATransactionStrategyImpl(InternalCDOXATransaction xaTransaction) {
            this.xaTransaction = xaTransaction;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setTarget(InternalCDOTransaction transaction) {
            List list = CDOXATransactionImpl.this.transactions;
            synchronized (list) {
                CDOXATransactionImpl.this.transactions.add(transaction);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unsetTarget(InternalCDOTransaction transaction) {
            List list = CDOXATransactionImpl.this.transactions;
            synchronized (list) {
                CDOXATransactionImpl.this.transactions.remove(transaction);
            }
        }

        private void checkAccess() {
            if (!CDOXATransactionImpl.this.allowRequestFromTransactionEnabled) {
                throw new IllegalStateException(Messages.getString("CDOXATransactionImpl.8"));
            }
        }

        @Override
        public CDOCommitInfo commit(InternalCDOTransaction transactionCommit, IProgressMonitor progressMonitor) throws Exception {
            this.checkAccess();
            return this.xaTransaction.commit(progressMonitor);
        }

        @Override
        public void rollback(InternalCDOTransaction transaction, InternalCDOUserSavepoint savepoint) {
            this.checkAccess();
            this.xaTransaction.rollback((InternalCDOXASavepoint)savepoint);
        }

        @Override
        public InternalCDOUserSavepoint setSavepoint(InternalCDOTransaction transaction) {
            this.checkAccess();
            return this.xaTransaction.setSavepoint();
        }
    }
}

