/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.construction.plancompiler;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.log4j.Logger;
import org.eclipse.viatra.query.runtime.matchers.backend.CommonQueryHintOptions;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackendHintProvider;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.context.IPosetComparator;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryCacheContext;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryMetaContext;
import org.eclipse.viatra.query.runtime.matchers.planning.IQueryPlannerStrategy;
import org.eclipse.viatra.query.runtime.matchers.planning.SubPlan;
import org.eclipse.viatra.query.runtime.matchers.planning.helpers.BuildHelper;
import org.eclipse.viatra.query.runtime.matchers.planning.operations.PApply;
import org.eclipse.viatra.query.runtime.matchers.planning.operations.PEnumerate;
import org.eclipse.viatra.query.runtime.matchers.planning.operations.PJoin;
import org.eclipse.viatra.query.runtime.matchers.planning.operations.POperation;
import org.eclipse.viatra.query.runtime.matchers.planning.operations.PProject;
import org.eclipse.viatra.query.runtime.matchers.planning.operations.PStart;
import org.eclipse.viatra.query.runtime.matchers.psystem.DeferredPConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.EnumerablePConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PTraceable;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.aggregations.IMultisetAggregationOperator;
import org.eclipse.viatra.query.runtime.matchers.psystem.analysis.QueryAnalyzer;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.AggregatorConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExpressionEvaluation;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.Inequality;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.NegativePatternCall;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.PatternMatchCounter;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.TypeFilterConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.BinaryReflexiveTransitiveClosure;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.BinaryTransitiveClosure;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.ConstantValue;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PVisibility;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.IRewriterTraceCollector;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.PBodyNormalizer;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.PDisjunctionRewriter;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.PDisjunctionRewriterCacher;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.SurrogateQueryRewriter;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;
import org.eclipse.viatra.query.runtime.rete.construction.plancompiler.CompilerHelper;
import org.eclipse.viatra.query.runtime.rete.construction.plancompiler.RecursionCutoffPoint;
import org.eclipse.viatra.query.runtime.rete.recipes.AggregatorIndexerRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.AntiJoinRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.CheckRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.ConstantRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.CountAggregatorRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.DiscriminatorBucketRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.DiscriminatorDispatcherRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.EqualityFilterRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.IndexerRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.InequalityFilterRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.InputFilterRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.InputRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.JoinRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.Mask;
import org.eclipse.viatra.query.runtime.rete.recipes.MonotonicityInfo;
import org.eclipse.viatra.query.runtime.rete.recipes.ProjectionIndexerRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.RecipesFactory;
import org.eclipse.viatra.query.runtime.rete.recipes.ReteNodeRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.SingleColumnAggregatorRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.TransitiveClosureRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.TrimmerRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.UniquenessEnforcerRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.helper.RecipesHelper;
import org.eclipse.viatra.query.runtime.rete.traceability.CompiledQuery;
import org.eclipse.viatra.query.runtime.rete.traceability.CompiledSubPlan;
import org.eclipse.viatra.query.runtime.rete.traceability.ParameterProjectionTrace;
import org.eclipse.viatra.query.runtime.rete.traceability.PlanningTrace;
import org.eclipse.viatra.query.runtime.rete.traceability.RecipeTraceInfo;
import org.eclipse.viatra.query.runtime.rete.util.ReteHintOptions;

public class ReteRecipeCompiler {
    private final IQueryPlannerStrategy plannerStrategy;
    private final IQueryMetaContext metaContext;
    private final IQueryBackendHintProvider hintProvider;
    private final PDisjunctionRewriter normalizer;
    private final QueryAnalyzer queryAnalyzer;
    private final Logger logger;
    static final RecipesFactory FACTORY = RecipesFactory.eINSTANCE;
    private Map<PBody, SubPlan> plannerCache = new HashMap<PBody, SubPlan>();
    private Set<PBody> planningInProgress = new HashSet<PBody>();
    private Map<PQuery, CompiledQuery> queryCompilerCache = new HashMap<PQuery, CompiledQuery>();
    private Set<PQuery> compilationInProgress = new HashSet<PQuery>();
    private Multimap<PQuery, RecursionCutoffPoint> recursionCutoffPoints = HashMultimap.create();
    private Map<SubPlan, CompiledSubPlan> subPlanCompilerCache = new HashMap<SubPlan, CompiledSubPlan>();
    private Map<ReteNodeRecipe, SubPlan> compilerBackTrace = new HashMap<ReteNodeRecipe, SubPlan>();

    public ReteRecipeCompiler(IQueryPlannerStrategy plannerStrategy, Logger logger, IQueryMetaContext metaContext, IQueryCacheContext queryCacheContext, IQueryBackendHintProvider hintProvider, QueryAnalyzer queryAnalyzer) {
        this.plannerStrategy = plannerStrategy;
        this.logger = logger;
        this.metaContext = metaContext;
        this.queryAnalyzer = queryAnalyzer;
        this.normalizer = new PDisjunctionRewriterCacher(new PDisjunctionRewriter[]{new SurrogateQueryRewriter(), new PBodyNormalizer(metaContext){

            protected boolean shouldExpandWeakenedAlternatives(PQuery query) {
                QueryEvaluationHint hint = ReteRecipeCompiler.this.hintProvider.getQueryEvaluationHint(query);
                Boolean expandWeakenedAlternativeConstraints = (Boolean)ReteHintOptions.expandWeakenedAlternativeConstraints.getValueOrDefault(hint);
                return expandWeakenedAlternativeConstraints;
            }
        }});
        this.hintProvider = hintProvider;
    }

    public void reset() {
        this.plannerCache.clear();
        this.planningInProgress.clear();
        this.queryCompilerCache.clear();
        this.subPlanCompilerCache.clear();
        this.compilerBackTrace.clear();
    }

    public CompiledQuery getCompiledForm(PQuery query) {
        CompiledQuery compiled = this.queryCompilerCache.get(query);
        if (compiled == null) {
            boolean reentrant;
            IRewriterTraceCollector traceCollector = (IRewriterTraceCollector)CommonQueryHintOptions.normalizationTraceCollector.getValueOrDefault(this.hintProvider.getQueryEvaluationHint(query));
            if (traceCollector != null) {
                traceCollector.addTrace((PTraceable)query, (PTraceable)query);
            }
            boolean bl = reentrant = !this.compilationInProgress.add(query);
            if (reentrant) {
                RecursionCutoffPoint cutoffPoint = new RecursionCutoffPoint(query, this.getHints(query), this.metaContext);
                this.recursionCutoffPoints.put((Object)query, (Object)cutoffPoint);
                return cutoffPoint.getCompiledQuery();
            }
            try {
                compiled = this.compileProduction(query);
                this.queryCompilerCache.put(query, compiled);
                for (RecursionCutoffPoint cutoffPoint : this.recursionCutoffPoints.get((Object)query)) {
                    cutoffPoint.mend(compiled);
                }
            }
            finally {
                this.compilationInProgress.remove(query);
            }
        }
        return compiled;
    }

    public CompiledSubPlan getCompiledForm(SubPlan plan) {
        CompiledSubPlan compiled = this.subPlanCompilerCache.get(plan);
        if (compiled == null) {
            compiled = this.doCompileDispatch(plan);
            this.subPlanCompilerCache.put(plan, compiled);
            this.compilerBackTrace.put(compiled.getRecipe(), plan);
        }
        return compiled;
    }

    public SubPlan getPlan(PBody pBody) {
        SubPlan plan;
        PQuery pQuery = pBody.getPattern();
        if (!this.compilationInProgress.contains(pQuery)) {
            this.getCompiledForm(pQuery);
        }
        if ((plan = this.plannerCache.get(pBody)) == null) {
            boolean reentrant;
            boolean bl = reentrant = !this.planningInProgress.add(pBody);
            if (reentrant) {
                throw new IllegalArgumentException("Planning-level recursion unsupported: " + pBody.getPattern().getFullyQualifiedName());
            }
            try {
                plan = this.plannerStrategy.plan(pBody, this.logger, this.metaContext);
                this.plannerCache.put(pBody, plan);
            }
            finally {
                this.planningInProgress.remove(pBody);
            }
        }
        return plan;
    }

    private CompiledQuery compileProduction(PQuery query) {
        ArrayList<SubPlan> bodyPlans = new ArrayList<SubPlan>();
        this.normalizer.setTraceCollector((IRewriterTraceCollector)CommonQueryHintOptions.normalizationTraceCollector.getValueOrDefault(this.hintProvider.getQueryEvaluationHint(query)));
        for (PBody pBody : this.normalizer.rewrite(query).getBodies()) {
            SubPlan bodyPlan = this.getPlan(pBody);
            bodyPlans.add(bodyPlan);
        }
        return this.doCompileProduction(query, bodyPlans);
    }

    private CompiledQuery doCompileProduction(PQuery query, Collection<SubPlan> bodies) {
        HashMap<PBody, RecipeTraceInfo> bodyFinalTraces = new HashMap<PBody, RecipeTraceInfo>();
        HashSet<ReteNodeRecipe> bodyFinalRecipes = new HashSet<ReteNodeRecipe>();
        for (SubPlan bodyFinalPlan : bodies) {
            bodyFinalPlan = BuildHelper.eliminateTrailingProjections((SubPlan)bodyFinalPlan);
            CompiledSubPlan compiledBody = this.getCompiledForm(bodyFinalPlan);
            RecipeTraceInfo finalTrace = this.projectBodyFinalToParameters(compiledBody, false);
            bodyFinalTraces.put(bodyFinalPlan.getBody(), finalTrace);
            bodyFinalRecipes.add(finalTrace.getRecipe());
        }
        CompiledQuery compiled = CompilerHelper.makeQueryTrace(query, bodyFinalTraces, bodyFinalRecipes, this.getHints(query), this.metaContext);
        return compiled;
    }

    private CompiledSubPlan doCompileDispatch(SubPlan plan) {
        POperation operation = plan.getOperation();
        if (operation instanceof PEnumerate) {
            return this.doCompileEnumerate(((PEnumerate)operation).getEnumerablePConstraint(), plan);
        }
        if (operation instanceof PApply) {
            PConstraint pConstraint = ((PApply)operation).getPConstraint();
            if (pConstraint instanceof EnumerablePConstraint) {
                CompiledSubPlan primaryParent = this.getCompiledForm((SubPlan)plan.getParentPlans().get(0));
                PlanningTrace secondaryParent = this.doEnumerateDispatch(plan, (EnumerablePConstraint)pConstraint);
                return this.compileToNaturalJoin(plan, primaryParent, secondaryParent);
            }
            if (pConstraint instanceof DeferredPConstraint) {
                return this.doDeferredDispatch((DeferredPConstraint)pConstraint, plan);
            }
            throw new IllegalArgumentException("Unsupported PConstraint in query plan: " + plan.toShortString());
        }
        if (operation instanceof PJoin) {
            return this.doCompileJoin((PJoin)operation, plan);
        }
        if (operation instanceof PProject) {
            return this.doCompileProject((PProject)operation, plan);
        }
        if (operation instanceof PStart) {
            return this.doCompileStart((PStart)operation, plan);
        }
        throw new IllegalArgumentException("Unsupported POperation in query plan: " + plan.toShortString());
    }

    private CompiledSubPlan doDeferredDispatch(DeferredPConstraint constraint, SubPlan plan) {
        SubPlan parentPlan = (SubPlan)plan.getParentPlans().get(0);
        CompiledSubPlan parentCompiled = this.getCompiledForm(parentPlan);
        if (constraint instanceof Equality) {
            return this.compileDeferred((Equality)constraint, plan, parentPlan, parentCompiled);
        }
        if (constraint instanceof ExportedParameter) {
            return this.compileDeferred((ExportedParameter)constraint, plan, parentPlan, parentCompiled);
        }
        if (constraint instanceof Inequality) {
            return this.compileDeferred((Inequality)constraint, plan, parentPlan, parentCompiled);
        }
        if (constraint instanceof NegativePatternCall) {
            return this.compileDeferred((NegativePatternCall)constraint, plan, parentPlan, parentCompiled);
        }
        if (constraint instanceof PatternMatchCounter) {
            return this.compileDeferred((PatternMatchCounter)constraint, plan, parentPlan, parentCompiled);
        }
        if (constraint instanceof AggregatorConstraint) {
            return this.compileDeferred((AggregatorConstraint)constraint, plan, parentPlan, parentCompiled);
        }
        if (constraint instanceof ExpressionEvaluation) {
            return this.compileDeferred((ExpressionEvaluation)constraint, plan, parentPlan, parentCompiled);
        }
        if (constraint instanceof TypeFilterConstraint) {
            return this.compileDeferred((TypeFilterConstraint)constraint, plan, parentPlan, parentCompiled);
        }
        throw new UnsupportedOperationException("Unknown deferred constraint " + constraint);
    }

    private CompiledSubPlan compileDeferred(Equality constraint, SubPlan plan, SubPlan parentPlan, CompiledSubPlan parentCompiled) {
        if (constraint.isMoot()) {
            return parentCompiled.cloneFor(plan);
        }
        Integer index1 = parentCompiled.getPosMapping().get(constraint.getWho());
        Integer index2 = parentCompiled.getPosMapping().get(constraint.getWithWhom());
        if (index1 != null && index2 != null && index1.intValue() != index2.intValue()) {
            Integer indexLower = Math.min(index1, index2);
            Integer indexHigher = Math.max(index1, index2);
            EqualityFilterRecipe equalityFilterRecipe = FACTORY.createEqualityFilterRecipe();
            equalityFilterRecipe.setParent(parentCompiled.getRecipe());
            equalityFilterRecipe.getIndices().add((Object)indexLower);
            equalityFilterRecipe.getIndices().add((Object)indexHigher);
            return new CompiledSubPlan(plan, parentCompiled.getVariablesTuple(), (ReteNodeRecipe)equalityFilterRecipe, parentCompiled);
        }
        throw new IllegalArgumentException(String.format("Unable to interpret %s after compiled parent %s", plan.toShortString(), parentCompiled.toString()));
    }

    private CompiledSubPlan compileConstantFiltering(SubPlan plan, PlanningTrace toFilterTrace, ConstantRecipe constantRecipe, List<PVariable> filteredVariables) {
        PlanningTrace resultTrace = toFilterTrace;
        int constantVariablesSize = filteredVariables.size();
        int i = 0;
        while (i < constantVariablesSize) {
            PlanningTrace bucketTrace;
            Object constantValue = constantRecipe.getConstantValues().get(i);
            PVariable filteredVariable = filteredVariables.get(i);
            int filteredColumn = resultTrace.getVariablesTuple().indexOf(filteredVariable);
            DiscriminatorDispatcherRecipe dispatcherRecipe = FACTORY.createDiscriminatorDispatcherRecipe();
            dispatcherRecipe.setDiscriminationColumnIndex(filteredColumn);
            dispatcherRecipe.setParent(resultTrace.getRecipe());
            PlanningTrace dispatcherTrace = new PlanningTrace(plan, resultTrace.getVariablesTuple(), (ReteNodeRecipe)dispatcherRecipe, resultTrace);
            DiscriminatorBucketRecipe bucketRecipe = FACTORY.createDiscriminatorBucketRecipe();
            bucketRecipe.setBucketKey(constantValue);
            bucketRecipe.setParent((ReteNodeRecipe)dispatcherRecipe);
            resultTrace = bucketTrace = new PlanningTrace(plan, dispatcherTrace.getVariablesTuple(), (ReteNodeRecipe)bucketRecipe, dispatcherTrace);
            ++i;
        }
        return resultTrace.cloneFor(plan);
    }

    private CompiledSubPlan compileDeferred(ExportedParameter constraint, SubPlan plan, SubPlan parentPlan, CompiledSubPlan parentCompiled) {
        return parentCompiled.cloneFor(plan);
    }

    private CompiledSubPlan compileDeferred(Inequality constraint, SubPlan plan, SubPlan parentPlan, CompiledSubPlan parentCompiled) {
        if (constraint.isEliminable()) {
            return parentCompiled.cloneFor(plan);
        }
        Integer index1 = parentCompiled.getPosMapping().get(constraint.getWho());
        Integer index2 = parentCompiled.getPosMapping().get(constraint.getWithWhom());
        if (index1 != null && index2 != null && index1.intValue() != index2.intValue()) {
            Integer indexLower = Math.min(index1, index2);
            Integer indexHigher = Math.max(index1, index2);
            InequalityFilterRecipe inequalityFilterRecipe = FACTORY.createInequalityFilterRecipe();
            inequalityFilterRecipe.setParent(parentCompiled.getRecipe());
            inequalityFilterRecipe.setSubject(indexLower);
            inequalityFilterRecipe.getInequals().add((Object)indexHigher);
            return new CompiledSubPlan(plan, parentCompiled.getVariablesTuple(), (ReteNodeRecipe)inequalityFilterRecipe, parentCompiled);
        }
        throw new IllegalArgumentException(String.format("Unable to interpret %s after compiled parent %s", plan.toShortString(), parentCompiled.toString()));
    }

    private CompiledSubPlan compileDeferred(TypeFilterConstraint constraint, SubPlan plan, SubPlan parentPlan, CompiledSubPlan parentCompiled) {
        Mask mask;
        IInputKey inputKey = constraint.getInputKey();
        if (!this.metaContext.isStateless(inputKey)) {
            throw new UnsupportedOperationException("Non-enumerable input keys are currently supported in Rete only if they are stateless, unlike " + inputKey);
        }
        Tuple constraintVariables = constraint.getVariablesTuple();
        List<PVariable> parentVariables = parentCompiled.getVariablesTuple();
        if (Tuples.flatTupleOf((Object[])parentVariables.toArray()).equals((Object)constraintVariables)) {
            mask = null;
        } else {
            ArrayList<PVariable> variables = new ArrayList<PVariable>();
            Object[] objectArray = constraintVariables.getElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object variable = objectArray[n2];
                variables.add((PVariable)variable);
                ++n2;
            }
            mask = CompilerHelper.makeProjectionMask(parentCompiled, variables);
        }
        InputFilterRecipe inputFilterRecipe = RecipesHelper.inputFilterRecipe((ReteNodeRecipe)parentCompiled.getRecipe(), (Object)inputKey, (String)inputKey.getStringID(), mask);
        return new CompiledSubPlan(plan, parentVariables, (ReteNodeRecipe)inputFilterRecipe, parentCompiled);
    }

    private CompiledSubPlan compileDeferred(NegativePatternCall constraint, SubPlan plan, SubPlan parentPlan, CompiledSubPlan parentCompiled) {
        PlanningTrace callTrace = this.referQuery(constraint.getReferredQuery(), plan, constraint.getActualParametersTuple());
        CompilerHelper.JoinHelper joinHelper = new CompilerHelper.JoinHelper(plan, parentCompiled, callTrace);
        RecipeTraceInfo primaryIndexer = joinHelper.getPrimaryIndexer();
        RecipeTraceInfo secondaryIndexer = joinHelper.getSecondaryIndexer();
        AntiJoinRecipe antiJoinRecipe = FACTORY.createAntiJoinRecipe();
        antiJoinRecipe.setLeftParent((ProjectionIndexerRecipe)primaryIndexer.getRecipe());
        antiJoinRecipe.setRightParent((IndexerRecipe)secondaryIndexer.getRecipe());
        return new CompiledSubPlan(plan, parentCompiled.getVariablesTuple(), (ReteNodeRecipe)antiJoinRecipe, primaryIndexer, secondaryIndexer);
    }

    private CompiledSubPlan compileDeferred(PatternMatchCounter constraint, SubPlan plan, SubPlan parentPlan, CompiledSubPlan parentCompiled) {
        PlanningTrace callTrace = this.referQuery(constraint.getReferredQuery(), plan, constraint.getActualParametersTuple());
        CompilerHelper.JoinHelper fakeJoinHelper = new CompilerHelper.JoinHelper(plan, parentCompiled, callTrace);
        RecipeTraceInfo primaryIndexer = fakeJoinHelper.getPrimaryIndexer();
        RecipeTraceInfo callProjectionIndexer = fakeJoinHelper.getSecondaryIndexer();
        ArrayList<PVariable> sideVariablesTuple = new ArrayList<PVariable>(fakeJoinHelper.getSecondaryMask().transform(callTrace.getVariablesTuple()));
        sideVariablesTuple.add(constraint.getResultVariable());
        CountAggregatorRecipe aggregatorRecipe = FACTORY.createCountAggregatorRecipe();
        aggregatorRecipe.setParent((ProjectionIndexerRecipe)callProjectionIndexer.getRecipe());
        PlanningTrace aggregatorTrace = new PlanningTrace(plan, sideVariablesTuple, (ReteNodeRecipe)aggregatorRecipe, callProjectionIndexer);
        AggregatorIndexerRecipe aggregatorIndexerRecipe = FACTORY.createAggregatorIndexerRecipe();
        aggregatorIndexerRecipe.setParent((ReteNodeRecipe)aggregatorRecipe);
        int aggregatorWidth = sideVariablesTuple.size();
        int aggregateResultIndex = aggregatorWidth - 1;
        aggregatorIndexerRecipe.setMask(CompilerHelper.toRecipeMask(TupleMask.omit((int)aggregateResultIndex, (int)aggregatorWidth)));
        PlanningTrace aggregatorIndexerTrace = new PlanningTrace(plan, sideVariablesTuple, (ReteNodeRecipe)aggregatorIndexerRecipe, aggregatorTrace);
        JoinRecipe naturalJoinRecipe = FACTORY.createJoinRecipe();
        naturalJoinRecipe.setLeftParent((ProjectionIndexerRecipe)primaryIndexer.getRecipe());
        naturalJoinRecipe.setRightParent((IndexerRecipe)aggregatorIndexerRecipe);
        naturalJoinRecipe.setRightParentComplementaryMask(RecipesHelper.mask((int)aggregatorWidth, (int[])new int[]{aggregateResultIndex}));
        ArrayList<PVariable> aggregatedVariablesTuple = new ArrayList<PVariable>(parentCompiled.getVariablesTuple());
        aggregatedVariablesTuple.add(constraint.getResultVariable());
        PlanningTrace joinTrace = new PlanningTrace(plan, aggregatedVariablesTuple, (ReteNodeRecipe)naturalJoinRecipe, primaryIndexer, aggregatorIndexerTrace);
        return CompilerHelper.checkAndTrimEqualVariables(plan, joinTrace).cloneFor(plan);
    }

    private CompiledSubPlan compileDeferred(AggregatorConstraint constraint, SubPlan plan, SubPlan parentPlan, CompiledSubPlan parentCompiled) {
        List parameters;
        IInputKey key;
        PlanningTrace callTrace = this.referQuery(constraint.getReferredQuery(), plan, constraint.getActualParametersTuple());
        CompilerHelper.JoinHelper fakeJoinHelper = new CompilerHelper.JoinHelper(plan, parentCompiled, callTrace);
        RecipeTraceInfo primaryIndexer = fakeJoinHelper.getPrimaryIndexer();
        TupleMask callGroupMask = fakeJoinHelper.getSecondaryMask();
        ArrayList<PVariable> sideVariablesTuple = new ArrayList<PVariable>(callGroupMask.transform(callTrace.getVariablesTuple()));
        sideVariablesTuple.add(constraint.getResultVariable());
        IMultisetAggregationOperator operator = constraint.getAggregator().getOperator();
        SingleColumnAggregatorRecipe columnAggregatorRecipe = FACTORY.createSingleColumnAggregatorRecipe();
        columnAggregatorRecipe.setParent(callTrace.getRecipe());
        columnAggregatorRecipe.setMultisetAggregationOperator(operator);
        int columnIndex = constraint.getAggregatedColumn();
        IPosetComparator posetComparator = null;
        boolean deleteRederiveEvaluation = (Boolean)ReteHintOptions.deleteRederiveEvaluation.getValueOrDefault(this.getHints(plan));
        Mask groupMask = CompilerHelper.toRecipeMask(callGroupMask);
        columnAggregatorRecipe.setDeleteRederiveEvaluation(deleteRederiveEvaluation);
        if (deleteRederiveEvaluation && (key = ((PParameter)(parameters = constraint.getReferredQuery().getParameters()).get(columnIndex)).getDeclaredUnaryType()) != null && this.metaContext.isPosetKey(key)) {
            posetComparator = this.metaContext.getPosetComparator(Collections.singleton(key));
        }
        if (posetComparator == null) {
            columnAggregatorRecipe.setGroupByMask(groupMask);
            columnAggregatorRecipe.setAggregableIndex(columnIndex);
        } else {
            MonotonicityInfo monotonicityInfo = FACTORY.createMonotonicityInfo();
            monotonicityInfo.setCoreMask(groupMask);
            monotonicityInfo.setPosetMask(CompilerHelper.toRecipeMask(TupleMask.selectSingle((int)columnIndex, (int)constraint.getActualParametersTuple().getSize())));
            monotonicityInfo.setPosetComparator(posetComparator);
            columnAggregatorRecipe.setOptionalMonotonicityInfo(monotonicityInfo);
        }
        SingleColumnAggregatorRecipe aggregatorRecipe = columnAggregatorRecipe;
        PlanningTrace aggregatorTrace = new PlanningTrace(plan, sideVariablesTuple, (ReteNodeRecipe)aggregatorRecipe, callTrace);
        AggregatorIndexerRecipe aggregatorIndexerRecipe = FACTORY.createAggregatorIndexerRecipe();
        aggregatorIndexerRecipe.setParent((ReteNodeRecipe)aggregatorRecipe);
        int aggregatorWidth = sideVariablesTuple.size();
        int aggregateResultIndex = aggregatorWidth - 1;
        aggregatorIndexerRecipe.setMask(CompilerHelper.toRecipeMask(TupleMask.omit((int)aggregateResultIndex, (int)aggregatorWidth)));
        PlanningTrace aggregatorIndexerTrace = new PlanningTrace(plan, sideVariablesTuple, (ReteNodeRecipe)aggregatorIndexerRecipe, aggregatorTrace);
        JoinRecipe naturalJoinRecipe = FACTORY.createJoinRecipe();
        naturalJoinRecipe.setLeftParent((ProjectionIndexerRecipe)primaryIndexer.getRecipe());
        naturalJoinRecipe.setRightParent((IndexerRecipe)aggregatorIndexerRecipe);
        naturalJoinRecipe.setRightParentComplementaryMask(RecipesHelper.mask((int)aggregatorWidth, (int[])new int[]{aggregateResultIndex}));
        ArrayList<PVariable> finalVariablesTuple = new ArrayList<PVariable>(parentCompiled.getVariablesTuple());
        finalVariablesTuple.add(constraint.getResultVariable());
        PlanningTrace joinTrace = new PlanningTrace(plan, finalVariablesTuple, (ReteNodeRecipe)naturalJoinRecipe, primaryIndexer, aggregatorIndexerTrace);
        return CompilerHelper.checkAndTrimEqualVariables(plan, joinTrace).cloneFor(plan);
    }

    private CompiledSubPlan compileDeferred(ExpressionEvaluation constraint, SubPlan plan, SubPlan parentPlan, CompiledSubPlan parentCompiled) {
        HashMap<String, Integer> tupleNameMap = new HashMap<String, Integer>();
        for (String name : constraint.getEvaluator().getInputParameterNames()) {
            Map<PVariable, Integer> index = parentCompiled.getPosMapping();
            PVariable variable = constraint.getPSystem().getVariableByNameChecked((Object)name);
            Integer position = index.get(variable);
            tupleNameMap.put(name, position);
        }
        PVariable outputVariable = constraint.getOutputVariable();
        boolean booleanCheck = outputVariable == null;
        boolean cacheOutput = (Boolean)ReteHintOptions.cacheOutputOfEvaluatorsByDefault.getValueOrDefault(this.getHints(plan));
        CheckRecipe enforcerRecipe = booleanCheck ? FACTORY.createCheckRecipe() : FACTORY.createEvalRecipe();
        enforcerRecipe.setParent(parentCompiled.getRecipe());
        enforcerRecipe.setExpression(RecipesHelper.expressionDefinition((Object)constraint.getEvaluator()));
        enforcerRecipe.setCacheOutput(cacheOutput);
        for (Map.Entry entry : tupleNameMap.entrySet()) {
            enforcerRecipe.getMappedIndices().put((Object)((String)entry.getKey()), (Object)((Integer)entry.getValue()));
        }
        ArrayList<PVariable> enforcerVariablesTuple = new ArrayList<PVariable>(parentCompiled.getVariablesTuple());
        if (!booleanCheck) {
            enforcerVariablesTuple.add(outputVariable);
        }
        PlanningTrace enforcerTrace = new PlanningTrace(plan, enforcerVariablesTuple, (ReteNodeRecipe)enforcerRecipe, parentCompiled);
        return CompilerHelper.checkAndTrimEqualVariables(plan, enforcerTrace).cloneFor(plan);
    }

    private CompiledSubPlan doCompileJoin(PJoin operation, SubPlan plan) {
        List<CompiledSubPlan> compiledParents = this.getCompiledFormOfParents(plan);
        CompiledSubPlan leftCompiled = compiledParents.get(0);
        CompiledSubPlan rightCompiled = compiledParents.get(1);
        return this.compileToNaturalJoin(plan, leftCompiled, rightCompiled);
    }

    private CompiledSubPlan compileToNaturalJoin(SubPlan plan, PlanningTrace leftCompiled, PlanningTrace rightCompiled) {
        if (((Boolean)ReteHintOptions.useDiscriminatorDispatchersForConstantFiltering.getValueOrDefault(this.getHints(plan))).booleanValue()) {
            if (leftCompiled.getRecipe() instanceof ConstantRecipe && rightCompiled.getVariablesTuple().containsAll(leftCompiled.getVariablesTuple())) {
                return this.compileConstantFiltering(plan, rightCompiled, (ConstantRecipe)leftCompiled.getRecipe(), leftCompiled.getVariablesTuple());
            }
            if (rightCompiled.getRecipe() instanceof ConstantRecipe && leftCompiled.getVariablesTuple().containsAll(rightCompiled.getVariablesTuple())) {
                return this.compileConstantFiltering(plan, leftCompiled, (ConstantRecipe)rightCompiled.getRecipe(), rightCompiled.getVariablesTuple());
            }
        }
        CompilerHelper.JoinHelper joinHelper = new CompilerHelper.JoinHelper(plan, leftCompiled, rightCompiled);
        return new CompiledSubPlan(plan, joinHelper.getNaturalJoinVariablesTuple(), (ReteNodeRecipe)joinHelper.getNaturalJoinRecipe(), joinHelper.getPrimaryIndexer(), joinHelper.getSecondaryIndexer());
    }

    private CompiledSubPlan doCompileProject(PProject operation, SubPlan plan) {
        List<CompiledSubPlan> compiledParents = this.getCompiledFormOfParents(plan);
        CompiledSubPlan compiledParent = compiledParents.get(0);
        ArrayList<PVariable> projectedVariables = new ArrayList<PVariable>(operation.getToVariables());
        Map<PVariable, Integer> parentPosMapping = compiledParent.getPosMapping();
        Collections.sort(projectedVariables, Comparator.comparing(parentPosMapping::get));
        return this.doProjectPlan(compiledParent, projectedVariables, true, parentTrace -> parentTrace.cloneFor(plan), (recipe, parentTrace) -> new PlanningTrace(plan, (List<PVariable>)projectedVariables, (ReteNodeRecipe)recipe, (RecipeTraceInfo)parentTrace), (recipe, parentTrace) -> new CompiledSubPlan(plan, (List<PVariable>)projectedVariables, (ReteNodeRecipe)recipe, (RecipeTraceInfo)parentTrace));
    }

    <ResultTrace extends RecipeTraceInfo> ResultTrace doProjectPlan(CompiledSubPlan compiledParentPlan, List<PVariable> targetVariables, boolean enforceUniqueness, Function<CompiledSubPlan, ResultTrace> reinterpretTraceFactory, BiFunction<ReteNodeRecipe, RecipeTraceInfo, RecipeTraceInfo> intermediateTraceFactory, BiFunction<ReteNodeRecipe, RecipeTraceInfo, ResultTrace> finalTraceFactory) {
        if (targetVariables.equals(compiledParentPlan.getVariablesTuple())) {
            return (ResultTrace)((RecipeTraceInfo)reinterpretTraceFactory.apply(compiledParentPlan));
        }
        TrimmerRecipe trimmerRecipe = CompilerHelper.makeTrimmerRecipe(compiledParentPlan, targetVariables);
        SubPlan parentPlan = compiledParentPlan.getSubPlan();
        if (!enforceUniqueness || BuildHelper.areAllVariablesDetermined((SubPlan)parentPlan, targetVariables, (QueryAnalyzer)this.queryAnalyzer, (boolean)true)) {
            return (ResultTrace)((RecipeTraceInfo)finalTraceFactory.apply((ReteNodeRecipe)trimmerRecipe, compiledParentPlan));
        }
        UniquenessEnforcerRecipe recipe = FACTORY.createUniquenessEnforcerRecipe();
        recipe.getParents().add((Object)trimmerRecipe);
        boolean deleteRederiveEvaluation = (Boolean)ReteHintOptions.deleteRederiveEvaluation.getValueOrDefault(this.getHints(parentPlan));
        recipe.setDeleteRederiveEvaluation(deleteRederiveEvaluation);
        if (deleteRederiveEvaluation) {
            CompilerHelper.PosetTriplet triplet = CompilerHelper.computePosetInfo(targetVariables, parentPlan.getBody(), this.metaContext);
            if (triplet.comparator != null) {
                MonotonicityInfo info = FACTORY.createMonotonicityInfo();
                info.setCoreMask(triplet.coreMask);
                info.setPosetMask(triplet.posetMask);
                info.setPosetComparator((Object)triplet.comparator);
                recipe.setOptionalMonotonicityInfo(info);
            }
        }
        RecipeTraceInfo trimmerTrace = intermediateTraceFactory.apply((ReteNodeRecipe)trimmerRecipe, compiledParentPlan);
        return (ResultTrace)((RecipeTraceInfo)finalTraceFactory.apply((ReteNodeRecipe)recipe, trimmerTrace));
    }

    RecipeTraceInfo projectBodyFinalToParameters(CompiledSubPlan compiledBody, boolean enforceUniqueness) {
        PBody body = compiledBody.getSubPlan().getBody();
        List parameterList = body.getSymbolicParameterVariables();
        return this.doProjectPlan(compiledBody, parameterList, enforceUniqueness, parentTrace -> parentTrace, (recipe, parentTrace) -> new ParameterProjectionTrace(body, (ReteNodeRecipe)recipe, (RecipeTraceInfo)parentTrace), (recipe, parentTrace) -> new ParameterProjectionTrace(body, (ReteNodeRecipe)recipe, (RecipeTraceInfo)parentTrace));
    }

    private CompiledSubPlan doCompileStart(PStart operation, SubPlan plan) {
        if (!operation.getAPrioriVariables().isEmpty()) {
            throw new IllegalArgumentException("Input variables unsupported by Rete: " + plan.toShortString());
        }
        ConstantRecipe recipe = FACTORY.createConstantRecipe();
        recipe.getConstantValues().clear();
        return new CompiledSubPlan(plan, new ArrayList<PVariable>(), (ReteNodeRecipe)recipe, new RecipeTraceInfo[0]);
    }

    private CompiledSubPlan doCompileEnumerate(EnumerablePConstraint constraint, SubPlan plan) {
        PlanningTrace trimmedTrace = this.doEnumerateAndDeduplicate(constraint, plan);
        return trimmedTrace.cloneFor(plan);
    }

    private PlanningTrace doEnumerateAndDeduplicate(EnumerablePConstraint constraint, SubPlan plan) {
        PlanningTrace coreTrace = this.doEnumerateDispatch(plan, constraint);
        PlanningTrace trimmedTrace = CompilerHelper.checkAndTrimEqualVariables(plan, coreTrace);
        return trimmedTrace;
    }

    private PlanningTrace doEnumerateDispatch(SubPlan plan, EnumerablePConstraint constraint) {
        if (constraint instanceof BinaryTransitiveClosure) {
            return this.compileEnumerable(plan, (BinaryTransitiveClosure)constraint);
        }
        if (constraint instanceof BinaryReflexiveTransitiveClosure) {
            return this.compileEnumerable(plan, (BinaryReflexiveTransitiveClosure)constraint);
        }
        if (constraint instanceof ConstantValue) {
            return this.compileEnumerable(plan, (ConstantValue)constraint);
        }
        if (constraint instanceof PositivePatternCall) {
            return this.compileEnumerable(plan, (PositivePatternCall)constraint);
        }
        if (constraint instanceof TypeConstraint) {
            return this.compileEnumerable(plan, (TypeConstraint)constraint);
        }
        throw new UnsupportedOperationException("Unknown enumerable constraint " + constraint);
    }

    private PlanningTrace compileEnumerable(SubPlan plan, BinaryReflexiveTransitiveClosure constraint) {
        PQuery referredQuery = (PQuery)constraint.getSupplierKey();
        PlanningTrace callTrace = this.referQuery(referredQuery, plan, constraint.getVariablesTuple());
        TransitiveClosureRecipe tcRecipe = FACTORY.createTransitiveClosureRecipe();
        tcRecipe.setParent(callTrace.getRecipe());
        PlanningTrace tcTrace = new PlanningTrace(plan, CompilerHelper.convertVariablesTuple((EnumerablePConstraint)constraint), (ReteNodeRecipe)tcRecipe, callTrace);
        IInputKey inputKey = constraint.getUniverseType();
        InputRecipe universeTypeRecipe = RecipesHelper.inputRecipe((Object)inputKey, (String)inputKey.getStringID(), (int)inputKey.getArity());
        PlanningTrace universeTypeTrace = new PlanningTrace(plan, CompilerHelper.convertVariablesTuple(Tuples.staticArityFlatTupleOf((Object)constraint.getVariablesTuple().get(0))), (ReteNodeRecipe)universeTypeRecipe, new RecipeTraceInfo[0]);
        TrimmerRecipe reflexiveRecipe = FACTORY.createTrimmerRecipe();
        reflexiveRecipe.setMask(RecipesHelper.mask((int)1, (int[])new int[]{0, 0}));
        reflexiveRecipe.setParent((ReteNodeRecipe)universeTypeRecipe);
        PlanningTrace reflexiveTrace = new PlanningTrace(plan, CompilerHelper.convertVariablesTuple((EnumerablePConstraint)constraint), (ReteNodeRecipe)reflexiveRecipe, universeTypeTrace);
        UniquenessEnforcerRecipe brtcRecipe = FACTORY.createUniquenessEnforcerRecipe();
        brtcRecipe.getParents().add((Object)tcRecipe);
        brtcRecipe.getParents().add((Object)reflexiveRecipe);
        return new PlanningTrace(plan, CompilerHelper.convertVariablesTuple((EnumerablePConstraint)constraint), (ReteNodeRecipe)brtcRecipe, reflexiveTrace, tcTrace);
    }

    private PlanningTrace compileEnumerable(SubPlan plan, BinaryTransitiveClosure constraint) {
        PQuery referredQuery = (PQuery)constraint.getSupplierKey();
        PlanningTrace callTrace = this.referQuery(referredQuery, plan, constraint.getVariablesTuple());
        TransitiveClosureRecipe recipe = FACTORY.createTransitiveClosureRecipe();
        recipe.setParent(callTrace.getRecipe());
        return new PlanningTrace(plan, CompilerHelper.convertVariablesTuple((EnumerablePConstraint)constraint), (ReteNodeRecipe)recipe, callTrace);
    }

    private PlanningTrace compileEnumerable(SubPlan plan, PositivePatternCall constraint) {
        PQuery referredQuery = constraint.getReferredQuery();
        return this.referQuery(referredQuery, plan, constraint.getVariablesTuple());
    }

    private PlanningTrace compileEnumerable(SubPlan plan, TypeConstraint constraint) {
        IInputKey inputKey = (IInputKey)constraint.getSupplierKey();
        InputRecipe recipe = RecipesHelper.inputRecipe((Object)inputKey, (String)inputKey.getStringID(), (int)inputKey.getArity());
        return new PlanningTrace(plan, CompilerHelper.convertVariablesTuple((EnumerablePConstraint)constraint), (ReteNodeRecipe)recipe, new RecipeTraceInfo[0]);
    }

    private PlanningTrace compileEnumerable(SubPlan plan, ConstantValue constraint) {
        ConstantRecipe recipe = FACTORY.createConstantRecipe();
        recipe.getConstantValues().add(constraint.getSupplierKey());
        return new PlanningTrace(plan, CompilerHelper.convertVariablesTuple((EnumerablePConstraint)constraint), (ReteNodeRecipe)recipe, new RecipeTraceInfo[0]);
    }

    private PlanningTrace referQuery(PQuery query, SubPlan plan, Tuple actualParametersTuple) {
        RecipeTraceInfo referredQueryTrace = this.originalTraceOfReferredQuery(query);
        return new PlanningTrace(plan, CompilerHelper.convertVariablesTuple(actualParametersTuple), referredQueryTrace.getRecipe(), referredQueryTrace.getParentRecipeTracesForCloning());
    }

    private RecipeTraceInfo originalTraceOfReferredQuery(PQuery query) {
        Set rewrittenBodies;
        if (PVisibility.EMBEDDED == query.getVisibility() && 1 == (rewrittenBodies = this.normalizer.rewrite(query).getBodies()).size()) {
            PBody pBody = (PBody)rewrittenBodies.iterator().next();
            SubPlan bodyFinalPlan = this.getPlan(pBody);
            bodyFinalPlan = BuildHelper.eliminateTrailingProjections((SubPlan)bodyFinalPlan);
            CompiledSubPlan compiledBody = this.getCompiledForm(bodyFinalPlan);
            return this.projectBodyFinalToParameters(compiledBody, true);
        }
        return this.getCompiledForm(query);
    }

    protected List<CompiledSubPlan> getCompiledFormOfParents(SubPlan plan) {
        ArrayList<CompiledSubPlan> results = new ArrayList<CompiledSubPlan>();
        for (SubPlan parentPlan : plan.getParentPlans()) {
            results.add(this.getCompiledForm(parentPlan));
        }
        return results;
    }

    public Map<PQuery, CompiledQuery> getCachedCompiledQueries() {
        return Collections.unmodifiableMap(this.queryCompilerCache);
    }

    public Map<PBody, SubPlan> getCachedQueryPlans() {
        return Collections.unmodifiableMap(this.plannerCache);
    }

    private QueryEvaluationHint getHints(SubPlan plan) {
        return this.getHints(plan.getBody().getPattern());
    }

    private QueryEvaluationHint getHints(PQuery pattern) {
        return this.hintProvider.getQueryEvaluationHint(pattern);
    }
}

