/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.workbench.handler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ILineDiffInfo;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.matcher.RegexMatcher;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.condition.WidgetIsFound;
import org.eclipse.reddeer.core.matcher.WithMnemonicTextMatcher;
import org.eclipse.reddeer.core.matcher.WithTextMatcher;
import org.eclipse.reddeer.swt.api.Shell;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.workbench.handler.WorkbenchPartHandler;
import org.eclipse.reddeer.workbench.impl.editor.Marker;
import org.eclipse.swt.widgets.Button;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.hamcrest.Matcher;

public class EditorHandler
extends WorkbenchPartHandler {
    protected final Logger log = Logger.getLogger(this.getClass());
    private static EditorHandler instance;

    public static EditorHandler getInstance() {
        if (instance == null) {
            instance = new EditorHandler();
        }
        return instance;
    }

    public void save(final IEditorPart editor) {
        this.log.debug("Saving editor");
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                editor.doSave((IProgressMonitor)new NullProgressMonitor());
            }
        });
    }

    public boolean isDirty(final IEditorPart editor) {
        return (Boolean)Display.syncExec((ResultRunnable)new ResultRunnable<Boolean>(){

            public Boolean run() {
                return editor.isDirty();
            }
        });
    }

    public void close(final boolean save, final IEditorPart editor) {
        this.log.debug("Closing editor " + WorkbenchPartHandler.getInstance().getTitle((IWorkbenchPart)editor));
        if (this.isDirty(editor) && save) {
            Display.asyncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    activeWorkbenchWindow.getActivePage().closeEditor(editor, save);
                }
            });
            DefaultShell saveShell = new DefaultShell(new Matcher[]{new WithTextMatcher((Matcher)new RegexMatcher("Save .*"))});
            WidgetIsFound openButton = new WidgetIsFound(Button.class, new Matcher[]{new WithMnemonicTextMatcher("Save")});
            PushButton button = openButton.test() ? new PushButton("Save") : new PushButton("Yes");
            button.click();
            new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)saveShell));
        } else {
            Display.syncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    activeWorkbenchWindow.getActivePage().closeEditor(editor, save);
                }
            });
        }
        this.log.debug("Editor " + WorkbenchPartHandler.getInstance().getTitle((IWorkbenchPart)editor) + " is closed");
    }

    public List<Marker> getMarkers(IEditorPart editor) {
        return this.getMarkers(editor, true);
    }

    public List<Marker> getMarkers(IEditorPart editor, boolean isPersistent) {
        ArrayList<Marker> markers = new ArrayList<Marker>();
        ITextEditor textEditor = (ITextEditor)editor.getAdapter(ITextEditor.class);
        if (textEditor == null) {
            return markers;
        }
        IDocumentProvider documentProvider = textEditor.getDocumentProvider();
        if (documentProvider == null) {
            return markers;
        }
        IAnnotationModel model = documentProvider.getAnnotationModel((Object)textEditor.getEditorInput());
        Iterator it = model.getAnnotationIterator();
        while (it.hasNext()) {
            Annotation annotation;
            Object o = it.next();
            if (!(o instanceof Annotation) || o instanceof ILineDiffInfo || (annotation = (Annotation)o).isPersistent() != isPersistent) continue;
            markers.add(new Marker(annotation, editor));
        }
        return markers;
    }

    public void closeAll(boolean save) {
        this.log.trace("Closing all editors");
        IEditorReference[] editors = (IEditorReference[])Display.syncExec((ResultRunnable)new ResultRunnable<IEditorReference[]>(){

            public IEditorReference[] run() {
                IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IEditorReference[] editors = activeWorkbenchWindow.getActivePage().getEditorReferences();
                EditorHandler.this.log.debug(String.valueOf(editors.length) + " editor(s) found");
                return editors;
            }
        });
        if (editors != null) {
            IEditorReference[] iEditorReferenceArray = editors;
            int n = editors.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editor = iEditorReferenceArray[n2];
                this.close(save, (IEditorPart)editor.getPart(true));
                ++n2;
            }
        }
    }
}

