/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.util;

import java.net.Authenticator;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.epp.internal.mpc.core.MarketplaceClientCore;
import org.eclipse.epp.internal.mpc.core.util.Messages;
import org.eclipse.epp.internal.mpc.core.util.ProxyHelper;
import org.eclipse.osgi.util.NLS;

class ProxyAuthenticator
extends Authenticator {
    private static final String EGIT_AUTHENTICATOR_CLASS = "org.eclipse.egit.core.EclipseAuthenticator";
    private final Authenticator delegate;
    private final Authenticator previousAuthenticator;

    public ProxyAuthenticator(Authenticator delegate) {
        if (delegate instanceof ProxyAuthenticator) {
            delegate = ((ProxyAuthenticator)delegate).getDelegate();
        }
        this.previousAuthenticator = delegate;
        this.delegate = ProxyAuthenticator.fixDelegate(delegate);
    }

    private static Authenticator fixDelegate(Authenticator delegate) {
        Authenticator replacement;
        if (delegate == null) {
            return null;
        }
        if (EGIT_AUTHENTICATOR_CLASS.equals(delegate.getClass().getName()) && (replacement = ProxyAuthenticator.getPluggedInNonEGitAuthenticator()) != null) {
            return replacement;
        }
        return delegate;
    }

    private static Authenticator getPluggedInNonEGitAuthenticator() {
        IExtension[] extensions = RegistryFactory.getRegistry().getExtensionPoint("org.eclipse.core.net", "authenticator").getExtensions();
        if (extensions.length == 0) {
            return null;
        }
        IConfigurationElement config = null;
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String className;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] configs = extension.getConfigurationElements();
            if (configs.length != 0 && (className = configs[0].getAttribute("class")) != null && !EGIT_AUTHENTICATOR_CLASS.equals(className)) {
                config = configs[0];
                break;
            }
            ++n2;
        }
        if (config != null) {
            try {
                return (Authenticator)config.createExecutableExtension("class");
            }
            catch (CoreException ex) {
                MarketplaceClientCore.error(NLS.bind((String)"Unable to instantiate authenticator {0}", (Object[])new Object[]{config.getDeclaringExtension().getUniqueIdentifier()}), ex);
            }
        }
        return null;
    }

    private boolean hostMatches(IProxyData proxy) {
        String proxyHost = proxy.getHost();
        if (proxyHost == null) {
            return false;
        }
        try {
            InetAddress requestingAddress = this.getRequestingSite();
            if (requestingAddress != null) {
                InetAddress proxyAddress = InetAddress.getByName(proxyHost);
                return proxyAddress.equals(requestingAddress);
            }
        }
        catch (UnknownHostException err) {
            return false;
        }
        String requestingHost = this.getRequestingHost();
        return requestingHost != null && requestingHost.equals(proxyHost);
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        IProxyService proxyService = ProxyHelper.getProxyService();
        if (proxyService != null && proxyService.isProxiesEnabled()) {
            IProxyData[] proxies;
            URL requestingURL = this.getRequestingURL();
            if (requestingURL == null) {
                proxies = proxyService.getProxyData();
            } else {
                try {
                    proxies = proxyService.select(requestingURL.toURI());
                }
                catch (URISyntaxException e) {
                    proxies = proxyService.getProxyData();
                }
            }
            IProxyData[] iProxyDataArray = proxies;
            int n = proxies.length;
            int n2 = 0;
            while (n2 < n) {
                IProxyData proxyData = iProxyDataArray[n2];
                if (proxyData.isRequiresAuthentication() && proxyData.getPort() == this.getRequestingPort() && this.hostMatches(proxyData)) {
                    String userId = proxyData.getUserId();
                    String password = proxyData.getPassword();
                    if (userId != null && password != null) {
                        return new PasswordAuthentication(userId, password.toCharArray());
                    }
                }
                ++n2;
            }
        }
        if (this.delegate != null) {
            try {
                Authenticator.setDefault(this.delegate);
                String requestingHost = this.getRequestingHost();
                InetAddress requestingSite = this.getRequestingSite();
                int requestingPort = this.getRequestingPort();
                String requestingProtocol = this.getRequestingProtocol();
                String requestingPrompt = this.getRequestingPrompt();
                String requestingScheme = this.getRequestingScheme();
                URL requestingURL = this.getRequestingURL();
                Authenticator.RequestorType requestorType = this.getRequestorType();
                if (requestingSite == null) {
                    try {
                        requestingSite = InetAddress.getByName(requestingHost);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (requestingPrompt == null) {
                    String promptHost = requestingSite == null ? String.format("%s:%s", requestingHost, requestingPort) : (requestingHost == null ? requestingSite.getHostName() : requestingHost);
                    String promptType = requestorType.toString().toLowerCase();
                    requestingPrompt = MessageFormat.format(Messages.ProxyAuthenticator_prompt, requestingScheme, promptType, promptHost);
                }
                PasswordAuthentication passwordAuthentication = Authenticator.requestPasswordAuthentication(requestingHost, requestingSite, requestingPort, requestingProtocol, requestingPrompt, requestingScheme, requestingURL, requestorType);
                return passwordAuthentication;
            }
            finally {
                Authenticator.setDefault(this);
            }
        }
        return null;
    }

    public Authenticator getDelegate() {
        return this.delegate;
    }

    public void install() {
        Authenticator.setDefault(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstall() {
        Class<Authenticator> clazz = Authenticator.class;
        synchronized (Authenticator.class) {
            Authenticator defaultAuthenticator = ProxyHelper.getDefaultAuthenticator();
            if (defaultAuthenticator == this) {
                Authenticator.setDefault(this.previousAuthenticator);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

