/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.editor.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.emf.editor.EEPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.services.IDisposable;

public class ImageRegistry
implements IDisposable {
    private static ImageRegistry imageRegistry;
    private Map<String, Image> register = new HashMap<String, Image>();
    private Set<Image> deletedImages = new HashSet<Image>();
    private List<ChangeListener> registryChangedListeners = new ArrayList<ChangeListener>();

    public static ImageRegistry getDefault() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
        }
        return imageRegistry;
    }

    public Image getImage(IFile iconFile) {
        String imageKey = this.computeImageKey(iconFile);
        Image icon = this.register.get(imageKey);
        if (icon == null) {
            this.registerImage(iconFile);
            icon = this.register.get(imageKey);
        }
        return icon;
    }

    private Image registerImage(IFile iconFile) {
        Image icon = null;
        if (iconFile.exists()) {
            ImageDescriptor imageDescriptor = null;
            try {
                imageDescriptor = ImageDescriptor.createFromURL((URL)iconFile.getLocation().toFile().toURI().toURL());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            if (imageDescriptor != null && (icon = imageDescriptor.createImage(false)) != null) {
                this.register.put(this.computeImageKey(iconFile), icon);
                this.notifyListeners();
                this.registerResourceChangeListener(iconFile);
            }
        }
        return icon;
    }

    private String computeImageKey(IFile iconFile) {
        return iconFile.getFullPath().toString();
    }

    private void registerResourceChangeListener(final IFile iconFile) {
        final IWorkspace workspace = iconFile.getWorkspace();
        IResourceChangeListener listener = new IResourceChangeListener(){
            private IFile resource;
            {
                this.resource = iFile;
            }

            public void resourceChanged(IResourceChangeEvent event) {
                IResourceDelta findMember;
                if (event.getDelta() != null && (findMember = event.getDelta().findMember(this.resource.getFullPath())) != null) {
                    String imageKey = ImageRegistry.this.computeImageKey(iconFile);
                    ImageRegistry.this.notifyListeners();
                    if ((findMember.getKind() & 2) == 2) {
                        ImageRegistry.this.deletedImages.add((Image)ImageRegistry.this.register.remove(imageKey));
                        workspace.removeResourceChangeListener((IResourceChangeListener)this);
                    }
                    if ((findMember.getKind() & 4) == 4) {
                        ImageRegistry.this.deletedImages.add((Image)ImageRegistry.this.register.remove(imageKey));
                        ImageRegistry.this.registerImage(iconFile);
                    }
                }
            }
        };
        workspace.addResourceChangeListener(listener);
    }

    public void dispose() {
        try {
            try {
                Set<String> keySet = this.register.keySet();
                for (String key : keySet) {
                    Image im = this.register.get(key);
                    this.destroyImage(im);
                }
                this.register.clear();
                for (Image delIm : this.deletedImages) {
                    this.destroyImage(delIm);
                }
                this.deletedImages.clear();
            }
            catch (Exception e) {
                EEPlugin.logError("ImageRegisty dispose failed!", e);
                this.register = new HashMap<String, Image>();
                this.registryChangedListeners = new ArrayList<ChangeListener>();
            }
        }
        finally {
            this.register = new HashMap<String, Image>();
            this.registryChangedListeners = new ArrayList<ChangeListener>();
        }
    }

    private void destroyImage(final Image im) {
        if (im != null && !im.isDisposed()) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    im.dispose();
                }
            });
        }
    }

    public boolean addChangeListener(ChangeListener listener) {
        return this.registryChangedListeners.add(listener);
    }

    public boolean removeChangeListener(ChangeListener listener) {
        return this.registryChangedListeners.remove(listener);
    }

    private void notifyListeners() {
        for (ChangeListener chl : this.registryChangedListeners) {
            chl.stateChanged(new ChangeEvent(this));
        }
    }
}

