/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.common.transaction.IsolationLevels;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.vocabulary.RDF4J;
import org.eclipse.rdf4j.model.vocabulary.SESAME;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.sail.InterruptedSailException;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.eclipse.rdf4j.sail.shacl.ShaclSail;
import org.eclipse.rdf4j.sail.shacl.ShapeValidationContainer;
import org.eclipse.rdf4j.sail.shacl.ValidationSettings;
import org.eclipse.rdf4j.sail.shacl.ast.ContextWithShape;
import org.eclipse.rdf4j.sail.shacl.ast.Shape;
import org.eclipse.rdf4j.sail.shacl.results.ValidationReport;
import org.eclipse.rdf4j.sail.shacl.results.lazy.LazyValidationReport;
import org.eclipse.rdf4j.sail.shacl.results.lazy.ValidationResultIterator;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.VerySimpleRdfsBackwardsChainingConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class ShaclValidator {
    private static final Resource[] ALL_CONTEXTS = new Resource[0];
    private static final Logger logger = LoggerFactory.getLogger(ShaclValidator.class);

    public static Builder builder() {
        return new Builder();
    }

    public static BuilderWithShapes from(ShaclSail shaclSail) {
        return new BuilderWithShapes(Builder.settingsFrom(shaclSail), (Sail)shaclSail);
    }

    private static Sail loadShapes(String description, SailLoader loader) {
        return ShaclValidator.loadSail("SHACL shapes", description, loader);
    }

    private static Sail loadData(String description, SailLoader loader) {
        return ShaclValidator.loadSail("data", description, loader);
    }

    private static Sail loadSail(String kind, String description, SailLoader loader) {
        SailRepository repo = new SailRepository((Sail)new MemoryStore());
        repo.init();
        try (SailRepositoryConnection connection = repo.getConnection();){
            connection.begin((IsolationLevel)IsolationLevels.NONE);
            loader.load(connection);
            connection.commit();
        }
        catch (IOException | RDFParseException e) {
            throw new SailException("Failed to read " + kind + " from " + description, e);
        }
        catch (RuntimeException e) {
            if (e instanceof SailException) {
                throw e;
            }
            throw new SailException("Failed to read " + kind + " from " + description, (Throwable)e);
        }
        return repo.getSail();
    }

    private static RDFFormat detectRdfFormat(String description, String ... candidates) {
        for (String candidate : candidates) {
            Optional format;
            if (candidate == null || candidate.isBlank() || !(format = Rio.getParserFormatForFileName((String)candidate)).isPresent()) continue;
            return (RDFFormat)format.get();
        }
        throw new SailException("Could not determine RDF format for " + description + ". Provide RDFFormat explicitly.");
    }

    private static ValidationReport validateInternal(Sail dataRepo, Sail shapesRepo, InternalBuilder<?> settings) {
        Objects.requireNonNull(dataRepo, "dataRepo");
        Objects.requireNonNull(shapesRepo, "shapesRepo");
        Objects.requireNonNull(settings, "settings");
        if (!settings.validationEnabled) {
            return new ValidationReport(true);
        }
        if (settings.validationTimeoutMillis >= 0L) {
            return ShaclValidator.validateInternalWithTimeout(dataRepo, shapesRepo, settings);
        }
        return ShaclValidator.validateInternalWithoutTimeout(dataRepo, shapesRepo, settings);
    }

    private static ValidationReport validateInternalWithTimeout(Sail dataRepo, Sail shapesRepo, InternalBuilder<?> settings) {
        long validationTimeoutMillis = settings.validationTimeoutMillis;
        ExecutorService executorService = Executors.newSingleThreadExecutor(runnable -> {
            Thread thread = new Thread(runnable, "ShaclValidator-timeout");
            thread.setDaemon(true);
            return thread;
        });
        Future<ValidationReport> future = null;
        try {
            future = executorService.submit(() -> {
                ValidationReport report = ShaclValidator.validateInternalWithoutTimeout(dataRepo, shapesRepo, settings);
                report.conforms();
                return report;
            });
            ValidationReport validationReport = future.get(validationTimeoutMillis, TimeUnit.MILLISECONDS);
            return validationReport;
        }
        catch (TimeoutException e) {
            future.cancel(true);
            throw new SailException("SHACL validation timed out after " + validationTimeoutMillis + " ms", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedSailException((Throwable)e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new SailException(cause);
        }
        finally {
            executorService.shutdownNow();
        }
    }

    /*
     * Exception decompiling
     */
    private static ValidationReport validateInternalWithoutTimeout(Sail dataRepo, Sail shapesRepo, InternalBuilder<?> settings) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static List<ContextWithShape> readShapes(Sail shapesRepo, InternalBuilder<?> settings) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean requiresRdfsSubClassReasoner(List<ContextWithShape> shapes) {
        return shapes.stream().map(ContextWithShape::getShape).map(Shape::getRdfsSubClassReasoningOverride).anyMatch(Boolean.TRUE::equals);
    }

    private static ConnectionsGroup createConnectionsGroup(SailConnection baseConnection, RdfsSubClassOfReasoner reasoner, boolean includeInferredStatements, boolean useRdfsSubClassReasoning, ConnectionsGroup defaults) {
        RdfsSubClassOfReasoner effectiveReasoner = useRdfsSubClassReasoning ? reasoner : null;
        ConnectionsGroup.RdfsSubClassOfReasonerProvider provider = effectiveReasoner == null ? null : () -> effectiveReasoner;
        VerySimpleRdfsBackwardsChainingConnection wrappedConnection = new VerySimpleRdfsBackwardsChainingConnection(baseConnection, effectiveReasoner, includeInferredStatements);
        return new ConnectionsGroup((SailConnection)wrappedConnection, null, null, null, defaults.getStats(), provider, includeInferredStatements, defaults.getTransactionSettings(), defaults.isSparqlValidation());
    }

    private static ValidationReport performValidation(List<ContextWithShape> shapes, ConnectionsGroup connectionsGroup, InternalBuilder<?> settings, SailConnection baseConnection, RdfsSubClassOfReasoner reasoner) {
        long effectiveValidationResultsLimitPerConstraint = settings.getEffectiveValidationResultsLimitPerConstraint();
        long validationResultsLimitTotal = settings.validationResultsLimitTotal;
        boolean defaultIncludeInferredStatements = settings.includeInferredStatements;
        boolean defaultRdfsSubClassReasoning = settings.rdfsSubClassReasoning;
        List<ValidationResultIterator> validationResultIterators = shapes.stream().map(contextWithShape -> {
            Shape shape = contextWithShape.getShape();
            boolean shapeRdfsSubClassReasoning = shape.usesRdfsSubClassReasoning(defaultRdfsSubClassReasoning);
            boolean shapeIncludeInferredStatements = shape.usesIncludeInferredStatements(defaultIncludeInferredStatements);
            boolean closeConnectionsGroup = false;
            ConnectionsGroup shapeConnectionsGroup = connectionsGroup;
            if (shapeRdfsSubClassReasoning != defaultRdfsSubClassReasoning || shapeIncludeInferredStatements != defaultIncludeInferredStatements) {
                shapeConnectionsGroup = ShaclValidator.createConnectionsGroup(baseConnection, reasoner, shapeIncludeInferredStatements, shapeRdfsSubClassReasoning, connectionsGroup);
                closeConnectionsGroup = true;
            }
            ConnectionsGroup planConnectionsGroup = shapeConnectionsGroup;
            return new ShapeValidationContainer(shape, () -> shape.generatePlans(planConnectionsGroup, new ValidationSettings(contextWithShape.getDataGraph(), settings.logValidationPlans, true, settings.performanceLogging)), settings.globalLogValidationExecution, settings.logValidationViolations, effectiveValidationResultsLimitPerConstraint, settings.performanceLogging, settings.logValidationPlans, logger, shapeConnectionsGroup, closeConnectionsGroup);
        }).filter(ShapeValidationContainer::hasPlanNode).map(ShapeValidationContainer::performValidation).collect(Collectors.toList());
        if (Thread.currentThread().isInterrupted()) {
            Thread.currentThread().interrupt();
            throw new InterruptedSailException("Thread was interrupted during validation.");
        }
        return new LazyValidationReport(validationResultIterators, validationResultsLimitTotal);
    }

    private static /* synthetic */ RdfsSubClassOfReasoner lambda$validateInternalWithoutTimeout$2(RdfsSubClassOfReasoner finalReasoner) {
        return finalReasoner;
    }

    public static class Builder
    extends InternalBuilder<Builder>
    implements Cloneable {
        private Builder() {
        }

        public static Builder settingsFrom(ShaclSail shaclSail) {
            Builder builder = new Builder();
            builder.setShapesGraphs(shaclSail.getShapesGraphs());
            builder.setParallelValidation(shaclSail.isParallelValidation());
            builder.setLogValidationPlans(shaclSail.isLogValidationPlans());
            builder.setLogValidationViolations(shaclSail.isLogValidationViolations());
            builder.setGlobalLogValidationExecution(shaclSail.isGlobalLogValidationExecution());
            builder.setCacheSelectNodes(shaclSail.isCacheSelectNodes());
            builder.setRdfsSubClassReasoning(shaclSail.isRdfsSubClassReasoning());
            builder.setIncludeInferredStatements(shaclSail.isIncludeInferredStatements());
            builder.setSerializableValidation(shaclSail.isSerializableValidation());
            builder.setPerformanceLogging(shaclSail.isPerformanceLogging());
            builder.setEclipseRdf4jShaclExtensions(shaclSail.isEclipseRdf4jShaclExtensions());
            builder.setDashDataShapes(shaclSail.isDashDataShapes());
            builder.setValidationResultsLimitTotal(shaclSail.getValidationResultsLimitTotal());
            builder.setValidationResultsLimitPerConstraint(shaclSail.getValidationResultsLimitPerConstraint());
            builder.setTransactionalValidationLimit(shaclSail.getTransactionalValidationLimit());
            if (shaclSail.isValidationEnabled()) {
                builder.enableValidation();
            } else {
                builder.disableValidation();
            }
            return builder;
        }

        public BuilderWithShapes withShapes(Sail shapes) {
            return new BuilderWithShapes(this, shapes);
        }

        public BuilderWithShapes withShapes(File shapesFile, String baseURI) {
            Objects.requireNonNull(shapesFile, "shapesFile");
            RDFFormat format = ShaclValidator.detectRdfFormat("file " + String.valueOf(shapesFile), shapesFile.getName(), baseURI);
            return this.withShapes(shapesFile, baseURI, format);
        }

        public BuilderWithShapes withShapes(File shapesFile) {
            Objects.requireNonNull(shapesFile, "shapesFile");
            RDFFormat format = ShaclValidator.detectRdfFormat("file " + String.valueOf(shapesFile), shapesFile.getName());
            return this.withShapes(shapesFile, format);
        }

        public BuilderWithShapes withShapes(Path shapesPath, String baseURI) {
            Objects.requireNonNull(shapesPath, "shapesPath");
            RDFFormat format = ShaclValidator.detectRdfFormat("path " + String.valueOf(shapesPath), shapesPath.getFileName().toString(), baseURI);
            return this.withShapes(shapesPath, baseURI, format);
        }

        public BuilderWithShapes withShapes(Path shapesPath) {
            Objects.requireNonNull(shapesPath, "shapesPath");
            RDFFormat format = ShaclValidator.detectRdfFormat("path " + String.valueOf(shapesPath), shapesPath.getFileName().toString());
            return this.withShapes(shapesPath, format);
        }

        public BuilderWithShapes withShapes(URL shapesUrl, String baseURI) {
            Objects.requireNonNull(shapesUrl, "shapesUrl");
            RDFFormat format = ShaclValidator.detectRdfFormat("URL " + String.valueOf(shapesUrl), shapesUrl.getPath(), baseURI);
            return this.withShapes(shapesUrl, baseURI, format);
        }

        public BuilderWithShapes withShapes(URL shapesUrl) {
            Objects.requireNonNull(shapesUrl, "shapesUrl");
            RDFFormat format = ShaclValidator.detectRdfFormat("URL " + String.valueOf(shapesUrl), shapesUrl.getPath());
            return this.withShapes(shapesUrl, format);
        }

        public BuilderWithShapes withShapes(InputStream shapesInputStream, String baseURI) {
            Objects.requireNonNull(shapesInputStream, "shapesInputStream");
            RDFFormat format = ShaclValidator.detectRdfFormat("input stream", baseURI);
            return this.withShapes(shapesInputStream, baseURI, format);
        }

        public BuilderWithShapes withShapes(String shapes, String baseURI) {
            Objects.requireNonNull(shapes, "shapes");
            RDFFormat format = ShaclValidator.detectRdfFormat("string content", baseURI);
            return this.withShapes(shapes, baseURI, format);
        }

        public BuilderWithShapes withShapes(File shapesFile, String baseURI, RDFFormat format) {
            Objects.requireNonNull(shapesFile, "shapesFile");
            Objects.requireNonNull(format, "rdfFormat");
            Sail shapes = ShaclValidator.loadShapes("file " + String.valueOf(shapesFile), connection -> connection.add(shapesFile, baseURI, format, new Resource[0]));
            return this.withShapes(shapes);
        }

        public BuilderWithShapes withShapes(File shapesFile, RDFFormat format) {
            Objects.requireNonNull(shapesFile, "shapesFile");
            Objects.requireNonNull(format, "rdfFormat");
            Sail shapes = ShaclValidator.loadShapes("file " + String.valueOf(shapesFile), connection -> connection.add(shapesFile, format, new Resource[0]));
            return this.withShapes(shapes);
        }

        public BuilderWithShapes withShapes(Path shapesPath, String baseURI, RDFFormat format) {
            Objects.requireNonNull(shapesPath, "shapesPath");
            Objects.requireNonNull(format, "rdfFormat");
            return this.withShapes(shapesPath.toFile(), baseURI, format);
        }

        public BuilderWithShapes withShapes(Path shapesPath, RDFFormat format) {
            Objects.requireNonNull(shapesPath, "shapesPath");
            Objects.requireNonNull(format, "rdfFormat");
            return this.withShapes(shapesPath.toFile(), format);
        }

        public BuilderWithShapes withShapes(URL shapesUrl, String baseURI, RDFFormat format) {
            Objects.requireNonNull(shapesUrl, "shapesUrl");
            Objects.requireNonNull(format, "rdfFormat");
            Sail shapes = ShaclValidator.loadShapes("URL " + String.valueOf(shapesUrl), connection -> connection.add(shapesUrl, baseURI, format, new Resource[0]));
            return this.withShapes(shapes);
        }

        public BuilderWithShapes withShapes(URL shapesUrl, RDFFormat format) {
            Objects.requireNonNull(shapesUrl, "shapesUrl");
            Objects.requireNonNull(format, "rdfFormat");
            Sail shapes = ShaclValidator.loadShapes("URL " + String.valueOf(shapesUrl), connection -> connection.add(shapesUrl, format, new Resource[0]));
            return this.withShapes(shapes);
        }

        public BuilderWithShapes withShapes(InputStream shapesInputStream, String baseURI, RDFFormat format) {
            Objects.requireNonNull(shapesInputStream, "shapesInputStream");
            Objects.requireNonNull(format, "rdfFormat");
            Sail shapes = ShaclValidator.loadShapes("input stream", connection -> connection.add(shapesInputStream, baseURI, format, new Resource[0]));
            return this.withShapes(shapes);
        }

        public BuilderWithShapes withShapes(InputStream shapesInputStream, RDFFormat format) {
            Objects.requireNonNull(shapesInputStream, "shapesInputStream");
            Objects.requireNonNull(format, "rdfFormat");
            Sail shapes = ShaclValidator.loadShapes("input stream", connection -> connection.add(shapesInputStream, format, new Resource[0]));
            return this.withShapes(shapes);
        }

        public BuilderWithShapes withShapes(String shapes, String baseURI, RDFFormat format) {
            Objects.requireNonNull(shapes, "shapes");
            Objects.requireNonNull(format, "rdfFormat");
            Sail shapesSail = ShaclValidator.loadShapes("string content", connection -> connection.add((Reader)new StringReader(shapes), baseURI, format, new Resource[0]));
            return this.withShapes(shapesSail);
        }

        public BuilderWithShapes withShapes(String shapes, RDFFormat format) {
            Objects.requireNonNull(shapes, "shapes");
            Objects.requireNonNull(format, "rdfFormat");
            Sail shapesSail = ShaclValidator.loadShapes("string content", connection -> connection.add((Reader)new StringReader(shapes), format, new Resource[0]));
            return this.withShapes(shapesSail);
        }

        public Validator build() {
            return new Validator(this);
        }

        @Override
        public Builder clone() {
            return (Builder)super.clone();
        }
    }

    public static class BuilderWithShapes
    extends InternalBuilder<BuilderWithShapes>
    implements Cloneable {
        public Sail shapes;

        private BuilderWithShapes(Builder builder, Sail shapes) {
            this.shapes = shapes;
            this.setAll(builder);
        }

        public ValidatorWithShapes build() {
            return new ValidatorWithShapes(this);
        }

        @Override
        public BuilderWithShapes clone() {
            BuilderWithShapes clone = (BuilderWithShapes)super.clone();
            return clone;
        }
    }

    @FunctionalInterface
    private static interface SailLoader {
        public void load(SailRepositoryConnection var1) throws IOException, RDFParseException;
    }

    static class InternalBuilder<T extends InternalBuilder<T>>
    implements Cloneable {
        private Resource[] shapeContexts = null;
        private boolean parallelValidation = true;
        private boolean logValidationPlans = false;
        private boolean logValidationViolations = false;
        private boolean validationEnabled = true;
        private boolean cacheSelectNodes = true;
        private boolean globalLogValidationExecution = false;
        private boolean rdfsSubClassReasoning = true;
        private boolean includeInferredStatements = true;
        private boolean performanceLogging = false;
        private boolean serializableValidation = false;
        private boolean eclipseRdf4jShaclExtensions = true;
        private boolean dashDataShapes = true;
        private long validationResultsLimitTotal = 1000000L;
        private long validationResultsLimitPerConstraint = 1000L;
        private long transactionalValidationLimit = 500000L;
        private long validationTimeoutMillis = -1L;
        private boolean sparqlValidation = !"false".equalsIgnoreCase(System.getProperty("org.eclipse.rdf4j.sail.shacl.sparqlValidation"));

        InternalBuilder() {
        }

        void setAll(InternalBuilder<?> other) {
            this.shapeContexts = other.shapeContexts == null ? null : (Resource[])other.shapeContexts.clone();
            this.parallelValidation = other.parallelValidation;
            this.logValidationPlans = other.logValidationPlans;
            this.logValidationViolations = other.logValidationViolations;
            this.validationEnabled = other.validationEnabled;
            this.cacheSelectNodes = other.cacheSelectNodes;
            this.globalLogValidationExecution = other.globalLogValidationExecution;
            this.rdfsSubClassReasoning = other.rdfsSubClassReasoning;
            this.includeInferredStatements = other.includeInferredStatements;
            this.performanceLogging = other.performanceLogging;
            this.serializableValidation = other.serializableValidation;
            this.eclipseRdf4jShaclExtensions = other.eclipseRdf4jShaclExtensions;
            this.dashDataShapes = other.dashDataShapes;
            this.validationResultsLimitTotal = other.validationResultsLimitTotal;
            this.validationResultsLimitPerConstraint = other.validationResultsLimitPerConstraint;
            this.transactionalValidationLimit = other.transactionalValidationLimit;
            this.validationTimeoutMillis = other.validationTimeoutMillis;
            this.sparqlValidation = other.sparqlValidation;
        }

        public T shapeContexts(Resource ... shapeContexts) {
            this.shapeContexts = shapeContexts == null ? null : (Resource[])shapeContexts.clone();
            return (T)this;
        }

        public T setGlobalLogValidationExecution(boolean loggingEnabled) {
            this.globalLogValidationExecution = loggingEnabled;
            return (T)this;
        }

        public T setLogValidationViolations(boolean logValidationViolations) {
            this.logValidationViolations = logValidationViolations;
            return (T)this;
        }

        public T setParallelValidation(boolean parallelValidation) {
            this.parallelValidation = parallelValidation;
            return (T)this;
        }

        public T setCacheSelectNodes(boolean cacheSelectNodes) {
            this.cacheSelectNodes = cacheSelectNodes;
            return (T)this;
        }

        public T setRdfsSubClassReasoning(boolean rdfsSubClassReasoning) {
            this.rdfsSubClassReasoning = rdfsSubClassReasoning;
            return (T)this;
        }

        public T setIncludeInferredStatements(boolean includeInferredStatements) {
            this.includeInferredStatements = includeInferredStatements;
            return (T)this;
        }

        public T disableValidation() {
            this.validationEnabled = false;
            return (T)this;
        }

        public T enableValidation() {
            this.validationEnabled = true;
            return (T)this;
        }

        public T setLogValidationPlans(boolean logValidationPlans) {
            this.logValidationPlans = logValidationPlans;
            return (T)this;
        }

        public T setPerformanceLogging(boolean performanceLogging) {
            this.performanceLogging = performanceLogging;
            return (T)this;
        }

        public T setSerializableValidation(boolean serializableValidation) {
            this.serializableValidation = serializableValidation;
            return (T)this;
        }

        public T setEclipseRdf4jShaclExtensions(boolean eclipseRdf4jShaclExtensions) {
            this.eclipseRdf4jShaclExtensions = eclipseRdf4jShaclExtensions;
            return (T)this;
        }

        public T setDashDataShapes(boolean dashDataShapes) {
            this.dashDataShapes = dashDataShapes;
            return (T)this;
        }

        public T setValidationResultsLimitPerConstraint(long validationResultsLimitPerConstraint) {
            this.validationResultsLimitPerConstraint = validationResultsLimitPerConstraint;
            return (T)this;
        }

        public T setValidationResultsLimitTotal(long validationResultsLimitTotal) {
            this.validationResultsLimitTotal = validationResultsLimitTotal;
            return (T)this;
        }

        public T setTransactionalValidationLimit(long transactionalValidationLimit) {
            this.transactionalValidationLimit = transactionalValidationLimit;
            return (T)this;
        }

        public T setValidationTimeoutMillis(long validationTimeoutMillis) {
            this.validationTimeoutMillis = validationTimeoutMillis;
            return (T)this;
        }

        public T setShapesGraphs(Set<IRI> shapesGraphs) {
            if (shapesGraphs == null) {
                this.shapeContexts = null;
                return (T)this;
            }
            if (shapesGraphs.isEmpty()) {
                this.shapeContexts = ALL_CONTEXTS;
                return (T)this;
            }
            this.shapeContexts = (Resource[])shapesGraphs.stream().map(g -> {
                if (RDF4J.NIL.equals(g) || SESAME.NIL.equals(g)) {
                    return null;
                }
                return g;
            }).toArray(Resource[]::new);
            return (T)this;
        }

        private long getEffectiveValidationResultsLimitPerConstraint() {
            if (this.validationResultsLimitPerConstraint < 0L) {
                return this.validationResultsLimitTotal;
            }
            if (this.validationResultsLimitTotal >= 0L) {
                return Math.min(this.validationResultsLimitTotal, this.validationResultsLimitPerConstraint);
            }
            return this.validationResultsLimitPerConstraint;
        }

        public InternalBuilder<T> clone() {
            try {
                InternalBuilder clone = (InternalBuilder)super.clone();
                clone.shapeContexts = this.shapeContexts == null ? null : (Resource[])this.shapeContexts.clone();
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError();
            }
        }
    }

    public static class Validator {
        private final Builder builder;

        public Validator(Builder builder) {
            this.builder = builder.clone();
        }

        private ValidationReport validateLoadedData(String description, SailLoader loader, Sail shapesRepo) {
            Objects.requireNonNull(shapesRepo, "shapesRepo");
            Sail data = ShaclValidator.loadData(description, loader);
            return this.validate(data, shapesRepo);
        }

        public ValidationReport validate(Sail dataRepo, Sail shapesRepo) {
            return ShaclValidator.validateInternal(dataRepo, shapesRepo, this.builder);
        }

        public ValidationReport validate(File dataFile, String baseURI, RDFFormat format, Sail shapesRepo) {
            Objects.requireNonNull(dataFile, "dataFile");
            Objects.requireNonNull(format, "rdfFormat");
            return this.validateLoadedData("file " + String.valueOf(dataFile), connection -> connection.add(dataFile, baseURI, format, new Resource[0]), shapesRepo);
        }

        public ValidationReport validate(Path dataPath, String baseURI, RDFFormat format, Sail shapesRepo) {
            Objects.requireNonNull(dataPath, "dataPath");
            return this.validate(dataPath.toFile(), baseURI, format, shapesRepo);
        }

        public ValidationReport validate(URL dataUrl, String baseURI, RDFFormat format, Sail shapesRepo) {
            Objects.requireNonNull(dataUrl, "dataUrl");
            Objects.requireNonNull(format, "rdfFormat");
            return this.validateLoadedData("URL " + String.valueOf(dataUrl), connection -> connection.add(dataUrl, baseURI, format, new Resource[0]), shapesRepo);
        }

        public ValidationReport validate(InputStream dataInputStream, String baseURI, RDFFormat format, Sail shapesRepo) {
            Objects.requireNonNull(dataInputStream, "dataInputStream");
            Objects.requireNonNull(format, "rdfFormat");
            return this.validateLoadedData("input stream", connection -> connection.add(dataInputStream, baseURI, format, new Resource[0]), shapesRepo);
        }

        public ValidationReport validate(String data, String baseURI, RDFFormat format, Sail shapesRepo) {
            Objects.requireNonNull(data, "data");
            Objects.requireNonNull(format, "rdfFormat");
            return this.validateLoadedData("string content", connection -> connection.add((Reader)new StringReader(data), baseURI, format, new Resource[0]), shapesRepo);
        }

        public ValidationReport validate(File dataFile, String baseURI, Sail shapesRepo) {
            Objects.requireNonNull(dataFile, "dataFile");
            RDFFormat format = ShaclValidator.detectRdfFormat("file " + String.valueOf(dataFile), dataFile.getName(), baseURI);
            return this.validate(dataFile, baseURI, format, shapesRepo);
        }

        public ValidationReport validate(Path dataPath, String baseURI, Sail shapesRepo) {
            Objects.requireNonNull(dataPath, "dataPath");
            RDFFormat format = ShaclValidator.detectRdfFormat("path " + String.valueOf(dataPath), dataPath.getFileName().toString(), baseURI);
            return this.validate(dataPath, baseURI, format, shapesRepo);
        }

        public ValidationReport validate(URL dataUrl, String baseURI, Sail shapesRepo) {
            Objects.requireNonNull(dataUrl, "dataUrl");
            RDFFormat format = ShaclValidator.detectRdfFormat("URL " + String.valueOf(dataUrl), dataUrl.getPath(), baseURI);
            return this.validate(dataUrl, baseURI, format, shapesRepo);
        }

        public ValidationReport validate(InputStream dataInputStream, String baseURI, Sail shapesRepo) {
            Objects.requireNonNull(dataInputStream, "dataInputStream");
            RDFFormat format = ShaclValidator.detectRdfFormat("input stream", baseURI);
            return this.validate(dataInputStream, baseURI, format, shapesRepo);
        }

        public ValidationReport validate(String data, String baseURI, Sail shapesRepo) {
            Objects.requireNonNull(data, "data");
            RDFFormat format = ShaclValidator.detectRdfFormat("string content", baseURI);
            return this.validate(data, baseURI, format, shapesRepo);
        }

        public ValidationReport validate(File dataFile, RDFFormat format, Sail shapesRepo) {
            Objects.requireNonNull(dataFile, "dataFile");
            Objects.requireNonNull(format, "rdfFormat");
            return this.validateLoadedData("file " + String.valueOf(dataFile), connection -> connection.add(dataFile, format, new Resource[0]), shapesRepo);
        }

        public ValidationReport validate(Path dataPath, RDFFormat format, Sail shapesRepo) {
            Objects.requireNonNull(dataPath, "dataPath");
            return this.validate(dataPath.toFile(), format, shapesRepo);
        }

        public ValidationReport validate(URL dataUrl, RDFFormat format, Sail shapesRepo) {
            Objects.requireNonNull(dataUrl, "dataUrl");
            Objects.requireNonNull(format, "rdfFormat");
            return this.validateLoadedData("URL " + String.valueOf(dataUrl), connection -> connection.add(dataUrl, format, new Resource[0]), shapesRepo);
        }

        public ValidationReport validate(InputStream dataInputStream, RDFFormat format, Sail shapesRepo) {
            Objects.requireNonNull(dataInputStream, "dataInputStream");
            Objects.requireNonNull(format, "rdfFormat");
            return this.validateLoadedData("input stream", connection -> connection.add(dataInputStream, format, new Resource[0]), shapesRepo);
        }

        public ValidationReport validate(String data, RDFFormat format, Sail shapesRepo) {
            Objects.requireNonNull(data, "data");
            Objects.requireNonNull(format, "rdfFormat");
            return this.validateLoadedData("string content", connection -> connection.add((Reader)new StringReader(data), format, new Resource[0]), shapesRepo);
        }

        public ValidationReport validate(File dataFile, Sail shapesRepo) {
            Objects.requireNonNull(dataFile, "dataFile");
            RDFFormat format = ShaclValidator.detectRdfFormat("file " + String.valueOf(dataFile), dataFile.getName());
            return this.validate(dataFile, format, shapesRepo);
        }

        public ValidationReport validate(Path dataPath, Sail shapesRepo) {
            Objects.requireNonNull(dataPath, "dataPath");
            RDFFormat format = ShaclValidator.detectRdfFormat("path " + String.valueOf(dataPath), dataPath.getFileName().toString());
            return this.validate(dataPath, format, shapesRepo);
        }

        public ValidationReport validate(URL dataUrl, Sail shapesRepo) {
            Objects.requireNonNull(dataUrl, "dataUrl");
            RDFFormat format = ShaclValidator.detectRdfFormat("URL " + String.valueOf(dataUrl), dataUrl.getPath());
            return this.validate(dataUrl, format, shapesRepo);
        }

        public ValidationReport validate(Sail dataRepo, File shapesFile, String baseURI, RDFFormat format) {
            return this.builder.withShapes(shapesFile, baseURI, format).build().validate(dataRepo);
        }

        public ValidationReport validate(Sail dataRepo, Path shapesPath, String baseURI, RDFFormat format) {
            return this.builder.withShapes(shapesPath, baseURI, format).build().validate(dataRepo);
        }

        public ValidationReport validate(Sail dataRepo, URL shapesUrl, String baseURI, RDFFormat format) {
            return this.builder.withShapes(shapesUrl, baseURI, format).build().validate(dataRepo);
        }

        public ValidationReport validate(Sail dataRepo, InputStream shapesInputStream, String baseURI, RDFFormat format) {
            return this.builder.withShapes(shapesInputStream, baseURI, format).build().validate(dataRepo);
        }

        public ValidationReport validate(Sail dataRepo, String shapes, String baseURI, RDFFormat format) {
            return this.builder.withShapes(shapes, baseURI, format).build().validate(dataRepo);
        }

        public ValidationReport validate(Sail dataRepo, File shapesFile, String baseURI) {
            return this.builder.withShapes(shapesFile, baseURI).build().validate(dataRepo);
        }

        public ValidationReport validate(Sail dataRepo, Path shapesPath, String baseURI) {
            return this.builder.withShapes(shapesPath, baseURI).build().validate(dataRepo);
        }

        public ValidationReport validate(Sail dataRepo, URL shapesUrl, String baseURI) {
            return this.builder.withShapes(shapesUrl, baseURI).build().validate(dataRepo);
        }

        public ValidationReport validate(Sail dataRepo, InputStream shapesInputStream, String baseURI) {
            return this.builder.withShapes(shapesInputStream, baseURI).build().validate(dataRepo);
        }

        public ValidationReport validate(Sail dataRepo, String shapes, String baseURI) {
            return this.builder.withShapes(shapes, baseURI).build().validate(dataRepo);
        }

        public ValidationReport validate(Sail dataRepo, File shapesFile, RDFFormat format) {
            return this.builder.withShapes(shapesFile, format).build().validate(dataRepo);
        }

        public ValidationReport validate(Sail dataRepo, Path shapesPath, RDFFormat format) {
            return this.builder.withShapes(shapesPath, format).build().validate(dataRepo);
        }

        public ValidationReport validate(Sail dataRepo, URL shapesUrl, RDFFormat format) {
            return this.builder.withShapes(shapesUrl, format).build().validate(dataRepo);
        }

        public ValidationReport validate(Sail dataRepo, InputStream shapesInputStream, RDFFormat format) {
            return this.builder.withShapes(shapesInputStream, format).build().validate(dataRepo);
        }

        public ValidationReport validate(Sail dataRepo, String shapes, RDFFormat format) {
            return this.builder.withShapes(shapes, format).build().validate(dataRepo);
        }

        public ValidationReport validate(Sail dataRepo, File shapesFile) {
            return this.builder.withShapes(shapesFile).build().validate(dataRepo);
        }

        public ValidationReport validate(Sail dataRepo, Path shapesPath) {
            return this.builder.withShapes(shapesPath).build().validate(dataRepo);
        }

        public ValidationReport validate(Sail dataRepo, URL shapesUrl) {
            return this.builder.withShapes(shapesUrl).build().validate(dataRepo);
        }
    }

    public static class ValidatorWithShapes {
        private final BuilderWithShapes builderWithShapes;

        public ValidatorWithShapes(BuilderWithShapes builderWithShapes) {
            this.builderWithShapes = builderWithShapes.clone();
        }

        private ValidationReport validateLoadedData(String description, SailLoader loader) {
            Sail data = ShaclValidator.loadData(description, loader);
            return this.validate(data);
        }

        public ValidationReport validate(Sail dataRepo) {
            return ShaclValidator.validateInternal(dataRepo, this.builderWithShapes.shapes, this.builderWithShapes);
        }

        public ValidationReport validate(File dataFile, String baseURI, RDFFormat format) {
            Objects.requireNonNull(dataFile, "dataFile");
            Objects.requireNonNull(format, "rdfFormat");
            return this.validateLoadedData("file " + String.valueOf(dataFile), connection -> connection.add(dataFile, baseURI, format, new Resource[0]));
        }

        public ValidationReport validate(Path dataPath, String baseURI, RDFFormat format) {
            Objects.requireNonNull(dataPath, "dataPath");
            return this.validate(dataPath.toFile(), baseURI, format);
        }

        public ValidationReport validate(URL dataUrl, String baseURI, RDFFormat format) {
            Objects.requireNonNull(dataUrl, "dataUrl");
            Objects.requireNonNull(format, "rdfFormat");
            return this.validateLoadedData("URL " + String.valueOf(dataUrl), connection -> connection.add(dataUrl, baseURI, format, new Resource[0]));
        }

        public ValidationReport validate(InputStream dataInputStream, String baseURI, RDFFormat format) {
            Objects.requireNonNull(dataInputStream, "dataInputStream");
            Objects.requireNonNull(format, "rdfFormat");
            return this.validateLoadedData("input stream", connection -> connection.add(dataInputStream, baseURI, format, new Resource[0]));
        }

        public ValidationReport validate(String data, String baseURI, RDFFormat format) {
            Objects.requireNonNull(data, "data");
            Objects.requireNonNull(format, "rdfFormat");
            return this.validateLoadedData("string content", connection -> connection.add((Reader)new StringReader(data), baseURI, format, new Resource[0]));
        }

        public ValidationReport validate(File dataFile, String baseURI) {
            Objects.requireNonNull(dataFile, "dataFile");
            RDFFormat format = ShaclValidator.detectRdfFormat("file " + String.valueOf(dataFile), dataFile.getName(), baseURI);
            return this.validate(dataFile, baseURI, format);
        }

        public ValidationReport validate(Path dataPath, String baseURI) {
            Objects.requireNonNull(dataPath, "dataPath");
            RDFFormat format = ShaclValidator.detectRdfFormat("path " + String.valueOf(dataPath), dataPath.getFileName().toString(), baseURI);
            return this.validate(dataPath, baseURI, format);
        }

        public ValidationReport validate(URL dataUrl, String baseURI) {
            Objects.requireNonNull(dataUrl, "dataUrl");
            RDFFormat format = ShaclValidator.detectRdfFormat("URL " + String.valueOf(dataUrl), dataUrl.getPath(), baseURI);
            return this.validate(dataUrl, baseURI, format);
        }

        public ValidationReport validate(InputStream dataInputStream, String baseURI) {
            Objects.requireNonNull(dataInputStream, "dataInputStream");
            RDFFormat format = ShaclValidator.detectRdfFormat("input stream", baseURI);
            return this.validate(dataInputStream, baseURI, format);
        }

        public ValidationReport validate(String data, String baseURI) {
            Objects.requireNonNull(data, "data");
            RDFFormat format = ShaclValidator.detectRdfFormat("string content", baseURI);
            return this.validate(data, baseURI, format);
        }

        public ValidationReport validate(File dataFile, RDFFormat format) {
            Objects.requireNonNull(dataFile, "dataFile");
            Objects.requireNonNull(format, "rdfFormat");
            return this.validateLoadedData("file " + String.valueOf(dataFile), connection -> connection.add(dataFile, format, new Resource[0]));
        }

        public ValidationReport validate(Path dataPath, RDFFormat format) {
            Objects.requireNonNull(dataPath, "dataPath");
            return this.validate(dataPath.toFile(), format);
        }

        public ValidationReport validate(URL dataUrl, RDFFormat format) {
            Objects.requireNonNull(dataUrl, "dataUrl");
            Objects.requireNonNull(format, "rdfFormat");
            return this.validateLoadedData("URL " + String.valueOf(dataUrl), connection -> connection.add(dataUrl, format, new Resource[0]));
        }

        public ValidationReport validate(InputStream dataInputStream, RDFFormat format) {
            Objects.requireNonNull(dataInputStream, "dataInputStream");
            Objects.requireNonNull(format, "rdfFormat");
            return this.validateLoadedData("input stream", connection -> connection.add(dataInputStream, format, new Resource[0]));
        }

        public ValidationReport validate(String data, RDFFormat format) {
            Objects.requireNonNull(data, "data");
            Objects.requireNonNull(format, "rdfFormat");
            return this.validateLoadedData("string content", connection -> connection.add((Reader)new StringReader(data), format, new Resource[0]));
        }

        public ValidationReport validate(File dataFile) {
            Objects.requireNonNull(dataFile, "dataFile");
            RDFFormat format = ShaclValidator.detectRdfFormat("file " + String.valueOf(dataFile), dataFile.getName());
            return this.validate(dataFile, format);
        }

        public ValidationReport validate(Path dataPath) {
            Objects.requireNonNull(dataPath, "dataPath");
            RDFFormat format = ShaclValidator.detectRdfFormat("path " + String.valueOf(dataPath), dataPath.getFileName().toString());
            return this.validate(dataPath, format);
        }

        public ValidationReport validate(URL dataUrl) {
            Objects.requireNonNull(dataUrl, "dataUrl");
            RDFFormat format = ShaclValidator.detectRdfFormat("URL " + String.valueOf(dataUrl), dataUrl.getPath());
            return this.validate(dataUrl, format);
        }
    }
}

