/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.queryrender.sparql.PrefixIndex;
import org.eclipse.rdf4j.queryrender.sparql.util.SparqlNameUtils;
import org.eclipse.rdf4j.queryrender.sparql.util.TextEscapes;

public final class TermRenderer {
    private TermRenderer() {
    }

    public static String convertIRIToString(IRI iri, PrefixIndex index, boolean usePrefixCompaction) {
        String local;
        PrefixIndex.PrefixHit hit;
        String s = iri.stringValue();
        if (usePrefixCompaction && (hit = index.longestMatch(s)) != null && SparqlNameUtils.isPNLocal(local = s.substring(hit.namespace.length()))) {
            return hit.prefix + ":" + local;
        }
        return "<" + s + ">";
    }

    public static String convertValueToString(Value val, PrefixIndex index, boolean usePrefixCompaction) {
        if (val instanceof IRI) {
            return TermRenderer.convertIRIToString((IRI)val, index, usePrefixCompaction);
        }
        if (val instanceof Literal) {
            Literal lit = (Literal)val;
            if (lit.getLanguage().isPresent()) {
                return "\"" + TextEscapes.escapeLiteral(lit.getLabel()) + "\"@" + lit.getLanguage().get();
            }
            IRI dt = lit.getDatatype();
            String label = lit.getLabel();
            if (XSD.BOOLEAN.equals(dt)) {
                return "1".equals(label) || "true".equalsIgnoreCase(label) ? "true" : "false";
            }
            if (XSD.INTEGER.equals(dt)) {
                try {
                    return new BigInteger(label).toString();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (XSD.DECIMAL.equals(dt)) {
                try {
                    return new BigDecimal(label).toPlainString();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (dt != null && !XSD.STRING.equals(dt)) {
                return "\"" + TextEscapes.escapeLiteral(label) + "\"^^" + TermRenderer.convertIRIToString(dt, index, usePrefixCompaction);
            }
            return "\"" + TextEscapes.escapeLiteral(label) + "\"";
        }
        if (val instanceof BNode) {
            return "_:" + ((BNode)val).getID();
        }
        if (val instanceof Triple) {
            Triple t = (Triple)val;
            String s = TermRenderer.convertValueToString(t.getSubject(), index, usePrefixCompaction);
            String p = TermRenderer.convertValueToString(t.getPredicate(), index, usePrefixCompaction);
            String o = TermRenderer.convertValueToString(t.getObject(), index, usePrefixCompaction);
            return "<<" + s + " " + p + " " + o + ">>";
        }
        return "\"" + TextEscapes.escapeLiteral(String.valueOf(val)) + "\"";
    }
}

