/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.ops;

import java.io.IOException;
import java.util.Locale;
import java.util.UUID;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.ops.StreamOperation;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class ReplaceWithValueOperation
implements StreamOperation {
    private static final long serialVersionUID = 1L;
    private UUID operationNodeId = UUID.randomUUID();
    private boolean wasBuiltWithFieldName;
    private String fieldName;
    private Object original;
    private Object replacement;

    public ReplaceWithValueOperation(String forField, StreamExpression expression, StreamFactory factory) throws IOException {
        if (2 == expression.getParameters().size()) {
            this.wasBuiltWithFieldName = false;
            this.fieldName = forField;
            this.original = factory.constructPrimitiveObject(factory.getValueOperand(expression, 0));
        } else if (3 == expression.getParameters().size()) {
            this.wasBuiltWithFieldName = true;
            this.fieldName = factory.getValueOperand(expression, 0);
            this.original = factory.constructPrimitiveObject(factory.getValueOperand(expression, 1));
        } else {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - unknown operands found", expression));
        }
        StreamExpressionNamedParameter replacementParameter = factory.getNamedOperand(expression, "withValue");
        if (null == replacementParameter) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting a parameter named 'withValue' but didn't find one.", expression));
        }
        if (!(replacementParameter.getParameter() instanceof StreamExpressionValue)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting parameter named 'withValue' to be a primitive type.", expression));
        }
        this.replacement = factory.constructPrimitiveObject(((StreamExpressionValue)replacementParameter.getParameter()).getValue());
    }

    @Override
    public void operate(Tuple tuple) {
        if (this.matchesOriginal(tuple)) {
            this.replace(tuple);
        }
    }

    private boolean matchesOriginal(Tuple tuple) {
        Object value = tuple.get(this.fieldName);
        if (null == value) {
            return null == this.original;
        }
        if (null != this.original) {
            return this.original.equals(value);
        }
        return false;
    }

    private void replace(Tuple tuple) {
        if (null == this.replacement) {
            tuple.remove(this.fieldName);
        } else {
            tuple.put(this.fieldName, this.replacement);
        }
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        if (this.wasBuiltWithFieldName) {
            expression.addParameter(this.fieldName);
        }
        expression.addParameter(null == this.original ? "null" : this.original.toString());
        expression.addParameter(new StreamExpressionNamedParameter("withValue", null == this.replacement ? "null" : this.replacement.toString()));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new Explanation(this.operationNodeId.toString()).withExpressionType("operation").withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpression(this.toExpression(factory).toString());
    }
}

