/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.ir;

import java.util.HashSet;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrBGP;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNode;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrPrinter;

public class IrGraph
extends IrNode {
    private final Var graph;
    private final IrBGP bgp;

    public IrGraph(Var graph, IrBGP bgp, boolean newScope) {
        super(newScope);
        this.graph = graph;
        this.bgp = bgp;
    }

    public Var getGraph() {
        return this.graph;
    }

    public IrBGP getWhere() {
        return this.bgp;
    }

    @Override
    public void print(IrPrinter p) {
        p.startLine();
        p.append("GRAPH " + p.convertVarToString(this.getGraph()) + " ");
        IrBGP inner = this.getWhere();
        if (inner != null) {
            inner.print(p);
        } else {
            p.openBlock();
            p.closeBlock();
        }
    }

    @Override
    public IrNode transformChildren(UnaryOperator<IrNode> op) {
        IrBGP newWhere = this.bgp;
        if (newWhere != null) {
            IrNode t = (IrNode)op.apply(newWhere);
            if ((t = t.transformChildren(op)) instanceof IrBGP) {
                newWhere = (IrBGP)t;
            }
        }
        return new IrGraph(this.graph, newWhere, this.isNewScope());
    }

    @Override
    public Set<Var> getVars() {
        HashSet<Var> out = new HashSet<Var>();
        if (this.graph != null) {
            out.add(this.graph);
        }
        if (this.bgp != null) {
            out.addAll(this.bgp.getVars());
        }
        return out;
    }
}

