/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.index.Impact;
import org.apache.lucene.index.Impacts;
import org.apache.lucene.index.ImpactsSource;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.ArrayUtil;

final class MaxScoreCache {
    private final ImpactsSource impactsSource;
    private final Similarity.SimScorer scorer;
    private float[] maxScoreCache;
    private int[] maxScoreCacheUpTo;

    public MaxScoreCache(ImpactsSource impactsSource, Similarity.SimScorer scorer) {
        this.impactsSource = impactsSource;
        this.scorer = scorer;
        this.maxScoreCache = new float[0];
        this.maxScoreCacheUpTo = new int[0];
    }

    private void ensureCacheSize(int size) {
        if (this.maxScoreCache.length < size) {
            int oldLength = this.maxScoreCache.length;
            this.maxScoreCache = ArrayUtil.grow(this.maxScoreCache, size);
            this.maxScoreCacheUpTo = ArrayUtil.growExact(this.maxScoreCacheUpTo, this.maxScoreCache.length);
            Arrays.fill(this.maxScoreCacheUpTo, oldLength, this.maxScoreCacheUpTo.length, -1);
        }
    }

    private float computeMaxScore(List<Impact> impacts) {
        float maxScore = 0.0f;
        for (Impact impact : impacts) {
            maxScore = Math.max(this.scorer.score(impact.freq, impact.norm), maxScore);
        }
        return maxScore;
    }

    int getLevel(int upTo) throws IOException {
        Impacts impacts = this.impactsSource.getImpacts();
        int numLevels = impacts.numLevels();
        for (int level = 0; level < numLevels; ++level) {
            int impactsUpTo = impacts.getDocIdUpTo(level);
            if (upTo > impactsUpTo) continue;
            return level;
        }
        return -1;
    }

    float getMaxScoreForLevel(int level) throws IOException {
        Impacts impacts = this.impactsSource.getImpacts();
        this.ensureCacheSize(level + 1);
        int levelUpTo = impacts.getDocIdUpTo(level);
        if (this.maxScoreCacheUpTo[level] < levelUpTo) {
            this.maxScoreCache[level] = this.computeMaxScore(impacts.getImpacts(level));
            this.maxScoreCacheUpTo[level] = levelUpTo;
        }
        return this.maxScoreCache[level];
    }

    private int getSkipLevel(Impacts impacts, float minScore) throws IOException {
        int numLevels = impacts.numLevels();
        for (int level = 0; level < numLevels; ++level) {
            if (!(this.getMaxScoreForLevel(level) >= minScore)) continue;
            return level - 1;
        }
        return numLevels - 1;
    }

    int getSkipUpTo(float minScore) throws IOException {
        Impacts impacts = this.impactsSource.getImpacts();
        int level = this.getSkipLevel(impacts, minScore);
        if (level == -1) {
            return -1;
        }
        return impacts.getDocIdUpTo(level);
    }
}

