/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf.wal;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.CRC32;
import java.util.zip.CRC32C;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.eclipse.rdf4j.sail.nativerdf.wal.ValueStoreWalConfig;
import org.eclipse.rdf4j.sail.nativerdf.wal.ValueStoreWalDebug;
import org.eclipse.rdf4j.sail.nativerdf.wal.ValueStoreWalReader;
import org.eclipse.rdf4j.sail.nativerdf.wal.ValueStoreWalRecord;
import org.eclipse.rdf4j.sail.nativerdf.wal.ValueStoreWalValueKind;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ValueStoreWAL
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ValueStoreWAL.class);
    private static final FileChannelOpener DEFAULT_CHANNEL_OPENER;
    private static volatile FileChannelOpener channelOpener;
    public static final long NO_LSN = -1L;
    static final Pattern SEGMENT_PATTERN;
    public static final int MAX_FRAME_BYTES = 0x20000000;
    private final ValueStoreWalConfig config;
    private volatile BlockingQueue<ValueStoreWalRecord> queue;
    private final AtomicLong nextLsn = new AtomicLong();
    private final AtomicLong lastAppendedLsn = new AtomicLong(-1L);
    private final AtomicLong lastForcedLsn = new AtomicLong(-1L);
    private final AtomicLong requestedForceLsn = new AtomicLong(-1L);
    private final Object ackMonitor = new Object();
    private final LogWriter logWriter;
    private final Thread writerThread;
    private volatile boolean closed;
    private volatile Throwable writerFailure;
    private volatile boolean purgeRequested;
    private final Object purgeMonitor = new Object();
    private volatile boolean purgeInProgress;
    private final FileChannel lockChannel;
    private final FileLock directoryLock;
    private final boolean initialSegmentsPresent;
    private final int initialMaxSegmentSeq;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockingQueue<ValueStoreWalRecord> getQueue() {
        BlockingQueue<ValueStoreWalRecord> queue = this.queue;
        if (queue != null) {
            return queue;
        }
        ValueStoreWAL valueStoreWAL = this;
        synchronized (valueStoreWAL) {
            queue = this.queue;
            if (queue == null) {
                this.queue = queue = new ArrayBlockingQueue<ValueStoreWalRecord>(this.config.queueCapacity());
            }
            return queue;
        }
    }

    static void setChannelOpenerForTesting(FileChannelOpener opener) {
        channelOpener = opener != null ? opener : DEFAULT_CHANNEL_OPENER;
    }

    static void resetChannelOpenerForTesting() {
        channelOpener = DEFAULT_CHANNEL_OPENER;
    }

    private static FileChannel openWalChannel(Path path, OpenOption ... options) throws IOException {
        return channelOpener.open(path, options);
    }

    private ValueStoreWAL(ValueStoreWalConfig config) throws IOException {
        this.config = Objects.requireNonNull(config, "config");
        if (!Files.isDirectory(config.walDirectory(), new LinkOption[0])) {
            Files.createDirectories(config.walDirectory(), new FileAttribute[0]);
        }
        Path lockFile = config.walDirectory().resolve("lock");
        this.lockChannel = FileChannel.open(lockFile, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        try {
            this.directoryLock = this.lockChannel.tryLock();
        }
        catch (IOException e) {
            this.lockChannel.close();
            throw e;
        }
        if (this.directoryLock == null) {
            throw new IOException("WAL directory is already locked: " + String.valueOf(config.walDirectory()));
        }
        DirectoryState state = this.analyzeDirectory(config.walDirectory());
        this.initialSegmentsPresent = state.hasSegments;
        this.initialMaxSegmentSeq = state.maxSequence;
        if (this.initialSegmentsPresent) {
            try (ValueStoreWalReader reader = ValueStoreWalReader.open(config);){
                Iterator<ValueStoreWalRecord> it = reader.iterator();
                while (it.hasNext()) {
                    it.next();
                }
                long last = reader.lastValidLsn();
                if (last > -1L) {
                    this.nextLsn.set(last);
                }
            }
        }
        this.logWriter = new LogWriter(this.initialMaxSegmentSeq);
        this.writerThread = new Thread((Runnable)this.logWriter, "ValueStoreWalWriter-" + config.storeUuid());
        this.writerThread.setDaemon(true);
        this.writerThread.start();
    }

    public static ValueStoreWAL open(ValueStoreWalConfig config) throws IOException {
        return new ValueStoreWAL(config);
    }

    public ValueStoreWalConfig config() {
        return this.config;
    }

    public long logMint(int id, ValueStoreWalValueKind kind, String lexical, String datatype, String language, int hash) throws IOException {
        this.ensureOpen();
        long lsn = this.nextLsn.incrementAndGet();
        ValueStoreWalRecord record = new ValueStoreWalRecord(lsn, id, kind, lexical, datatype, language, hash);
        this.enqueue(record);
        return lsn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitDurable(long lsn) throws InterruptedException, IOException {
        if (lsn <= -1L || this.closed) {
            return;
        }
        this.ensureOpen();
        if (this.lastForcedLsn.get() >= lsn) {
            return;
        }
        this.requestForce(lsn);
        if (this.config.syncPolicy() == ValueStoreWalConfig.SyncPolicy.INTERVAL) {
            return;
        }
        Object object = this.ackMonitor;
        synchronized (object) {
            while (this.lastForcedLsn.get() < lsn && this.writerFailure == null && !this.closed) {
                this.ackMonitor.wait(TimeUnit.MILLISECONDS.toMillis(10L));
            }
        }
        if (this.writerFailure != null) {
            throw this.propagate(this.writerFailure);
        }
    }

    public boolean hasInitialSegments() {
        return this.initialSegmentsPresent;
    }

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeAllSegments() throws IOException {
        this.ensureOpen();
        Object object = this.purgeMonitor;
        synchronized (object) {
            this.purgeRequested = true;
            this.purgeInProgress = true;
            this.purgeMonitor.notifyAll();
            long deadline = System.nanoTime() + TimeUnit.SECONDS.toNanos(10L);
            while (this.purgeInProgress && this.writerFailure == null && !this.closed) {
                long remaining = deadline - System.nanoTime();
                if (remaining <= 0L) {
                    throw new IOException("Timed out waiting for WAL purge to complete");
                }
                try {
                    this.purgeMonitor.wait(Math.min(TimeUnit.NANOSECONDS.toMillis(remaining), 50L));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Interrupted while waiting for WAL purge", e);
                }
            }
            if (this.writerFailure != null) {
                throw this.propagate(this.writerFailure);
            }
            if (this.closed) {
                throw new IOException("WAL is closed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.logWriter.shutdown();
        try {
            this.writerThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        try {
            this.logWriter.close();
        }
        finally {
            try {
                if (this.directoryLock != null && this.directoryLock.isValid()) {
                    this.directoryLock.release();
                }
            }
            finally {
                if (this.lockChannel != null && this.lockChannel.isOpen()) {
                    this.lockChannel.close();
                }
            }
        }
        if (this.writerFailure != null) {
            throw this.propagate(this.writerFailure);
        }
    }

    private void requestForce(long lsn) {
        this.requestedForceLsn.updateAndGet(prev -> Math.max(prev, lsn));
    }

    private void enqueue(ValueStoreWalRecord record) throws IOException {
        boolean offered = false;
        int spins = 0;
        while (!offered) {
            offered = this.getQueue().offer(record);
            if (offered) continue;
            if (spins < 100) {
                Thread.onSpinWait();
                ++spins;
                continue;
            }
            try {
                this.getQueue().put(record);
                offered = true;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Interrupted while enqueueing WAL record", e);
            }
        }
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("WAL is closed");
        }
        if (this.writerFailure != null) {
            throw this.propagate(this.writerFailure);
        }
    }

    private IOException propagate(Throwable throwable) {
        if (throwable instanceof IOException) {
            return (IOException)throwable;
        }
        return new IOException("WAL writer failure", throwable);
    }

    private DirectoryState analyzeDirectory(Path walDirectory) throws IOException {
        List paths;
        if (!Files.isDirectory(walDirectory, new LinkOption[0])) {
            return new DirectoryState(false, 0);
        }
        int maxSequence = 0;
        boolean hasSegments = false;
        try (Stream<Path> stream = Files.list(walDirectory);){
            paths = stream.collect(Collectors.toList());
        }
        for (Path path : paths) {
            Matcher matcher = SEGMENT_PATTERN.matcher(path.getFileName().toString());
            if (!matcher.matches()) continue;
            hasSegments = true;
            try {
                int segment = ValueStoreWAL.readSegmentSequence(path);
                if (segment <= maxSequence) continue;
                maxSequence = segment;
            }
            catch (IOException e) {
                logger.warn("Failed to read WAL segment header for {}", (Object)path.getFileName(), (Object)e);
            }
        }
        return new DirectoryState(hasSegments, maxSequence);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int readSegmentSequence(Path path) throws IOException {
        boolean compressed = path.getFileName().toString().endsWith(".gz");
        try (BufferedInputStream rawIn = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
             FilterInputStream in = compressed ? new GZIPInputStream(rawIn) : rawIn;){
            byte[] lenBytes = in.readNBytes(4);
            if (lenBytes.length < 4) {
                int n = 0;
                return n;
            }
            ByteBuffer lenBuf = ByteBuffer.wrap(lenBytes).order(ByteOrder.LITTLE_ENDIAN);
            int frameLen = lenBuf.getInt();
            if (frameLen <= 0) {
                int n = 0;
                return n;
            }
            byte[] jsonBytes = in.readNBytes(frameLen);
            if (jsonBytes.length < frameLen) {
                int n = 0;
                return n;
            }
            in.readNBytes(4);
            JsonFactory factory = new JsonFactory();
            try (JsonParser parser = factory.createParser(jsonBytes);){
                block31: {
                    while (parser.nextToken() != JsonToken.END_OBJECT) {
                        if (parser.currentToken() != JsonToken.FIELD_NAME) continue;
                        String field = parser.getCurrentName();
                        parser.nextToken();
                        if (!"segment".equals(field)) {
                            continue;
                        }
                        break block31;
                    }
                    return 0;
                }
                int n = parser.getIntValue();
                return n;
            }
        }
    }

    private void deleteAllSegments() throws IOException {
        List toDelete;
        try (Stream<Path> stream = Files.list(this.config.walDirectory());){
            toDelete = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> {
                String name = path.getFileName().toString();
                return name.matches("wal-[0-9]+\\.v1") || name.matches("wal-[0-9]+\\.v1\\.gz");
            }).collect(Collectors.toList());
        }
        for (Path p : toDelete) {
            try {
                Files.deleteIfExists(p);
            }
            catch (IOException e) {
                logger.warn("Failed to delete WAL segment {}", (Object)p.getFileName(), (Object)e);
                throw e;
            }
        }
    }

    static {
        channelOpener = DEFAULT_CHANNEL_OPENER = FileChannel::open;
        SEGMENT_PATTERN = Pattern.compile("wal-(\\d+)\\.v1(?:\\.gz)?");
    }

    @FunctionalInterface
    static interface FileChannelOpener {
        public FileChannel open(Path var1, OpenOption ... var2) throws IOException;
    }

    private static final class DirectoryState {
        final boolean hasSegments;
        final int maxSequence;

        DirectoryState(boolean hasSegments, int maxSequence) {
            this.hasSegments = hasSegments;
            this.maxSequence = maxSequence;
        }
    }

    private final class LogWriter
    implements Runnable {
        private final CRC32C crc32c = new CRC32C();
        private final int batchSize;
        private FileChannel segmentChannel;
        private Path segmentPath;
        private int segmentSequence;
        private long segmentBytes;
        private int segmentLastMintedId;
        private int segmentFirstMintedId;
        private volatile ByteBuffer ioBuffer;
        private final JsonFactory jsonFactory = new JsonFactory();
        private final ReusableByteArrayOutputStream jsonBuffer = new ReusableByteArrayOutputStream(256);
        private volatile boolean running = true;

        LogWriter(int existingSegments) {
            this.segmentSequence = existingSegments;
            this.batchSize = ValueStoreWAL.this.config.batchBufferBytes();
            this.segmentChannel = null;
            this.segmentPath = null;
            this.segmentBytes = 0L;
            this.segmentLastMintedId = 0;
            this.segmentFirstMintedId = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ByteBuffer getIoBuffer() {
            if (this.ioBuffer == null) {
                LogWriter logWriter = this;
                synchronized (logWriter) {
                    if (this.ioBuffer == null) {
                        this.ioBuffer = ByteBuffer.allocateDirect(this.batchSize).order(ByteOrder.LITTLE_ENDIAN);
                    }
                }
            }
            return this.ioBuffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long lastSyncCheck = System.nanoTime();
                while (this.running || !ValueStoreWAL.this.getQueue().isEmpty()) {
                    boolean syncIntervalElapsed;
                    ValueStoreWalRecord record;
                    if (ValueStoreWAL.this.purgeRequested) {
                        this.performPurgeInternal();
                    }
                    try {
                        record = ValueStoreWAL.this.getQueue().poll(ValueStoreWAL.this.config.idlePollInterval().toNanos(), TimeUnit.NANOSECONDS);
                    }
                    catch (InterruptedException e) {
                        if (this.running) continue;
                        break;
                    }
                    if (record != null) {
                        this.append(record);
                    }
                    boolean pendingForce = ValueStoreWAL.this.requestedForceLsn.get() > -1L && ValueStoreWAL.this.requestedForceLsn.get() > ValueStoreWAL.this.lastForcedLsn.get();
                    boolean bl = syncIntervalElapsed = ValueStoreWAL.this.config.syncPolicy() == ValueStoreWalConfig.SyncPolicy.INTERVAL && System.nanoTime() - lastSyncCheck >= ValueStoreWAL.this.config.syncInterval().toNanos();
                    if (record == null) {
                        if (!pendingForce && ValueStoreWAL.this.config.syncPolicy() != ValueStoreWalConfig.SyncPolicy.ALWAYS && !syncIntervalElapsed) continue;
                        this.flushAndForce();
                        lastSyncCheck = System.nanoTime();
                        continue;
                    }
                    if (ValueStoreWAL.this.config.syncPolicy() == ValueStoreWalConfig.SyncPolicy.ALWAYS) {
                        this.flushAndForce();
                        lastSyncCheck = System.nanoTime();
                        continue;
                    }
                    if (!pendingForce || ValueStoreWAL.this.requestedForceLsn.get() > ValueStoreWAL.this.lastAppendedLsn.get()) continue;
                    this.flushAndForce();
                    lastSyncCheck = System.nanoTime();
                }
                this.flushAndForce();
            }
            catch (Throwable t) {
                ValueStoreWAL.this.writerFailure = t;
            }
            finally {
                try {
                    this.flushAndForce();
                }
                catch (Throwable t) {
                    ValueStoreWAL.this.writerFailure = t;
                }
                this.closeQuietly(this.segmentChannel);
                Object t = ValueStoreWAL.this.ackMonitor;
                synchronized (t) {
                    ValueStoreWAL.this.ackMonitor.notifyAll();
                }
            }
        }

        void shutdown() {
            this.running = false;
        }

        void close() throws IOException {
            this.closeQuietly(this.segmentChannel);
        }

        private void ensureSegmentWritable() throws IOException {
            if (this.segmentPath == null || this.segmentChannel == null) {
                return;
            }
            if (Files.exists(this.segmentPath, new LinkOption[0])) {
                return;
            }
            if (ValueStoreWAL.this.config.syncPolicy() == ValueStoreWalConfig.SyncPolicy.ALWAYS) {
                throw new IOException("Current WAL segment has been removed: " + String.valueOf(this.segmentPath));
            }
            logger.error("Detected deletion of active WAL segment {}; continuing with a new segment", (Object)this.segmentPath.getFileName());
            ByteBuffer pending = null;
            if (this.getIoBuffer().position() > 0) {
                ByteBuffer duplicate = this.getIoBuffer().duplicate();
                duplicate.flip();
                if (duplicate.hasRemaining()) {
                    pending = ByteBuffer.allocate(duplicate.remaining());
                    pending.put(duplicate);
                    pending.flip();
                }
            }
            this.getIoBuffer().clear();
            this.closeQuietly(this.segmentChannel);
            int previousFirstId = this.segmentFirstMintedId;
            int previousLastId = this.segmentLastMintedId;
            this.segmentChannel = null;
            this.segmentPath = null;
            this.segmentBytes = 0L;
            this.segmentFirstMintedId = 0;
            if (previousFirstId > 0) {
                this.startSegment(previousFirstId, false);
                this.segmentLastMintedId = previousLastId;
                if (pending != null) {
                    while (pending.hasRemaining()) {
                        this.segmentChannel.write(pending);
                    }
                    this.segmentBytes += (long)pending.limit();
                }
            } else {
                this.segmentLastMintedId = previousLastId;
            }
        }

        private void append(ValueStoreWalRecord record) throws IOException {
            int toWrite;
            int jsonLength;
            int framedLength;
            this.ensureSegmentWritable();
            if (this.segmentChannel == null) {
                this.startSegment(record.id());
            }
            if (this.segmentBytes + (long)(framedLength = 4 + (jsonLength = this.encodeIntoReusableBuffer(record)) + 4) > ValueStoreWAL.this.config.maxSegmentBytes()) {
                this.flushBuffer();
                this.finishCurrentSegment();
                this.startSegment(record.id());
            }
            if (this.getIoBuffer().remaining() < 4) {
                this.flushBuffer();
            }
            this.getIoBuffer().putInt(jsonLength);
            byte[] jsonBytes = this.jsonBuffer.buffer();
            for (int offset = 0; offset < jsonLength; offset += toWrite) {
                if (this.getIoBuffer().remaining() == 0) {
                    this.flushBuffer();
                }
                toWrite = Math.min(this.getIoBuffer().remaining(), jsonLength - offset);
                this.getIoBuffer().put(jsonBytes, offset, toWrite);
            }
            int crc = this.checksum(jsonBytes, jsonLength);
            if (this.getIoBuffer().remaining() < 4) {
                this.flushBuffer();
            }
            this.getIoBuffer().putInt(crc);
            this.segmentBytes += (long)framedLength;
            if (record.id() > this.segmentLastMintedId) {
                this.segmentLastMintedId = record.id();
            }
            ValueStoreWAL.this.lastAppendedLsn.set(record.lsn());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void performPurgeInternal() {
            try {
                this.closeQuietly(this.segmentChannel);
                while (ValueStoreWAL.this.getQueue().poll() != null) {
                }
                this.getIoBuffer().clear();
                ValueStoreWAL.this.deleteAllSegments();
                this.segmentPath = null;
                this.segmentChannel = null;
                this.segmentBytes = 0L;
                this.segmentFirstMintedId = 0;
                this.segmentLastMintedId = 0;
            }
            catch (IOException e) {
                ValueStoreWAL.this.writerFailure = e;
            }
            finally {
                ValueStoreWAL.this.purgeRequested = false;
                Object object = ValueStoreWAL.this.purgeMonitor;
                synchronized (object) {
                    ValueStoreWAL.this.purgeInProgress = false;
                    ValueStoreWAL.this.purgeMonitor.notifyAll();
                }
            }
        }

        private void flushAndForce() throws IOException {
            this.flushAndForce(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flushAndForce(boolean forceEvenForInterval) throws IOException {
            if (ValueStoreWAL.this.lastAppendedLsn.get() <= ValueStoreWAL.this.lastForcedLsn.get()) {
                return;
            }
            this.flushBuffer();
            if (this.segmentChannel != null && this.segmentChannel.isOpen()) {
                try {
                    boolean shouldForce;
                    boolean bl = shouldForce = forceEvenForInterval || ValueStoreWAL.this.config.syncPolicy() != ValueStoreWalConfig.SyncPolicy.INTERVAL;
                    if (shouldForce) {
                        this.segmentChannel.force(false);
                        if (this.segmentPath != null) {
                            ValueStoreWalDebug.fireForceEvent(this.segmentPath);
                        }
                    }
                }
                catch (ClosedChannelException shouldForce) {
                    // empty catch block
                }
            }
            long forced = ValueStoreWAL.this.lastAppendedLsn.get();
            ValueStoreWAL.this.lastForcedLsn.set(forced);
            long cur = ValueStoreWAL.this.requestedForceLsn.get();
            while (cur != -1L && cur <= forced && !ValueStoreWAL.this.requestedForceLsn.compareAndSet(cur, -1L)) {
                cur = ValueStoreWAL.this.requestedForceLsn.get();
            }
            Object object = ValueStoreWAL.this.ackMonitor;
            synchronized (object) {
                ValueStoreWAL.this.ackMonitor.notifyAll();
            }
        }

        private void flushBuffer() throws IOException {
            this.ensureSegmentWritable();
            if (this.segmentChannel == null) {
                this.getIoBuffer().clear();
                return;
            }
            this.getIoBuffer().flip();
            while (this.getIoBuffer().hasRemaining()) {
                this.segmentChannel.write(this.getIoBuffer());
            }
            this.getIoBuffer().clear();
        }

        private void finishCurrentSegment() throws IOException {
            if (this.segmentChannel == null) {
                return;
            }
            boolean forceInterval = ValueStoreWAL.this.config.syncPolicy() == ValueStoreWalConfig.SyncPolicy.INTERVAL;
            this.flushAndForce(forceInterval);
            int summaryLastId = this.segmentLastMintedId;
            Path toCompress = this.segmentPath;
            this.closeQuietly(this.segmentChannel);
            this.segmentChannel = null;
            this.segmentPath = null;
            this.segmentBytes = 0L;
            this.segmentFirstMintedId = 0;
            this.segmentLastMintedId = 0;
            if (toCompress != null) {
                this.gzipAndDelete(toCompress, summaryLastId);
            }
        }

        private void rotateSegment() throws IOException {
            this.finishCurrentSegment();
        }

        private void startSegment(int firstId) throws IOException {
            this.startSegment(firstId, true);
        }

        private void startSegment(int firstId, boolean incrementSequence) throws IOException {
            if (incrementSequence) {
                ++this.segmentSequence;
            }
            this.segmentPath = ValueStoreWAL.this.config.walDirectory().resolve(this.buildSegmentFileName(firstId));
            if (Files.exists(this.segmentPath, new LinkOption[0])) {
                logger.warn("Overwriting existing WAL segment {}", (Object)this.segmentPath.getFileName());
            }
            this.segmentChannel = ValueStoreWAL.openWalChannel(this.segmentPath, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            this.segmentBytes = 0L;
            this.segmentFirstMintedId = firstId;
            this.segmentLastMintedId = 0;
            this.writeHeader(firstId);
        }

        private String buildSegmentFileName(int firstId) {
            return "wal-" + firstId + ".v1";
        }

        private void gzipAndDelete(Path src, int lastMintedId) {
            int summaryFrameLength;
            int r;
            long srcSize;
            Path gz = src.resolveSibling(src.getFileName().toString() + ".gz");
            try {
                srcSize = Files.size(src);
            }
            catch (IOException e) {
                logger.warn("Skipping compression of WAL segment {} because it is no longer accessible", (Object)src.getFileName());
                return;
            }
            CRC32 crc32 = new CRC32();
            try (InputStream in = Files.newInputStream(src, new OpenOption[0]);
                 FileChannel gzChannel = ValueStoreWAL.openWalChannel(gz, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
                 GZIPOutputStream gzOut = new GZIPOutputStream(Channels.newOutputStream(gzChannel));){
                byte[] buf = new byte[65536];
                while ((r = in.read(buf)) >= 0) {
                    gzOut.write(buf, 0, r);
                    crc32.update(buf, 0, r);
                }
                byte[] summaryFrame = this.buildSummaryFrame(lastMintedId, crc32.getValue());
                summaryFrameLength = summaryFrame.length;
                gzOut.write(summaryFrame);
                gzOut.finish();
                gzOut.flush();
                gzChannel.force(false);
                ValueStoreWalDebug.fireForceEvent(gz);
            }
            catch (IOException e) {
                logger.warn("Failed to compress WAL segment {}: {}", (Object)src.getFileName(), (Object)e.getMessage());
                try {
                    Files.deleteIfExists(gz);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
            long decompressedBytes = 0L;
            byte[] verifyBuf = new byte[65536];
            try (GZIPInputStream gin = new GZIPInputStream(Files.newInputStream(gz, new OpenOption[0]));){
                while ((r = gin.read(verifyBuf)) >= 0) {
                    decompressedBytes += (long)r;
                }
            }
            catch (IOException e) {
                logger.warn("Failed to verify compressed WAL segment {}: {}", (Object)gz.getFileName(), (Object)e.getMessage());
                try {
                    Files.deleteIfExists(gz);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
            if (decompressedBytes != srcSize + (long)summaryFrameLength) {
                try {
                    Files.deleteIfExists(gz);
                }
                catch (IOException e) {
                    // empty catch block
                }
                return;
            }
            try {
                Files.deleteIfExists(src);
            }
            catch (IOException e) {
                logger.warn("Failed to delete WAL segment {} after compression: {}", (Object)src.getFileName(), (Object)e.getMessage());
            }
        }

        private byte[] buildSummaryFrame(int lastMintedId, long crc32Value) throws IOException {
            JsonFactory factory = new JsonFactory();
            ByteArrayOutputStream baos = new ByteArrayOutputStream(128);
            try (JsonGenerator gen = factory.createGenerator((OutputStream)baos);){
                gen.writeStartObject();
                gen.writeStringField("t", "S");
                gen.writeNumberField("lastId", lastMintedId);
                gen.writeNumberField("crc32", crc32Value & 0xFFFFFFFFL);
                gen.writeEndObject();
            }
            baos.write(10);
            byte[] jsonBytes = baos.toByteArray();
            ByteBuffer buffer = ByteBuffer.allocate(4 + jsonBytes.length + 4).order(ByteOrder.LITTLE_ENDIAN);
            buffer.putInt(jsonBytes.length);
            buffer.put(jsonBytes);
            int crc = this.checksum(jsonBytes);
            buffer.putInt(crc);
            buffer.flip();
            byte[] framed = new byte[buffer.remaining()];
            buffer.get(framed);
            return framed;
        }

        private void writeHeader(int firstId) throws IOException {
            JsonFactory factory = new JsonFactory();
            ByteArrayOutputStream baos = new ByteArrayOutputStream(256);
            try (JsonGenerator gen = factory.createGenerator((OutputStream)baos);){
                gen.writeStartObject();
                gen.writeStringField("t", "V");
                gen.writeNumberField("ver", 1);
                gen.writeStringField("store", ValueStoreWAL.this.config.storeUuid());
                gen.writeStringField("engine", "valuestore");
                gen.writeNumberField("created", Instant.now().getEpochSecond());
                gen.writeNumberField("segment", this.segmentSequence);
                gen.writeNumberField("firstId", firstId);
                gen.writeEndObject();
            }
            baos.write(10);
            byte[] jsonBytes = baos.toByteArray();
            ByteBuffer buffer = ByteBuffer.allocate(4 + jsonBytes.length + 4).order(ByteOrder.LITTLE_ENDIAN);
            buffer.putInt(jsonBytes.length);
            buffer.put(jsonBytes);
            int crc = this.checksum(jsonBytes);
            buffer.putInt(crc);
            buffer.flip();
            while (buffer.hasRemaining()) {
                this.segmentChannel.write(buffer);
            }
            this.segmentBytes += (long)buffer.limit();
        }

        private int checksum(byte[] data) {
            return this.checksum(data, data.length);
        }

        private int checksum(byte[] data, int len) {
            this.crc32c.reset();
            this.crc32c.update(data, 0, len);
            return (int)this.crc32c.getValue();
        }

        private int encodeIntoReusableBuffer(ValueStoreWalRecord record) throws IOException {
            this.jsonBuffer.reset();
            try (JsonGenerator gen = this.jsonFactory.createGenerator((OutputStream)this.jsonBuffer);){
                gen.writeStartObject();
                gen.writeStringField("t", "M");
                gen.writeNumberField("lsn", record.lsn());
                gen.writeNumberField("id", record.id());
                gen.writeStringField("vk", String.valueOf(record.valueKind().code()));
                gen.writeStringField("lex", record.lexical() == null ? "" : record.lexical());
                gen.writeStringField("dt", record.datatype() == null ? "" : record.datatype());
                gen.writeStringField("lang", record.language() == null ? "" : record.language());
                gen.writeNumberField("hash", record.hash());
                gen.writeEndObject();
            }
            this.jsonBuffer.write(10);
            return this.jsonBuffer.size();
        }

        private void closeQuietly(FileChannel channel) {
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private final class ReusableByteArrayOutputStream
        extends ByteArrayOutputStream {
            ReusableByteArrayOutputStream(int size) {
                super(size);
            }

            byte[] buffer() {
                return this.buf;
            }
        }
    }
}

