/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lmdb.model;

import java.io.ObjectStreamException;
import org.eclipse.rdf4j.model.impl.SimpleBNode;
import org.eclipse.rdf4j.sail.lmdb.ValueStoreRevision;
import org.eclipse.rdf4j.sail.lmdb.model.LmdbResource;
import org.eclipse.rdf4j.sail.lmdb.model.LmdbValue;

public class LmdbBNode
extends SimpleBNode
implements LmdbResource {
    private static final long serialVersionUID = 2729080258717960353L;
    private ValueStoreRevision revision;
    private long internalID;
    private boolean initialized = false;

    public LmdbBNode(ValueStoreRevision revision, long internalID) {
        this.setInternalID(internalID, revision);
    }

    public LmdbBNode(ValueStoreRevision revision, String nodeID) {
        this(revision, nodeID, -1L);
    }

    public LmdbBNode(ValueStoreRevision revision, String nodeID, long internalID) {
        super(nodeID);
        this.setInternalID(internalID, revision);
        this.initialized = true;
    }

    @Override
    public void setInternalID(long internalID, ValueStoreRevision revision) {
        this.internalID = internalID;
        this.revision = revision;
    }

    @Override
    public ValueStoreRevision getValueStoreRevision() {
        return this.revision;
    }

    @Override
    public void setFromInitializedValue(LmdbValue initializedValue) {
        if (!(initializedValue instanceof LmdbBNode)) {
            throw new IllegalArgumentException("Initialized value is not of type LmdbBNode");
        }
        LmdbBNode lmdbBNode = (LmdbBNode)initializedValue;
        super.setID(lmdbBNode.getID());
    }

    @Override
    public long getInternalID() {
        return this.internalID;
    }

    @Override
    public void setID(String id) {
        super.setID(id);
    }

    @Override
    public String getID() {
        this.init();
        return super.getID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        if (!this.initialized) {
            LmdbBNode lmdbBNode = this;
            synchronized (lmdbBNode) {
                if (!this.initialized) {
                    this.revision.resolveValue(this.internalID, this);
                }
                this.initialized = true;
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof LmdbBNode && this.internalID != -1L) {
            LmdbBNode otherLmdbBNode = (LmdbBNode)o;
            if (otherLmdbBNode.internalID != -1L && this.revision.equals(otherLmdbBNode.revision)) {
                return this.internalID == otherLmdbBNode.internalID;
            }
        }
        return super.equals(o);
    }

    protected Object writeReplace() throws ObjectStreamException {
        this.init();
        return this;
    }
}

