/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.base;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.DistinctIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.order.StatementOrder;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.RDFStarTripleSource;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.TripleSourceIterationWrapper;
import org.eclipse.rdf4j.sail.base.SailDataset;

@InternalUseOnly
public class SailDatasetTripleSource
implements RDFStarTripleSource {
    private final ValueFactory vf;
    private final SailDataset dataset;

    public SailDatasetTripleSource(ValueFactory vf, SailDataset dataset) {
        this.vf = vf;
        this.dataset = dataset;
    }

    public String toString() {
        return this.dataset.toString();
    }

    @Override
    public CloseableIteration<? extends Statement> getStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws QueryEvaluationException {
        CloseableIteration<? extends Statement> statements = null;
        try {
            statements = this.dataset.getStatements(subj, pred, obj, contexts);
            if (statements instanceof EmptyIteration) {
                return statements;
            }
            return new TripleSourceIterationWrapper<Statement>(statements);
        }
        catch (Throwable t) {
            if (statements != null) {
                statements.close();
            }
            if (t instanceof SailException) {
                throw new QueryEvaluationException(t);
            }
            throw t;
        }
    }

    @Override
    public CloseableIteration<? extends Statement> getStatements(StatementOrder order, Resource subj, IRI pred, Value obj, Resource ... contexts) throws QueryEvaluationException {
        CloseableIteration<? extends Statement> statements = null;
        try {
            statements = this.dataset.getStatements(order, subj, pred, obj, contexts);
            if (statements instanceof EmptyIteration) {
                return statements;
            }
            return new TripleSourceIterationWrapper<Statement>(statements);
        }
        catch (Throwable t) {
            if (statements != null) {
                statements.close();
            }
            if (t instanceof SailException) {
                throw new QueryEvaluationException(t);
            }
            throw t;
        }
    }

    @Override
    public Set<StatementOrder> getSupportedOrders(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        return this.dataset.getSupportedOrders(subj, pred, obj, contexts);
    }

    @Override
    public Comparator<Value> getComparator() {
        return this.dataset.getComparator();
    }

    @Override
    public ValueFactory getValueFactory() {
        return this.vf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloseableIteration<? extends Triple> getRdfStarTriples(Resource subj, IRI pred, Value obj) throws QueryEvaluationException {
        CloseableIteration<? extends Triple> triples = null;
        TripleSourceIterationWrapper<? extends Triple> iterationWrapper = null;
        try {
            triples = this.dataset.getTriples(subj, pred, obj);
            if (triples instanceof EmptyIteration) {
                return triples;
            }
            iterationWrapper = new TripleSourceIterationWrapper<Triple>(triples);
            return new DistinctIteration<Triple>(iterationWrapper, new HashSet());
        }
        catch (Throwable t) {
            try {
                if (triples != null) {
                    triples.close();
                }
            }
            finally {
                if (iterationWrapper != null) {
                    iterationWrapper.close();
                }
            }
            if (t instanceof SailException) {
                throw new QueryEvaluationException(t);
            }
            throw t;
        }
    }
}

