/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.ir.util.transform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrBGP;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrExists;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrFilter;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNode;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNot;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrPathTriple;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrProjectionItem;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrSelect;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrSubSelect;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrUnion;
import org.eclipse.rdf4j.queryrender.sparql.ir.util.transform.BaseTransform;

public final class CanonicalizeNpsByProjectionTransform
extends BaseTransform {
    private CanonicalizeNpsByProjectionTransform() {
    }

    public static IrBGP apply(IrBGP bgp, IrSelect select) {
        if (bgp == null) {
            return null;
        }
        HashMap<String, Integer> projIndex = new HashMap<String, Integer>();
        if (select != null && select.getProjection() != null) {
            List<IrProjectionItem> items = select.getProjection();
            for (int i = 0; i < items.size(); ++i) {
                IrProjectionItem it = items.get(i);
                if (it == null || it.getVarName() == null || it.getVarName().isEmpty()) continue;
                projIndex.putIfAbsent(it.getVarName(), i);
            }
        }
        ArrayList<IrNode> out = new ArrayList<IrNode>();
        Iterator<IrNode> iterator = bgp.getLines().iterator();
        while (iterator.hasNext()) {
            IrNode n;
            IrNode m = n = iterator.next();
            if (n instanceof IrPathTriple) {
                String t;
                IrPathTriple pt = (IrPathTriple)n;
                String path = pt.getPathText();
                if (path != null && (t = path.trim()).startsWith("!(") && t.endsWith(")")) {
                    Var s = pt.getSubject();
                    Var o = pt.getObject();
                    if (!(s == null || o == null || s.hasValue() || o.hasValue() || CanonicalizeNpsByProjectionTransform.isAnonPathVar(s) || CanonicalizeNpsByProjectionTransform.isAnonPathVar(o))) {
                        String inv;
                        boolean flip;
                        Integer oi;
                        String sName = s.getName();
                        String oName = o.getName();
                        Integer si = sName == null ? null : (Integer)projIndex.get(sName);
                        Integer n2 = oi = oName == null ? null : (Integer)projIndex.get(oName);
                        if (si != null && oi != null) {
                            flip = si > oi;
                        } else {
                            boolean bl = flip = si == null && oi != null;
                        }
                        if (flip && (inv = CanonicalizeNpsByProjectionTransform.invertNegatedPropertySet(t)) != null) {
                            IrPathTriple np = new IrPathTriple(o, inv, s, false, pt.getPathVars());
                            m = np;
                        }
                    }
                }
            } else if (n instanceof IrUnion) {
                m = n;
            } else if (n instanceof IrFilter) {
                IrFilter f = (IrFilter)n;
                if (f.getBody() instanceof IrExists) {
                    IrExists ex = (IrExists)f.getBody();
                    IrFilter nf = new IrFilter(new IrExists(CanonicalizeNpsByProjectionTransform.apply(ex.getWhere(), select), ex.isNewScope()), f.isNewScope());
                    m = nf;
                } else if (f.getBody() instanceof IrNot && ((IrNot)f.getBody()).getInner() instanceof IrExists) {
                    IrNot not = (IrNot)f.getBody();
                    IrExists ex = (IrExists)not.getInner();
                    IrFilter nf = new IrFilter(new IrNot(new IrExists(CanonicalizeNpsByProjectionTransform.apply(ex.getWhere(), select), ex.isNewScope()), false), f.isNewScope());
                    m = nf;
                } else {
                    m = n;
                }
            } else if (!(n instanceof IrSubSelect)) {
                m = BaseTransform.rewriteContainers(n, child -> CanonicalizeNpsByProjectionTransform.apply(child, select));
            }
            out.add(m);
        }
        return BaseTransform.bgpWithLines(bgp, out);
    }
}

