/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.serializer;

import java.io.IOException;
import org.mapdb.DataIO;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.serializer.SerializerString;

public class SerializerStringDelta
extends SerializerString {
    protected static int commonPrefixLen(char[][] chars) {
        int ret = 0;
        while (chars[0].length != ret) {
            char byt = chars[0][ret];
            for (int i = 1; i < chars.length; ++i) {
                if (chars[i].length != ret && byt == chars[i][ret]) continue;
                return ret;
            }
            ++ret;
        }
        return ret;
    }

    @Override
    public char[][] valueArrayDeserialize(DataInput2 in, int size) throws IOException {
        int i;
        char[][] ret = new char[size][];
        for (int i2 = 0; i2 < ret.length; ++i2) {
            int len = in.unpackInt();
            ret[i2] = new char[len];
        }
        int prefixLen = in.unpackInt();
        for (i = 0; i < prefixLen; ++i) {
            ret[0][i] = (char)in.unpackInt();
        }
        for (i = 1; i < ret.length; ++i) {
            System.arraycopy(ret[0], 0, ret[i], 0, prefixLen);
        }
        for (char[] b : ret) {
            for (int j = prefixLen; j < b.length; ++j) {
                b[j] = (char)in.unpackInt();
            }
        }
        return ret;
    }

    @Override
    public void valueArraySerialize(DataOutput2 out, Object chars2) throws IOException {
        char[][] chars;
        for (char[] b : chars = (char[][])chars2) {
            out.packInt(b.length);
        }
        int prefixLen = SerializerStringDelta.commonPrefixLen(chars);
        DataIO.packInt(out, prefixLen);
        char[] first = chars[0];
        for (int i = 0; i < prefixLen; ++i) {
            out.packInt(first[i]);
        }
        for (char[] b : chars) {
            for (int i = prefixLen; i < b.length; ++i) {
                out.packInt(b[i]);
            }
        }
    }
}

