/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lucene;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.math.NumberUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.function.TupleFunctionRegistry;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.repository.sparql.federation.SPARQLServiceResolver;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.evaluation.TupleFunctionEvaluationMode;
import org.eclipse.rdf4j.sail.helpers.NotifyingSailWrapper;
import org.eclipse.rdf4j.sail.lucene.DistanceQuerySpecBuilder;
import org.eclipse.rdf4j.sail.lucene.GeoRelationQuerySpecBuilder;
import org.eclipse.rdf4j.sail.lucene.IndexableStatementFilter;
import org.eclipse.rdf4j.sail.lucene.LuceneSailConnection;
import org.eclipse.rdf4j.sail.lucene.QuerySpecBuilder;
import org.eclipse.rdf4j.sail.lucene.SearchIndex;
import org.eclipse.rdf4j.sail.lucene.SearchQueryInterpreter;
import org.eclipse.rdf4j.sail.lucene.TypeBacktraceMode;
import org.eclipse.rdf4j.sail.lucene.util.SearchIndexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneSail
extends NotifyingSailWrapper {
    private static final Logger logger = LoggerFactory.getLogger(LuceneSail.class);
    public static final String REINDEX_QUERY_KEY = "reindexQuery";
    public static final String INDEXEDFIELDS = "indexedfields";
    public static final String INDEXEDTYPES = "indexedtypes";
    public static final String INDEXEDLANG = "indexedlang";
    public static final String INDEX_TYPE_BACKTRACE_MODE = "indexBacktraceMode";
    public static final String LUCENE_DIR_KEY = "lucenedir";
    public static final String DEFAULT_LUCENE_DIR = ".index";
    public static final String LUCENE_RAMDIR_KEY = "useramdir";
    public static final String DEFAULT_NUM_DOCS_KEY = "defaultNumDocs";
    public static final String MAX_DOCUMENTS_KEY = "maxDocuments";
    public static final String WKT_FIELDS = "wktFields";
    public static final String INDEX_CLASS_KEY = "index";
    public static final String INDEX_ID = "indexid";
    public static final String DEFAULT_INDEX_CLASS = "org.eclipse.rdf4j.sail.lucene.impl.LuceneIndex";
    public static final String ANALYZER_CLASS_KEY = "analyzer";
    public static final String QUERY_ANALYZER_CLASS_KEY = "queryAnalyzer";
    public static final String SIMILARITY_CLASS_KEY = "similarity";
    public static final String INCOMPLETE_QUERY_FAIL_KEY = "incompletequeryfail";
    public static final String EVALUATION_MODE_KEY = "evaluationMode";
    public static final String FUZZY_PREFIX_LENGTH_KEY = "fuzzyPrefixLength";
    private volatile SearchIndex luceneIndex;
    protected final Properties parameters = new Properties();
    private volatile String reindexQuery = "SELECT ?s ?p ?o ?c WHERE {{?s ?p ?o} UNION {GRAPH ?c {?s ?p ?o.}}} ORDER BY ?s";
    private volatile boolean incompleteQueryFails = true;
    private volatile TupleFunctionEvaluationMode evaluationMode = TupleFunctionEvaluationMode.TRIPLE_SOURCE;
    private volatile TypeBacktraceMode indexBacktraceMode = TypeBacktraceMode.DEFAULT_TYPE_BACKTRACE_MODE;
    private TupleFunctionRegistry tupleFunctionRegistry = TupleFunctionRegistry.getInstance();
    private FederatedServiceResolver serviceResolver = new SPARQLServiceResolver();
    private Set<IRI> indexedFields;
    private Map<IRI, IRI> indexedFieldsMapping;
    private IRI indexId = null;
    private IndexableStatementFilter filter = null;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public void setLuceneIndex(SearchIndex luceneIndex) {
        this.luceneIndex = luceneIndex;
    }

    public SearchIndex getLuceneIndex() {
        return this.luceneIndex;
    }

    public NotifyingSailConnection getConnection() throws SailException {
        if (!this.closed.get()) {
            return new LuceneSailConnection(super.getConnection(), this.luceneIndex, this);
        }
        throw new SailException("Sail is shut down or not initialized");
    }

    public void shutDown() throws SailException {
        if (this.closed.compareAndSet(false, true)) {
            logger.debug("LuceneSail shutdown");
            try {
                SearchIndex toShutDownLuceneIndex = this.luceneIndex;
                this.luceneIndex = null;
                if (toShutDownLuceneIndex != null) {
                    toShutDownLuceneIndex.shutDown();
                }
            }
            catch (IOException e) {
                throw new SailException((Throwable)e);
            }
            finally {
                super.shutDown();
            }
        }
    }

    public void setDataDir(File dataDir) {
        Path luceneDir = Paths.get(this.parameters.getProperty(LUCENE_DIR_KEY, DEFAULT_LUCENE_DIR), "");
        String luceneDirAbsolute = dataDir.getAbsoluteFile().toPath().resolve(luceneDir).toString();
        this.setParameter(LUCENE_DIR_KEY, luceneDirAbsolute);
        logger.debug("Absolute path to lucene index dir: {}", (Object)luceneDirAbsolute);
        this.getBaseSail().setDataDir(dataDir);
    }

    public void init() throws SailException {
        super.init();
        if (this.parameters.containsKey(INDEXEDFIELDS)) {
            String indexedfieldsString = this.parameters.getProperty(INDEXEDFIELDS);
            Properties prop = new Properties();
            try (StringReader reader = new StringReader(indexedfieldsString);){
                prop.load(reader);
            }
            catch (IOException e) {
                throw new SailException("Could read indexedfields: " + indexedfieldsString, (Throwable)e);
            }
            ValueFactory vf = this.getValueFactory();
            this.indexedFields = new HashSet<IRI>();
            this.indexedFieldsMapping = new HashMap<IRI, IRI>();
            for (Object key : prop.keySet()) {
                String keyStr = key.toString();
                if (keyStr.startsWith("index.")) {
                    this.indexedFields.add(vf.createIRI(prop.getProperty(keyStr)));
                    continue;
                }
                this.indexedFieldsMapping.put(vf.createIRI(keyStr), vf.createIRI(prop.getProperty(keyStr)));
            }
        }
        if (this.parameters.containsKey(INDEX_ID)) {
            this.indexId = this.getValueFactory().createIRI(this.parameters.getProperty(INDEX_ID));
        }
        try {
            if (this.parameters.containsKey(REINDEX_QUERY_KEY)) {
                this.setReindexQuery(this.parameters.getProperty(REINDEX_QUERY_KEY));
            }
            if (this.parameters.containsKey(INCOMPLETE_QUERY_FAIL_KEY)) {
                this.setIncompleteQueryFails(Boolean.parseBoolean(this.parameters.getProperty(INCOMPLETE_QUERY_FAIL_KEY)));
            }
            if (this.parameters.containsKey(EVALUATION_MODE_KEY)) {
                this.setEvaluationMode(TupleFunctionEvaluationMode.valueOf((String)this.parameters.getProperty(EVALUATION_MODE_KEY)));
            }
            if (this.parameters.containsKey(FUZZY_PREFIX_LENGTH_KEY)) {
                this.setFuzzyPrefixLength(NumberUtils.toInt((String)this.parameters.getProperty(FUZZY_PREFIX_LENGTH_KEY), (int)0));
            }
            if (this.luceneIndex == null) {
                this.initializeLuceneIndex();
            }
        }
        catch (Exception e) {
            throw new SailException("Could not initialize LuceneSail: " + e.getMessage(), (Throwable)e);
        }
    }

    @Deprecated
    protected static SearchIndex createSearchIndex(Properties parameters) throws Exception {
        return SearchIndexUtils.createSearchIndex(parameters);
    }

    protected void initializeLuceneIndex() throws Exception {
        SearchIndex index = SearchIndexUtils.createSearchIndex(this.parameters);
        this.setLuceneIndex(index);
    }

    public void setParameter(String key, String value) {
        this.parameters.setProperty(key, value);
    }

    public String getParameter(String key) {
        return this.parameters.getProperty(key);
    }

    public Set<String> getParameterNames() {
        return this.parameters.stringPropertyNames();
    }

    public String getReindexQuery() {
        return this.reindexQuery;
    }

    public void setReindexQuery(String query) {
        this.setParameter(REINDEX_QUERY_KEY, query);
        this.reindexQuery = query;
    }

    public boolean isIncompleteQueryFails() {
        return this.incompleteQueryFails;
    }

    public void setIncompleteQueryFails(boolean incompleteQueryFails) {
        this.setParameter(INCOMPLETE_QUERY_FAIL_KEY, Boolean.toString(incompleteQueryFails));
        this.incompleteQueryFails = incompleteQueryFails;
    }

    public TupleFunctionEvaluationMode getEvaluationMode() {
        return this.evaluationMode;
    }

    public void setEvaluationMode(TupleFunctionEvaluationMode mode) {
        Objects.requireNonNull(mode);
        this.setParameter(EVALUATION_MODE_KEY, mode.name());
        this.evaluationMode = mode;
    }

    public TypeBacktraceMode getIndexBacktraceMode() {
        return this.indexBacktraceMode;
    }

    public void setIndexBacktraceMode(TypeBacktraceMode mode) {
        Objects.requireNonNull(mode);
        this.setParameter(INDEX_TYPE_BACKTRACE_MODE, mode.name());
        this.indexBacktraceMode = mode;
    }

    public void setFuzzyPrefixLength(int fuzzyPrefixLength) {
        this.setParameter(FUZZY_PREFIX_LENGTH_KEY, String.valueOf(fuzzyPrefixLength));
    }

    public TupleFunctionRegistry getTupleFunctionRegistry() {
        return this.tupleFunctionRegistry;
    }

    public void setTupleFunctionRegistry(TupleFunctionRegistry registry) {
        this.tupleFunctionRegistry = registry;
    }

    public FederatedServiceResolver getFederatedServiceResolver() {
        return this.serviceResolver;
    }

    public void setFederatedServiceResolver(FederatedServiceResolver resolver) {
        this.serviceResolver = resolver;
        super.setFederatedServiceResolver(resolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reindex() throws SailException {
        try {
            logger.info("Reindexing sail: clearing...");
            this.luceneIndex.clear();
            logger.info("Reindexing sail: adding...");
            try {
                this.luceneIndex.begin();
                SailRepository repo = new SailRepository((Sail)new NotifyingSailWrapper(this.getBaseSail()){

                    public void init() {
                    }

                    public void shutDown() {
                    }
                });
                try (SailRepositoryConnection connection = repo.getConnection();){
                    TupleQuery query = connection.prepareTupleQuery(QueryLanguage.SPARQL, this.reindexQuery);
                    try (TupleQueryResult res = query.evaluate();){
                        Resource current = null;
                        ValueFactory vf = this.getValueFactory();
                        ArrayList<Statement> statements = new ArrayList<Statement>();
                        while (res.hasNext()) {
                            BindingSet set = (BindingSet)res.next();
                            Resource r = (Resource)set.getValue("s");
                            IRI p = (IRI)set.getValue("p");
                            Value o = set.getValue("o");
                            Resource c = (Resource)set.getValue("c");
                            if (current == null) {
                                current = r;
                            } else if (!current.equals((Object)r)) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug("reindexing resource " + String.valueOf(current));
                                }
                                this.luceneIndex.addDocuments(current, statements);
                                current = r;
                                statements.clear();
                            }
                            statements.add(vf.createStatement(r, p, o, c));
                        }
                        if (current != null && !statements.isEmpty()) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("reindexing resource " + String.valueOf(current));
                            }
                            this.luceneIndex.addDocuments(current, statements);
                        }
                    }
                }
                finally {
                    repo.shutDown();
                }
                this.luceneIndex.commit();
                logger.info("Reindexing sail: done.");
            }
            catch (Exception e) {
                logger.error("Rolling back", (Throwable)e);
                this.luceneIndex.rollback();
                throw e;
            }
        }
        catch (Exception e) {
            throw new SailException("Could not reindex LuceneSail: " + e.getMessage(), (Throwable)e);
        }
    }

    public void registerStatementFilter(IndexableStatementFilter filter) {
        this.filter = filter;
    }

    protected boolean acceptStatementToIndex(Statement s) {
        IndexableStatementFilter nextFilter = this.filter;
        return nextFilter != null ? nextFilter.accept(s) : true;
    }

    public Statement mapStatement(Statement statement) {
        Set<IRI> nextIndexedFields;
        IRI res;
        IRI p = statement.getPredicate();
        boolean predicateChanged = false;
        Map<IRI, IRI> nextIndexedFieldsMapping = this.indexedFieldsMapping;
        if (nextIndexedFieldsMapping != null && (res = nextIndexedFieldsMapping.get(p)) != null) {
            p = res;
            predicateChanged = true;
        }
        if ((nextIndexedFields = this.indexedFields) != null && !nextIndexedFields.contains(p)) {
            return null;
        }
        if (predicateChanged) {
            return this.getValueFactory().createStatement(statement.getSubject(), p, statement.getObject(), statement.getContext());
        }
        return statement;
    }

    protected Collection<SearchQueryInterpreter> getSearchQueryInterpreters() {
        return Arrays.asList(new QuerySpecBuilder(this.incompleteQueryFails, this.indexId), new DistanceQuerySpecBuilder(this.luceneIndex), new GeoRelationQuerySpecBuilder(this.luceneIndex));
    }
}

