/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.exports;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.exports.FeatureExportInfo;
import org.eclipse.pde.internal.core.exports.FeatureExportOperation;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;

public abstract class FeatureBasedExportOperation
extends FeatureExportOperation {
    protected String fFeatureLocation;

    public FeatureBasedExportOperation(FeatureExportInfo info, String name) {
        super(info, name);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected IStatus run(IProgressMonitor monitor) {
        subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Exporting...", (int)33);
        try {
            this.createDestination();
            featureID = "org.eclipse.pde.container.feature";
            this.fFeatureLocation = this.fBuildTempLocation + File.separator + featureID;
            config = new String[][]{{TargetPlatform.getOS(), TargetPlatform.getWS(), TargetPlatform.getOSArch(), TargetPlatform.getNL()}};
            this.createFeature(featureID, this.fFeatureLocation, config, false);
            this.createBuildPropertiesFile(this.fFeatureLocation);
            if (this.fInfo.useJarFormat) {
                this.createPostProcessingFiles();
            }
            status = this.testBuildWorkspaceBeforeExport((IProgressMonitor)subMonitor.split(10));
            this.doExport(featureID, null, this.fFeatureLocation, config, (IProgressMonitor)subMonitor.split(20));
            if (subMonitor.isCanceled()) {
                var7_9 = Status.CANCEL_STATUS;
                return var7_9;
            }
            var7_10 = status;
            return var7_10;
        }
        catch (IOException e) {
            var7_11 = Status.error((String)PDECoreMessages.FeatureBasedExportOperation_ProblemDuringExport, (Throwable)e);
            return var7_11;
        }
        catch (CoreException e) {
            var7_12 = e.getStatus();
            return var7_12;
        }
        catch (InvocationTargetException e) {
            var7_13 = Status.error((String)PDECoreMessages.FeatureBasedExportOperation_ProblemDuringExport, (Throwable)e.getTargetException());
            return var7_13;
        }
        finally {
            var11_16 = this.fInfo.items;
            var10_22 = this.fInfo.items.length;
            var9_28 = 0;
            ** while (var9_28 < var10_22)
        }
lbl-1000:
        // 1 sources

        {
            item = var11_16[var9_28];
            if (item instanceof IModel) {
                try {
                    this.deleteBuildFiles(item);
                }
                catch (CoreException e) {
                    PDECore.log(e);
                }
            }
            ++var9_28;
            continue;
        }
lbl41:
        // 1 sources

        this.cleanup((IProgressMonitor)subMonitor.split(3));
        return var7_11;
    }

    protected abstract void createPostProcessingFiles();

    @Override
    protected String[] getPaths() {
        String[] paths = super.getPaths();
        String[] all = new String[paths.length + 1];
        all[0] = this.fFeatureLocation + File.separator + "feature.xml";
        System.arraycopy(paths, 0, all, 1, paths.length);
        return all;
    }

    private void createBuildPropertiesFile(String featureLocation) {
        File file = new File(featureLocation);
        if (!file.exists() || !file.isDirectory()) {
            file.mkdirs();
        }
        Properties prop = new Properties();
        prop.put("pde", "marker");
        if (this.fInfo.exportSource && this.fInfo.exportSourceBundle) {
            prop.put("individualSourceBundles", "true");
            Hashtable<String, String> environment = new Hashtable<String, String>(4);
            ((Dictionary)environment).put("osgi.os", TargetPlatform.getOS());
            ((Dictionary)environment).put("osgi.ws", TargetPlatform.getWS());
            ((Dictionary)environment).put("osgi.arch", TargetPlatform.getOSArch());
            ((Dictionary)environment).put("osgi.nl", TargetPlatform.getNL());
            Object[] objectArray = this.fInfo.items;
            int n = this.fInfo.items.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                if (item instanceof IFeatureModel) {
                    IFeature feature = ((IFeatureModel)item).getFeature();
                    prop.put("generate.feature@" + feature.getId() + ".source", feature.getId());
                } else {
                    BundleDescription bundle = null;
                    if (item instanceof IPluginModelBase) {
                        bundle = ((IPluginModelBase)item).getBundleDescription();
                    }
                    if (bundle == null && item instanceof BundleDescription) {
                        bundle = (BundleDescription)item;
                    }
                    if (bundle != null && this.shouldAddPlugin(bundle, environment)) {
                        prop.put("generate.plugin@" + bundle.getSymbolicName() + ".source", bundle.getSymbolicName());
                    }
                }
                ++n2;
            }
        }
        this.save(new File(file, "build.properties"), prop, "Marker File");
    }
}

