/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.synchronize;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.synchronize.GitCommitsModelCache;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;

public class StagedChangeCache {
    public static Map<String, GitCommitsModelCache.Change> build(Repository repo) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (TreeWalk tw = new TreeWalk(repo);){
                AbbreviatedObjectId commitId;
                tw.addTree((AbstractTreeIterator)new DirCacheIterator(repo.readDirCache()));
                ObjectId headId = repo.resolve("HEAD");
                RevCommit headCommit = null;
                if (headId != null) {
                    Throwable throwable2 = null;
                    Object var7_11 = null;
                    try (RevWalk rw = new RevWalk(repo);){
                        headCommit = rw.parseCommit((AnyObjectId)headId);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                if (headCommit != null) {
                    tw.addTree((AnyObjectId)headCommit.getTree());
                    commitId = AbbreviatedObjectId.fromObjectId(headCommit);
                } else {
                    tw.addTree((AbstractTreeIterator)new EmptyTreeIterator());
                    commitId = AbbreviatedObjectId.fromObjectId((AnyObjectId)ObjectId.zeroId());
                }
                tw.setRecursive(true);
                headCommit = null;
                MutableObjectId idBuf = new MutableObjectId();
                HashMap<String, GitCommitsModelCache.Change> result = new HashMap<String, GitCommitsModelCache.Change>();
                while (tw.next()) {
                    if (!StagedChangeCache.shouldIncludeEntry(tw)) continue;
                    GitCommitsModelCache.Change change = new GitCommitsModelCache.Change();
                    change.name = tw.getNameString();
                    change.remoteCommitId = commitId;
                    tw.getObjectId(idBuf, 0);
                    change.objectId = AbbreviatedObjectId.fromObjectId((AnyObjectId)idBuf);
                    tw.getObjectId(idBuf, 1);
                    change.remoteObjectId = AbbreviatedObjectId.fromObjectId((AnyObjectId)idBuf);
                    GitCommitsModelCache.calculateAndSetChangeKind(8, change);
                    result.put(tw.getPathString(), change);
                }
                return result;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.logError(e.getMessage(), e);
            return new HashMap<String, GitCommitsModelCache.Change>(0);
        }
    }

    private static boolean shouldIncludeEntry(TreeWalk tw) {
        int mHead = tw.getRawMode(1);
        int mCache = tw.getRawMode(0);
        return mHead == FileMode.MISSING.getBits() || mCache == FileMode.MISSING.getBits() || mHead != mCache || mCache != FileMode.TREE.getBits() && !tw.idEqual(1, 0);
    }
}

