/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.osgi.impl;

import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.cache.CachingHttpClientBuilder;
import org.apache.http.osgi.impl.HttpClientBuilderConfigurator;
import org.apache.http.osgi.impl.HttpProxyConfigurationActivator;
import org.apache.http.osgi.services.CachingHttpClientBuilderFactory;

final class OSGiCachingHttpClientBuilderFactory
implements CachingHttpClientBuilderFactory {
    private final HttpClientBuilderConfigurator configurator;
    private final HttpProxyConfigurationActivator.HttpClientTracker httpClientTracker;

    OSGiCachingHttpClientBuilderFactory(HttpClientBuilderConfigurator configurator, HttpProxyConfigurationActivator.HttpClientTracker httpClientTracker) {
        this.configurator = configurator;
        this.httpClientTracker = httpClientTracker;
    }

    @Override
    public CachingHttpClientBuilder newBuilder() {
        return this.configurator.configure(new CachingHttpClientBuilder(){

            @Override
            public CloseableHttpClient build() {
                CloseableHttpClient client = super.build();
                OSGiCachingHttpClientBuilderFactory.this.httpClientTracker.track(client);
                return client;
            }
        });
    }
}

