/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.core.plugin;

import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum VersionMatchRule {
    PERFECT("perfect"){

        @Override
        public VersionRange rangeFor(Version reference) {
            return new VersionRange('[', reference, reference, ']');
        }

        @Override
        public boolean matches(Version version, Version reference) {
            return reference.equals((Object)version);
        }
    }
    ,
    EQUIVALENT("equivalent"){

        @Override
        public VersionRange rangeFor(Version reference) {
            Version upperBound = new Version(reference.getMajor(), reference.getMinor() + 1, 0);
            return new VersionRange('[', reference, upperBound, ')');
        }

        @Override
        public boolean matches(Version version, Version reference) {
            return version.getMajor() == reference.getMajor() && version.getMinor() == reference.getMinor() && version.compareTo(reference) >= 0;
        }
    }
    ,
    COMPATIBLE("compatible"){

        @Override
        public VersionRange rangeFor(Version reference) {
            Version upperBound = new Version(reference.getMajor() + 1, 0, 0);
            return new VersionRange('[', reference, upperBound, ')');
        }

        @Override
        public boolean matches(Version version, Version reference) {
            return version.getMajor() == reference.getMajor() && version.compareTo(reference) >= 0;
        }
    }
    ,
    GREATER_OR_EQUAL("greaterOrEqual"){

        @Override
        public VersionRange rangeFor(Version reference) {
            return new VersionRange('[', reference, null, ')');
        }

        @Override
        public boolean matches(Version version, Version reference) {
            return version.compareTo(reference) >= 0;
        }
    };

    private final String name;

    private VersionMatchRule(String name) {
        this.name = name;
    }

    public abstract VersionRange rangeFor(Version var1);

    public abstract boolean matches(Version var1, Version var2);

    public String toString() {
        return this.name;
    }
}

