/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.nls;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.nls.InternationalizeModelTable;

public class InternationalizeOperation
implements IRunnableWithProgress {
    private final ISelection fSelection;
    private ArrayList<Object> fSelectedModels;
    private InternationalizeModelTable<IPluginModelBase> fModelPluginTable;
    private boolean fCanceled;

    public InternationalizeOperation(ISelection selection) {
        this.fSelection = selection;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (this.fSelection instanceof IStructuredSelection) {
            Object[] elems = ((IStructuredSelection)this.fSelection).toArray();
            this.fSelectedModels = new ArrayList(elems.length);
            int i = 0;
            while (i < elems.length) {
                if (elems[i] instanceof IFile) {
                    elems[i] = ((IFile)elems[i]).getProject();
                }
                if (elems[i] instanceof IProject && WorkspaceModelManager.isPluginProject((IProject)((IProject)elems[i])) && !WorkspaceModelManager.isBinaryProject((IProject)((IProject)elems[i]))) {
                    this.fSelectedModels.add(elems[i]);
                }
                ++i;
            }
        }
        IPluginModelBase[] pluginModels = PluginRegistry.getAllModels((boolean)false);
        monitor.beginTask(PDEUIMessages.GetNonExternalizedStringsOperation_taskMessage, pluginModels.length);
        this.fModelPluginTable = new InternationalizeModelTable();
        IPluginModelBase[] iPluginModelBaseArray = pluginModels;
        int n = pluginModels.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase pluginModel;
            this.fModelPluginTable.addToModelTable(pluginModel, (pluginModel = iPluginModelBaseArray[n2]).getUnderlyingResource() != null ? this.selected(pluginModel.getUnderlyingResource().getProject()) : false);
            ++n2;
        }
    }

    public boolean wasCanceled() {
        return this.fCanceled;
    }

    public boolean selected(IProject project) {
        return this.fSelectedModels.contains(project);
    }

    public InternationalizeModelTable<IPluginModelBase> getPluginTable() {
        return this.fModelPluginTable;
    }
}

