/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.compare;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DocumentRangeNode;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.compare.structuremergeviewer.StructureCreator;
import org.eclipse.compare.structuremergeviewer.StructureRootNode;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.text.ManifestPartitionScanner;
import org.eclipse.swt.graphics.Image;

public class ManifestStructureCreator
extends StructureCreator {
    public String getName() {
        return PDEUIMessages.ManifestStructureCreator_name;
    }

    public IStructureComparator locate(Object path, Object input) {
        return null;
    }

    public String getContents(Object node, boolean ignoreWhitespace) {
        if (node instanceof IStreamContentAccessor) {
            IStreamContentAccessor sca = (IStreamContentAccessor)node;
            try {
                return ManifestStructureCreator.readString(sca);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    private void parseManifest(DocumentRangeNode root, IDocument doc, IProgressMonitor monitor) {
        int lineStart = 0;
        int[] args = new int[]{0, 0};
        String id = "Manifest";
        ManifestNode parent = new ManifestNode(root, 0, id, doc, 0, doc.getLength());
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor).split(1);
        StringBuilder headerBuffer = new StringBuilder();
        int headerStart = 0;
        while (true) {
            lineStart = args[1];
            String line = this.readLine(args, doc);
            if (line == null) {
                return;
            }
            if (line.length() <= 0) {
                this.saveNode(parent, doc, headerBuffer.toString(), headerStart);
                continue;
            }
            if (line.charAt(0) == ' ') {
                if (headerBuffer.length() <= 0) continue;
                headerBuffer.append(line);
                continue;
            }
            this.saveNode(parent, doc, headerBuffer.toString(), headerStart);
            headerStart = lineStart;
            headerBuffer.replace(0, headerBuffer.length(), line);
            subMonitor.worked(1);
        }
    }

    private void saveNode(DocumentRangeNode root, IDocument doc, String header, int start) {
        if (header.length() > 0) {
            new ManifestNode(root, 1, this.extractKey(header), doc, start, header.length());
        }
    }

    private String extractKey(String headerBuffer) {
        int assign = headerBuffer.indexOf(58);
        if (assign != -1) {
            return headerBuffer.substring(0, assign);
        }
        return headerBuffer;
    }

    private String readLine(int[] args, IDocument doc) {
        int line;
        block5: {
            int n = args[0];
            args[0] = n + 1;
            line = n;
            try {
                if (line < doc.getNumberOfLines()) break block5;
                return null;
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        int start = doc.getLineOffset(line);
        int length = doc.getLineLength(line);
        try {
            args[1] = doc.getLineOffset(line + 1);
        }
        catch (BadLocationException ex) {
            args[1] = doc.getLength();
        }
        return doc.get(start, length);
    }

    private static String readString(InputStream is, String encoding) {
        if (is == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        char[] part = new char[2048];
        int read = 0;
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, encoding));){
                while ((read = reader.read(part)) != -1) {
                    buffer.append(part, 0, read);
                }
                return buffer.toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String readString(IStreamContentAccessor sa) throws CoreException {
        InputStream is = sa.getContents();
        if (is != null) {
            String encoding = null;
            if (sa instanceof IEncodedStreamContentAccessor) {
                try {
                    encoding = ((IEncodedStreamContentAccessor)sa).getCharset();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (encoding == null) {
                encoding = ResourcesPlugin.getEncoding();
            }
            return ManifestStructureCreator.readString(is, encoding);
        }
        return null;
    }

    protected IDocumentPartitioner getDocumentPartitioner() {
        return new FastPartitioner((IPartitionTokenScanner)new ManifestPartitionScanner(), ManifestPartitionScanner.PARTITIONS);
    }

    protected String getDocumentPartitioning() {
        return "___mf_partitioning";
    }

    protected IStructureComparator createStructureComparator(Object input, IDocument document, ISharedDocumentAdapter adapter, IProgressMonitor monitor) throws CoreException {
        final boolean isEditable = input instanceof IEditableContent ? ((IEditableContent)input).isEditable() : false;
        StructureRootNode rootNode = new StructureRootNode(document, input, this, adapter){

            public boolean isEditable() {
                return isEditable;
            }
        };
        this.parseManifest((DocumentRangeNode)rootNode, document, monitor);
        return rootNode;
    }

    static class ManifestNode
    extends DocumentRangeNode
    implements ITypedElement {
        public ManifestNode(DocumentRangeNode parent, int type, String id, IDocument doc, int start, int length) {
            super(parent, type, id, doc, start, length);
            if (parent != null) {
                parent.addChild((DocumentRangeNode)this);
            }
        }

        public String getName() {
            return this.getId();
        }

        public String getType() {
            return "MF2";
        }

        public Image getImage() {
            return CompareUI.getImage((String)this.getType());
        }
    }
}

