/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.nodemodel.impl;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.nodemodel.BidiTreeIterable;
import org.eclipse.xtext.nodemodel.BidiTreeIterator;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.SyntaxErrorMessage;
import org.eclipse.xtext.nodemodel.impl.BasicNodeTreeIterator;
import org.eclipse.xtext.nodemodel.impl.CompositeNode;
import org.eclipse.xtext.nodemodel.impl.RootNode;
import org.eclipse.xtext.nodemodel.serialization.DeserializationConversionContext;
import org.eclipse.xtext.nodemodel.serialization.SerializationConversionContext;
import org.eclipse.xtext.nodemodel.serialization.SerializationUtil;
import org.eclipse.xtext.nodemodel.util.NodeTreeIterator;
import org.eclipse.xtext.nodemodel.util.ReversedBidiTreeIterable;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.util.TextRegionWithLineInformation;

public abstract class AbstractNode
implements INode,
BidiTreeIterable<INode> {
    private CompositeNode parent;
    private AbstractNode prev;
    private AbstractNode next;
    private Object grammarElementOrArray;

    @Override
    public ITextRegion getTextRegion() {
        int offset = this.getOffset();
        int length = this.getEndOffset() - offset;
        return new TextRegion(offset, length);
    }

    @Override
    public ITextRegion getTotalTextRegion() {
        int totalOffset = this.getTotalOffset();
        int totalLength = this.getTotalLength();
        return new TextRegion(totalOffset, totalLength);
    }

    @Override
    public ITextRegionWithLineInformation getTextRegionWithLineInformation() {
        int offset = this.getOffset();
        int length = this.getEndOffset() - offset;
        return this.getTextRegionWithLineInformation(offset, length);
    }

    @Override
    public ITextRegionWithLineInformation getTotalTextRegionWithLineInformation() {
        int totalOffset = this.getTotalOffset();
        int totalLength = this.getTotalLength();
        return this.getTextRegionWithLineInformation(totalOffset, totalLength);
    }

    protected ITextRegionWithLineInformation getTextRegionWithLineInformation(int offset, int length) {
        ICompositeNode rootNode = this.getRootNode();
        if (rootNode != null) {
            int startLine = this.basicGetLineOfOffset(rootNode, offset);
            int endLine = this.basicGetLineOfOffset(rootNode, offset + length);
            return new TextRegionWithLineInformation(offset, length, startLine, endLine);
        }
        return new TextRegionWithLineInformation(offset, length, 1, 1);
    }

    @Override
    public ICompositeNode getParent() {
        if (this.parent != null) {
            return this.parent.resolveAsParent();
        }
        return null;
    }

    protected CompositeNode basicGetParent() {
        return this.parent;
    }

    protected void basicSetParent(CompositeNode parent) {
        this.parent = parent;
    }

    @Override
    public BidiTreeIterable<INode> getAsTreeIterable() {
        return this;
    }

    @Override
    public BidiTreeIterator<INode> iterator() {
        return new NodeTreeIterator(this);
    }

    @Override
    public BidiTreeIterable<INode> reverse() {
        return new ReversedBidiTreeIterable<INode>(this);
    }

    @Override
    public Iterable<ILeafNode> getLeafNodes() {
        return new Iterable<ILeafNode>(){

            @Override
            public Iterator<ILeafNode> iterator() {
                return Iterators.filter(AbstractNode.this.basicIterator(), ILeafNode.class);
            }
        };
    }

    public BidiTreeIterator<AbstractNode> basicIterator() {
        return new BasicNodeTreeIterator(this);
    }

    @Override
    public String getText() {
        ICompositeNode rootNode = this.getRootNode();
        if (rootNode != null) {
            int offset = this.getTotalOffset();
            int length = this.getTotalLength();
            return rootNode.getText().substring(offset, offset + length);
        }
        return null;
    }

    @Override
    public int getTotalStartLine() {
        ICompositeNode rootNode = this.getRootNode();
        if (rootNode != null) {
            return this.basicGetLineOfOffset(rootNode, this.getTotalOffset());
        }
        return 1;
    }

    protected int basicGetLineOfOffset(INode rootNode, int offset) {
        if (rootNode instanceof RootNode) {
            int[] lineBreakOffsets = ((RootNode)rootNode).basicGetLineBreakOffsets();
            int insertionPoint = Arrays.binarySearch(lineBreakOffsets, offset);
            if (insertionPoint >= 0) {
                return insertionPoint + 1;
            }
            return -insertionPoint;
        }
        String leadingText = rootNode.getText().substring(0, offset);
        int result = Strings.countLines((String)leadingText);
        return result + 1;
    }

    @Override
    public int getStartLine() {
        ICompositeNode rootNode = this.getRootNode();
        if (rootNode != null) {
            int offset = this.getOffset();
            return this.basicGetLineOfOffset(rootNode, offset);
        }
        return 1;
    }

    @Override
    public int getEndLine() {
        ICompositeNode rootNode = this.getRootNode();
        if (rootNode != null) {
            return this.basicGetLineOfOffset(rootNode, this.getEndOffset());
        }
        return 1;
    }

    @Override
    public int getTotalEndLine() {
        ICompositeNode rootNode = this.getRootNode();
        if (rootNode != null) {
            int offset = this.getTotalEndOffset();
            return this.basicGetLineOfOffset(rootNode, offset);
        }
        return 1;
    }

    @Override
    public int getOffset() {
        UnmodifiableIterator leafIter = Iterators.filter(this.basicIterator(), ILeafNode.class);
        int firstLeafOffset = -1;
        while (leafIter.hasNext()) {
            ILeafNode leaf = (ILeafNode)leafIter.next();
            if (firstLeafOffset == -1) {
                firstLeafOffset = leaf.getTotalOffset();
            }
            if (leaf.isHidden()) continue;
            return leaf.getTotalOffset();
        }
        if (firstLeafOffset != -1) {
            return firstLeafOffset;
        }
        return this.getTotalOffset();
    }

    @Override
    public int getLength() {
        BidiTreeIterator<AbstractNode> iter = this.basicIterator();
        while (iter.hasPrevious()) {
            INode prev = (INode)iter.previous();
            if (!(prev instanceof ILeafNode) || ((ILeafNode)prev).isHidden()) continue;
            int offset = this.getOffset();
            return prev.getTotalEndOffset() - offset;
        }
        return this.getTotalLength();
    }

    @Override
    public int getTotalEndOffset() {
        return this.getTotalOffset() + this.getTotalLength();
    }

    @Override
    public int getEndOffset() {
        BidiTreeIterator<AbstractNode> iter = this.basicIterator();
        while (iter.hasPrevious()) {
            INode prev = (INode)iter.previous();
            if (!(prev instanceof ILeafNode) || ((ILeafNode)prev).isHidden()) continue;
            return prev.getTotalEndOffset();
        }
        return this.getTotalEndOffset();
    }

    @Override
    public ICompositeNode getRootNode() {
        if (this.parent == null) {
            return null;
        }
        CompositeNode candidate = this.parent;
        while (candidate.basicGetParent() != null) {
            candidate = candidate.basicGetParent();
        }
        return candidate.getRootNode();
    }

    @Override
    public EObject getSemanticElement() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getSemanticElement();
    }

    protected EObject basicGetSemanticElement() {
        return null;
    }

    @Override
    public boolean hasDirectSemanticElement() {
        return this.basicGetSemanticElement() != null;
    }

    @Override
    public EObject getGrammarElement() {
        return (EObject)this.grammarElementOrArray;
    }

    protected Object basicGetGrammarElement() {
        return this.grammarElementOrArray;
    }

    protected void basicSetGrammarElement(Object grammarElementOrArray) {
        this.grammarElementOrArray = grammarElementOrArray;
    }

    @Override
    public SyntaxErrorMessage getSyntaxErrorMessage() {
        return null;
    }

    @Override
    public INode getPreviousSibling() {
        if (!this.hasPreviousSibling()) {
            return null;
        }
        return this.prev;
    }

    protected AbstractNode basicGetPreviousSibling() {
        return this.prev;
    }

    protected void basicSetPreviousSibling(AbstractNode prev) {
        this.prev = prev;
    }

    @Override
    public INode getNextSibling() {
        if (!this.hasNextSibling()) {
            return null;
        }
        return this.next;
    }

    protected AbstractNode basicGetNextSibling() {
        return this.next;
    }

    protected void basicSetNextSibling(AbstractNode next) {
        this.next = next;
    }

    @Override
    public boolean hasPreviousSibling() {
        return this.basicHasPreviousSibling();
    }

    protected boolean basicHasPreviousSibling() {
        if (this.parent == null) {
            return false;
        }
        return this.parent.basicGetFirstChild() != this;
    }

    @Override
    public boolean hasNextSibling() {
        return this.basicHasNextSibling();
    }

    protected boolean basicHasNextSibling() {
        if (this.parent == null) {
            return false;
        }
        return this.parent.basicGetLastChild() != this;
    }

    @Override
    public boolean hasSiblings() {
        return this.basicHasSiblings();
    }

    protected boolean basicHasSiblings() {
        return this.prev != this;
    }

    abstract NodeType getNodeId();

    void readData(DataInputStream in, DeserializationConversionContext context) throws IOException {
        int length = SerializationUtil.readInt(in, true);
        if (length == 1) {
            int grammarId = SerializationUtil.readInt(in, true);
            this.grammarElementOrArray = context.getGrammarElement(grammarId);
        } else if (length > 0) {
            EObject[] grammarElements = new EObject[length];
            int i = 0;
            while (i < length) {
                EObject grammarElement;
                int grammarId = SerializationUtil.readInt(in, true);
                grammarElements[i] = grammarElement = context.getGrammarElement(grammarId);
                ++i;
            }
            this.grammarElementOrArray = grammarElements;
        } else {
            if (length != -1) {
                throw new IllegalStateException("Read unexpected length of grammar element array from stream: " + length);
            }
            this.grammarElementOrArray = null;
        }
    }

    void write(DataOutputStream out, SerializationConversionContext scc) throws IOException {
        if (this.grammarElementOrArray instanceof EObject) {
            EObject eObject = (EObject)this.grammarElementOrArray;
            SerializationUtil.writeInt(out, 1, true);
            this.writeGrammarId(out, scc, eObject);
        } else if (this.grammarElementOrArray instanceof EObject[]) {
            EObject[] eObjects = (EObject[])this.grammarElementOrArray;
            SerializationUtil.writeInt(out, eObjects.length, true);
            EObject[] eObjectArray = eObjects;
            int n = eObjects.length;
            int n2 = 0;
            while (n2 < n) {
                EObject eObject = eObjectArray[n2];
                this.writeGrammarId(out, scc, eObject);
                ++n2;
            }
        } else {
            SerializationUtil.writeInt(out, -1, true);
        }
    }

    private void writeGrammarId(DataOutputStream out, SerializationConversionContext scc, EObject eObject) throws IOException {
        Integer grammarId = scc.getGrammarElementId(eObject);
        if (grammarId == null) {
            throw new IllegalStateException("Must write a grammar element but got an unknown EMF object of class " + eObject.getClass().getName());
        }
        SerializationUtil.writeInt(out, grammarId, true);
    }

    int fillGrammarElementToIdMap(int currentId, Map<EObject, Integer> grammarElementToIdMap, List<String> grammarIdToURIMap) {
        if (this.grammarElementOrArray != null) {
            if (this.grammarElementOrArray instanceof EObject) {
                EObject grammarElement = (EObject)this.grammarElementOrArray;
                currentId = this.updateMapping(currentId, grammarElementToIdMap, grammarIdToURIMap, grammarElement);
            }
            if (this.grammarElementOrArray instanceof EObject[]) {
                EObject[] grammarElements;
                EObject[] eObjectArray = grammarElements = (EObject[])this.grammarElementOrArray;
                int n = grammarElements.length;
                int n2 = 0;
                while (n2 < n) {
                    EObject grammarElement = eObjectArray[n2];
                    currentId = this.updateMapping(currentId, grammarElementToIdMap, grammarIdToURIMap, grammarElement);
                    ++n2;
                }
            }
        }
        return currentId;
    }

    private int updateMapping(int currentId, Map<EObject, Integer> grammarElementToIdMap, List<String> grammarIdToURIMap, EObject grammarElement) {
        if (!grammarElementToIdMap.containsKey(grammarElement)) {
            URI uri = EcoreUtil.getURI((EObject)grammarElement);
            if (uri == null) {
                throw new IllegalStateException("While building the map of grammar elements to an ID, got a grammar element that does not have an URI.  The grammar element has class " + grammarElement.eClass().getName());
            }
            grammarElementToIdMap.put(grammarElement, currentId);
            grammarIdToURIMap.add(uri.toString());
            ++currentId;
        }
        if (currentId != grammarIdToURIMap.size()) {
            throw new IllegalStateException("The next id for a grammar element will be " + currentId + " but the number of elements in " + "the map of grammar elements to IDs contains a different number of elements: " + grammarIdToURIMap.size());
        }
        return currentId;
    }

    static enum NodeType {
        CompositeNode,
        LeafNode,
        CompositeNodeWithSemanticElement,
        CompositeNodeWithSyntaxError,
        CompositeNodeWithSemanticElementAndSyntaxError,
        RootNode,
        HiddenLeafNode,
        HiddenLeafNodeWithSyntaxError,
        LeafNodeWithSyntaxError;

    }
}

