/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.debug;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.formatting2.ITextSegment;
import org.eclipse.xtext.formatting2.debug.TextRegionListToString;
import org.eclipse.xtext.formatting2.regionaccess.IComment;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegionPart;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISequentialRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.IWhitespace;
import org.eclipse.xtext.grammaranalysis.impl.GrammarElementTitleSwitch;
import org.eclipse.xtext.util.EmfFormatter;

public class TokenAccessToString {
    private static final int TITLE_WIDTH = 9;
    private static final String SEMANTIC_PADDED = Strings.padEnd((String)"Semantic", (int)9, (char)' ');
    private static final String HIDDEN = "Hidden";
    private static final String HIDDEN_PADDED = Strings.padEnd((String)"Hidden", (int)9, (char)' ');
    private static final String EOBJECT_START_PADDED = Strings.padEnd((String)"Start", (int)9, (char)' ');
    private static final String EOBJECT_END_PADDED = Strings.padEnd((String)"End", (int)9, (char)' ');
    private Function<AbstractElement, String> grammarToString = new GrammarElementTitleSwitch().showRule().showAssignments().showQualified();
    private boolean hideColumnExplanation = false;
    private boolean hightlightOrigin = false;
    private ITextSegment origin;

    public TokenAccessToString hideColumnExplanation() {
        this.hideColumnExplanation = true;
        return this;
    }

    public TokenAccessToString hightlightOrigin() {
        this.hightlightOrigin = true;
        return this;
    }

    public boolean isHideColumnExplanation() {
        return this.hideColumnExplanation;
    }

    public boolean isHightlightOrigin() {
        return this.hightlightOrigin;
    }

    protected String quote(String string, int maxLength) {
        if (string == null) {
            return "null";
        }
        if (string.length() > maxLength) {
            string = String.valueOf(string.substring(0, maxLength - 3)) + "...";
        }
        string = string.replace("\n", "\\n").replace("\r", "\\r");
        return "\"" + string + "\"";
    }

    protected void collectHiddenRegionsBySemanticObject(List<ITextSegment> regions, Multimap<IHiddenRegion, EObject> LeadingHiddens, Multimap<IHiddenRegion, EObject> trailingHiddens, List<String> errors) {
        ISemanticRegion next;
        HashSet sem = Sets.newHashSet();
        for (ITextSegment s : regions) {
            if (!(s instanceof ISemanticRegion)) continue;
            sem.add(((ISemanticRegion)s).getSemanticElement());
        }
        ISemanticRegion previous = ((ISequentialRegion)regions.get(0)).getPreviousSemanticRegion();
        if (previous != null) {
            sem.add(previous.getSemanticElement());
        }
        if ((next = ((ISequentialRegion)regions.get(regions.size() - 1)).getNextSemanticRegion()) != null) {
            sem.add(next.getSemanticElement());
        }
        sem.remove(null);
        HashSet containers = Sets.newHashSet();
        for (EObject s : sem) {
            EObject container = s.eContainer();
            while (container != null && containers.add(container)) {
                container = container.eContainer();
            }
        }
        sem.addAll(containers);
        ITextRegionAccess access = regions.get(0).getTextRegionAccess();
        for (EObject s : sem) {
            IHiddenRegion leading = access.leadingHiddenRegion(s);
            if (leading == null) {
                errors.add("ERROR: " + EmfFormatter.objPath((EObject)s) + " has no leading HiddenRegion.");
            } else {
                LeadingHiddens.put((Object)leading, (Object)s);
            }
            IHiddenRegion trailing = access.trailingHiddenRegion(s);
            if (trailing == null) {
                errors.add("ERROR: " + EmfFormatter.objPath((EObject)s) + " has no trailing HiddenRegion.");
                continue;
            }
            trailingHiddens.put((Object)trailing, (Object)s);
        }
    }

    protected String toString(Collection<EObject> objs) {
        ArrayList result = Lists.newArrayList();
        for (EObject obj : objs) {
            StringBuilder builder = new StringBuilder();
            EStructuralFeature containingFeature = obj.eContainingFeature();
            if (containingFeature != null) {
                builder.append(containingFeature.getName());
                if (containingFeature.isMany()) {
                    int index = ((List)obj.eContainer().eGet(containingFeature)).indexOf(obj);
                    builder.append("[" + index + "]");
                }
                builder.append("=");
            }
            builder.append(obj.eClass().getName());
            EStructuralFeature nameFeature = obj.eClass().getEStructuralFeature("name");
            if (nameFeature != null) {
                builder.append("'" + obj.eGet(nameFeature) + "'");
            }
            result.add(builder.toString());
        }
        Collections.sort(result);
        return Joiner.on((String)", ").join((Iterable)result);
    }

    public String toString() {
        List<ITextSegment> list = this.toTokenAndGapList();
        LinkedHashMultimap leadingHiddens = LinkedHashMultimap.create();
        LinkedHashMultimap trailingHiddens = LinkedHashMultimap.create();
        ArrayList errors = Lists.newArrayList();
        this.collectHiddenRegionsBySemanticObject(list, (Multimap<IHiddenRegion, EObject>)leadingHiddens, (Multimap<IHiddenRegion, EObject>)trailingHiddens, errors);
        TextRegionListToString result = new TextRegionListToString();
        if (!this.hideColumnExplanation) {
            String explanation = "Columns: 1:offset; 2:length; 3:hidden/semantic; 4: text; 5..n:grammar elements or whispace/comments";
            result.add(explanation, false);
        }
        for (String error : errors) {
            result.add(error, false);
        }
        for (ITextSegment region : list) {
            Collection collection;
            if (region instanceof IHiddenRegion && !(collection = trailingHiddens.get((Object)((IHiddenRegion)region))).isEmpty()) {
                result.add(String.valueOf(EOBJECT_END_PADDED) + this.toString(collection));
            }
            result.add(region, this.toString(region));
            if (!(region instanceof IHiddenRegion) || (collection = leadingHiddens.get((Object)((IHiddenRegion)region))).isEmpty()) continue;
            result.add(String.valueOf(EOBJECT_START_PADDED) + this.toString(collection));
        }
        return result.toString();
    }

    protected String toString(AbstractRule rule) {
        return rule == null ? "null" : rule.getName();
    }

    protected String toString(EObject ele) {
        if (ele instanceof AbstractElement) {
            return (String)this.grammarToString.apply((Object)((AbstractElement)ele));
        }
        if (ele instanceof AbstractRule) {
            return String.valueOf(ele.eClass().getName()) + "'" + ((AbstractRule)ele).getName() + "'";
        }
        return ele.toString();
    }

    protected String toString(IComment comment) {
        String text = this.quote(comment.getText(), 10);
        String gammar = this.toString(comment.getGrammarElement());
        return String.format("%s Comment:%s", text, gammar);
    }

    protected String toString(IHiddenRegion gap) {
        List<IHiddenRegionPart> whitespaceAndComments = gap.getParts();
        ArrayList children = Lists.newArrayListWithExpectedSize((int)whitespaceAndComments.size());
        for (IHiddenRegionPart hidden : gap.getParts()) {
            children.add(this.toString(hidden));
        }
        if (children.isEmpty()) {
            return HIDDEN;
        }
        return String.valueOf(HIDDEN_PADDED) + Joiner.on((String)", ").join((Iterable)children);
    }

    protected String toString(ISemanticRegion token) {
        String text = this.quote(token.getText(), 10);
        return String.format("%s%s %s", SEMANTIC_PADDED, text, this.toString(token.getGrammarElement()));
    }

    protected String toString(ITextSegment region) {
        String result = region instanceof ISemanticRegion ? this.toString((ISemanticRegion)region) : (region instanceof IHiddenRegion ? this.toString((IHiddenRegion)region) : (region instanceof IWhitespace ? this.toString((IWhitespace)region) : (region instanceof IComment ? this.toString((IComment)region) : (region != null ? String.valueOf(region.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(region)) : "null"))));
        if (this.hightlightOrigin && region == this.origin) {
            return ">>>" + result + "<<<";
        }
        return result;
    }

    protected String toString(IWhitespace whitespace) {
        String text = this.quote(whitespace.getText(), 10);
        String grammar = this.toString(whitespace.getGrammarElement());
        return String.format("%s Whitespace:%s", text, grammar);
    }

    protected List<ITextSegment> toTokenAndGapList() {
        int range = this.hightlightOrigin ? 4 : 0x3FFFFFFF;
        ITextSegment first = null;
        ITextSegment current = this.origin;
        int i = 0;
        while (i < range && current != null) {
            first = current;
            if (current instanceof ITextRegionAccess) {
                current = ((ITextRegionAccess)((Object)current)).getFirstRegionInFile();
            }
            if (current instanceof ISemanticRegion) {
                current = ((ISemanticRegion)current).getPreviousHiddenRegion();
            } else if (current instanceof IHiddenRegion) {
                current = ((IHiddenRegion)current).getPreviousSemanticRegion();
            } else if (current instanceof IHiddenRegionPart) {
                current = ((IHiddenRegionPart)current).getHiddenRegion();
            } else {
                throw new IllegalStateException();
            }
            ++i;
        }
        if (first == null) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        ITextSegment current2 = first;
        int i2 = 0;
        while (i2 <= range * 2 && current2 != null) {
            result.add(current2);
            if (current2 instanceof ISemanticRegion) {
                current2 = ((ISemanticRegion)current2).getNextHiddenRegion();
            } else if (current2 instanceof IHiddenRegion) {
                current2 = ((IHiddenRegion)current2).getNextSemanticRegion();
            } else {
                throw new IllegalStateException();
            }
            ++i2;
        }
        return result;
    }

    public TokenAccessToString withOrigin(ITextSegment origin) {
        this.origin = origin;
        return this;
    }
}

