/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.parsetree.reconstr.impl;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parsetree.reconstr.impl.NodeIterator;
import org.eclipse.xtext.parsetree.reconstr.impl.TokenUtil;
import org.eclipse.xtext.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HiddenAndTokenNodeIterator
implements Iterator<INode> {
    private TokenUtil tokenUtil;
    private NodeIterator nodeIterator;
    private Queue<INode> nextNodes = Lists.newLinkedList();
    private INode next;

    public HiddenAndTokenNodeIterator(INode startNode, TokenUtil tokenUtil) {
        this.nodeIterator = new NodeIterator(startNode);
        this.tokenUtil = tokenUtil;
        this.next = this.findNext();
    }

    private INode findNext() {
        if (this.nextNodes.isEmpty()) {
            while (this.nodeIterator.hasNext()) {
                INode candidate = this.nodeIterator.next();
                if (this.tokenUtil.isToken(candidate)) {
                    this.nodeIterator.prune();
                    Pair<List<ILeafNode>, List<ILeafNode>> leadingAndTrailingHiddenTokens = this.tokenUtil.getLeadingAndTrailingHiddenTokens(candidate);
                    this.nextNodes.addAll((Collection)leadingAndTrailingHiddenTokens.getFirst());
                    this.nextNodes.add(candidate);
                    this.nextNodes.addAll((Collection)leadingAndTrailingHiddenTokens.getSecond());
                    return this.nextNodes.poll();
                }
                if (!this.tokenUtil.isWhitespaceOrCommentNode(candidate)) continue;
                return candidate;
            }
            return null;
        }
        return this.nextNodes.poll();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public INode next() {
        INode result = this.next;
        this.next = this.findNext();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

