/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.AbstractContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceDescriptionsBasedContainer
extends AbstractContainer
implements IResourceDescription.Event.Listener {
    private final IResourceDescriptions descriptions;
    private Map<URI, IResourceDescription> uriToDescription;
    private boolean uriToDescriptionCacheEnabled = true;

    public ResourceDescriptionsBasedContainer(IResourceDescriptions descriptions) {
        this.descriptions = descriptions;
    }

    @Override
    public IResourceDescription getResourceDescription(URI uri) {
        if (this.hasResourceDescription(uri)) {
            return this.getUriToDescription().get(uri);
        }
        return null;
    }

    @Override
    public Iterable<IResourceDescription> getResourceDescriptions() {
        return this.getUriToDescription().values();
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjects(EClass type, QualifiedName qualifiedName, boolean ignoreCase) {
        Iterable<IEObjectDescription> unfiltered = this.getDescriptions().getExportedObjects(type, qualifiedName, ignoreCase);
        return this.filterByURI(unfiltered);
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjectsByType(EClass type) {
        Iterable<IEObjectDescription> unfiltered = this.getDescriptions().getExportedObjectsByType(type);
        return this.filterByURI(unfiltered);
    }

    protected Iterable<IEObjectDescription> filterByURI(Iterable<IEObjectDescription> unfiltered) {
        return unfiltered;
    }

    @Override
    public int getResourceDescriptionCount() {
        return this.getUriToDescription().size();
    }

    public void setUriToDescriptionCacheEnabled(boolean enabled) {
        this.uriToDescriptionCacheEnabled = enabled;
    }

    public boolean isUriToDescriptionCacheEnabled() {
        return this.uriToDescriptionCacheEnabled;
    }

    protected Map<URI, IResourceDescription> getUriToDescription() {
        if (!this.uriToDescriptionCacheEnabled) {
            return this.doGetUriToDescription();
        }
        Map<URI, IResourceDescription> result = this.uriToDescription;
        if (result == null) {
            this.uriToDescription = result = this.doGetUriToDescription();
        }
        return result;
    }

    protected Map<URI, IResourceDescription> doGetUriToDescription() {
        Iterable filtered = Iterables.filter(this.descriptions.getAllResourceDescriptions(), (Predicate)new DelegatingPredicate());
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (IResourceDescription description : filtered) {
            result.put(description.getURI(), description);
        }
        return result;
    }

    protected boolean contains(IResourceDescription input) {
        return this.hasResourceDescription(input.getURI());
    }

    @Override
    public boolean hasResourceDescription(URI uri) {
        return true;
    }

    protected IResourceDescriptions getDescriptions() {
        return this.descriptions;
    }

    @Override
    public void descriptionsChanged(IResourceDescription.Event event) {
        if (this.uriToDescription != null) {
            for (IResourceDescription.Delta delta : event.getDeltas()) {
                URI uri = delta.getUri();
                if (!this.hasResourceDescription(uri) && this.uriToDescription.get(uri) == null) continue;
                if (delta.getNew() != null) {
                    this.uriToDescription.put(uri, delta.getNew());
                    continue;
                }
                this.uriToDescription.remove(uri);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DelegatingPredicate
    implements Predicate<IResourceDescription> {
        private DelegatingPredicate() {
        }

        public boolean apply(IResourceDescription input) {
            return ResourceDescriptionsBasedContainer.this.contains(input);
        }
    }
}

