/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.hover;

import com.google.common.collect.Lists;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.impl.FeatureCallToJavaMapping;
import org.eclipse.xtext.xbase.jvmmodel.ILogicalContainerProvider;
import org.eclipse.xtext.xbase.typing.ITypeProvider;
import org.eclipse.xtext.xbase.typing.XbaseTypeArgumentContextProvider;
import org.eclipse.xtext.xbase.ui.hover.FeatureCallRequestProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureCallRequest
extends XbaseTypeArgumentContextProvider.AbstractFeatureCallRequest {
    @Inject
    private ILogicalContainerProvider contextProvider;
    @Inject
    private ITypeProvider typeProvider;
    @Inject
    private FeatureCallToJavaMapping featureCallToJavaMapping;
    private XAbstractFeatureCall featureCall = null;

    public void setFeatureCall(XAbstractFeatureCall featureCall) {
        this.featureCall = featureCall;
    }

    public JvmFeature getFeature() {
        JvmIdentifiableElement feature = this.featureCall.getFeature();
        return feature instanceof JvmExecutable ? (JvmExecutable)feature : null;
    }

    public JvmTypeParameterDeclarator getNearestDeclarator() {
        Object context = this.featureCall;
        JvmTypeParameterDeclarator result = null;
        while (context != null && result == null) {
            if (context instanceof JvmTypeParameterDeclarator) {
                result = (JvmTypeParameterDeclarator)context;
                continue;
            }
            JvmIdentifiableElement logicalContainer = this.contextProvider.getLogicalContainer((EObject)context);
            context = logicalContainer != null ? logicalContainer : context.eContainer();
        }
        return result;
    }

    public JvmTypeReference getDeclaredType() {
        JvmIdentifiableElement feature = this.featureCall.getFeature();
        if (feature instanceof JvmOperation) {
            return ((JvmOperation)feature).getReturnType();
        }
        return null;
    }

    public JvmTypeReference getReceiverType() {
        if (this.featureCall instanceof XMemberFeatureCall) {
            return this.typeProvider.getType(((XMemberFeatureCall)this.featureCall).getMemberCallTarget());
        }
        XExpression actualReceiver = this.featureCallToJavaMapping.getActualReceiver(this.featureCall);
        JvmTypeReference receiverType = this.typeProvider.getType(actualReceiver);
        return receiverType;
    }

    public JvmTypeReference getExpectedType() {
        return this.typeProvider.getExpectedType((XExpression)this.featureCall);
    }

    public List<JvmTypeReference> getArgumentTypes() {
        ArrayList argumentTypes = Lists.newArrayList();
        for (XExpression argument : this.featureCallToJavaMapping.getActualArguments(this.featureCall)) {
            argumentTypes.add(this.typeProvider.getType(argument));
        }
        return argumentTypes;
    }

    public XAbstractFeatureCall getFeatureCall() {
        return this.featureCall;
    }

    @ImplementedBy(value=FeatureCallRequestProvider.class)
    public static interface IFeatureCallRequestProvider {
        public FeatureCallRequest get(XAbstractFeatureCall var1);
    }
}

