/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.resourceloader;

import com.google.common.collect.Lists;
import com.google.inject.ImplementedBy;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.builder.resourceloader.SerialResourceLoader;

@ImplementedBy(value=SerialResourceLoader.class)
public interface IResourceLoader {
    public LoadOperation create(ResourceSet var1, IProject var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface LoadOperation {
        public void load(Collection<URI> var1);

        public boolean hasNext();

        public LoadResult next() throws LoadOperationException;

        public Collection<URI> cancel();
    }

    public static class LoadOperationException
    extends WrappedException {
        private static final long serialVersionUID = 8499010336607816601L;
        private final URI uri;

        public LoadOperationException(URI uri, Throwable exception) {
            this(uri, new Exception(exception));
        }

        public LoadOperationException(URI uri, Exception exception) {
            super(exception);
            this.uri = uri;
        }

        public URI getUri() {
            return this.uri;
        }
    }

    public static class LoadResult {
        private Resource resource;
        private URI uri;

        public Resource getResource() {
            return this.resource;
        }

        public URI getUri() {
            return this.uri;
        }

        public LoadResult(Resource resource, URI uri) {
            this.resource = resource;
            this.uri = uri;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @ImplementedBy(value=NoSorting.class)
    public static interface Sorter {
        public Collection<URI> sort(Collection<URI> var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class NoSorting
        implements Sorter {
            @Override
            public Collection<URI> sort(Collection<URI> uris) {
                return Lists.newArrayList(uris);
            }
        }
    }
}

