/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.persistence;

import com.google.common.base.Objects;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.persistence.SerializationExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

@Accessors
public class SerializableReferenceDescription
implements IReferenceDescription,
Externalizable {
    private URI sourceEObjectUri;
    private URI targetEObjectUri;
    private URI containerEObjectURI;
    private EReference eReference;
    private int indexInList;

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int _readInt;
        EReference _readEcoreElement;
        URI _readURI_2;
        URI _readURI_1;
        URI _readURI;
        this.sourceEObjectUri = _readURI = SerializationExtensions.readURI(in);
        this.targetEObjectUri = _readURI_1 = SerializationExtensions.readURI(in);
        this.containerEObjectURI = _readURI_2 = SerializationExtensions.readURI(in);
        this.eReference = _readEcoreElement = (EReference)SerializationExtensions.readEcoreElement(in);
        this.indexInList = _readInt = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SerializationExtensions.writeURI(out, this.sourceEObjectUri);
        SerializationExtensions.writeURI(out, this.targetEObjectUri);
        SerializationExtensions.writeURI(out, this.containerEObjectURI);
        SerializationExtensions.writeEcoreElement(out, (ENamedElement)this.eReference);
        out.writeInt(this.indexInList);
    }

    public void updateResourceURI(URI newURI, URI oldURI) {
        URI _appendFragment;
        String _fragment = this.sourceEObjectUri.fragment();
        this.sourceEObjectUri = _appendFragment = newURI.appendFragment(_fragment);
        URI _trimFragment = this.targetEObjectUri.trimFragment();
        boolean _equals = Objects.equal((Object)_trimFragment, (Object)oldURI);
        if (_equals) {
            URI _appendFragment_1;
            String _fragment_1 = this.targetEObjectUri.fragment();
            this.targetEObjectUri = _appendFragment_1 = newURI.appendFragment(_fragment_1);
        }
    }

    @Override
    @Pure
    public URI getSourceEObjectUri() {
        return this.sourceEObjectUri;
    }

    public void setSourceEObjectUri(URI sourceEObjectUri) {
        this.sourceEObjectUri = sourceEObjectUri;
    }

    @Override
    @Pure
    public URI getTargetEObjectUri() {
        return this.targetEObjectUri;
    }

    public void setTargetEObjectUri(URI targetEObjectUri) {
        this.targetEObjectUri = targetEObjectUri;
    }

    @Override
    @Pure
    public URI getContainerEObjectURI() {
        return this.containerEObjectURI;
    }

    public void setContainerEObjectURI(URI containerEObjectURI) {
        this.containerEObjectURI = containerEObjectURI;
    }

    @Override
    @Pure
    public EReference getEReference() {
        return this.eReference;
    }

    public void setEReference(EReference eReference) {
        this.eReference = eReference;
    }

    @Override
    @Pure
    public int getIndexInList() {
        return this.indexInList;
    }

    public void setIndexInList(int indexInList) {
        this.indexInList = indexInList;
    }
}

