/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.scoping;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.common.types.xtext.AbstractTypeScope;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.scoping.IScope;

public class LocalResourceFilteringTypeScope
extends AbstractTypeScope {
    private AbstractTypeScope delegate;
    private IResourceDescription filterDescription;

    protected LocalResourceFilteringTypeScope(AbstractTypeScope delegate, IResourceDescription filterDescription) {
        super(null, null, null);
        this.delegate = delegate;
        this.filterDescription = filterDescription;
    }

    public IEObjectDescription getSingleElement(QualifiedName name) {
        if (this.isFiltered(name)) {
            return null;
        }
        return this.delegate.getSingleElement(name);
    }

    private boolean isFiltered(QualifiedName name) {
        Iterable exportedObjects = this.filterDescription.getExportedObjects(TypesPackage.Literals.JVM_TYPE, name, false);
        return !Iterables.isEmpty((Iterable)exportedObjects);
    }

    public IEObjectDescription getSingleElement(QualifiedName name, boolean binary) {
        if (this.isFiltered(name)) {
            return null;
        }
        return this.delegate.getSingleElement(name, binary);
    }

    public Iterable<IEObjectDescription> getElements(QualifiedName name) {
        return Iterables.filter((Iterable)this.delegate.getElements(name), (Predicate)new Predicate<IEObjectDescription>(){

            public boolean apply(IEObjectDescription input) {
                return !LocalResourceFilteringTypeScope.this.isFiltered(input.getQualifiedName());
            }
        });
    }

    public Iterable<IEObjectDescription> getElements(EObject object) {
        return Iterables.filter((Iterable)this.delegate.getElements(object), (Predicate)new Predicate<IEObjectDescription>(){

            public boolean apply(IEObjectDescription input) {
                return !LocalResourceFilteringTypeScope.this.isFiltered(input.getQualifiedName());
            }
        });
    }

    public IScope getParent() {
        return this.delegate.getParent();
    }

    public Iterable<IEObjectDescription> getAllElements() {
        return Iterables.filter((Iterable)this.delegate.getAllElements(), (Predicate)new Predicate<IEObjectDescription>(){

            public boolean apply(IEObjectDescription input) {
                return !LocalResourceFilteringTypeScope.this.isFiltered(input.getQualifiedName());
            }
        });
    }

    public IJvmTypeProvider getTypeProvider() {
        return this.delegate.getTypeProvider();
    }

    public IQualifiedNameConverter getQualifiedNameConverter() {
        return this.delegate.getQualifiedNameConverter();
    }

    public IEObjectDescription getSingleElement(EObject object) {
        return this.delegate.getSingleElement(object);
    }
}

