/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.parser;

import com.google.inject.Inject;
import java.io.IOException;
import java.io.StringReader;
import org.eclipse.xtend.core.parser.InternalFlexer;
import org.eclipse.xtend.core.parser.antlr.internal.FlexerFactory;
import org.eclipse.xtext.parser.impl.TokenRegionProvider;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;

public class FlexTokenRegionProvider
extends TokenRegionProvider {
    @Inject
    private FlexerFactory flexerFactory;

    public ITextRegion getTokenRegion(String text, ITextRegion region) {
        try {
            InternalFlexer flexer = this.flexerFactory.createFlexer(new StringReader(text));
            int token = flexer.advance();
            int prevStart = 0;
            int nextStart = flexer.getTokenLength();
            int regionStartOffset = region.getOffset();
            int regionEnd = regionStartOffset + region.getLength();
            while (token != -1 && nextStart <= regionStartOffset) {
                prevStart = nextStart;
                token = flexer.advance();
                nextStart += flexer.getTokenLength();
            }
            while (token != -1 && nextStart < regionEnd) {
                token = flexer.advance();
                nextStart += flexer.getTokenLength();
            }
            return new TextRegion(prevStart, nextStart - prevStart);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

