/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.lang.constant.Constable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.core.macro.ProcessorInstanceForJvmTypeProvider;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmComponentType;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmEnumerationLiteral;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.access.TypeResource;
import org.eclipse.xtext.common.types.access.impl.ClassFinder;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.util.IResourceScopeCache;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XListLiteral;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XNumberLiteral;
import org.eclipse.xtext.xbase.XStringLiteral;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.XUnaryOperation;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationElementValuePair;
import org.eclipse.xtext.xbase.imports.IImportsConfiguration;
import org.eclipse.xtext.xbase.interpreter.AbstractConstantExpressionsInterpreter;
import org.eclipse.xtext.xbase.interpreter.ConstantExpressionEvaluationException;
import org.eclipse.xtext.xbase.interpreter.Context;
import org.eclipse.xtext.xbase.interpreter.StackedConstantExpressionEvaluationException;
import org.eclipse.xtext.xbase.interpreter.UnresolvableFeatureException;
import org.eclipse.xtext.xbase.jvmmodel.ILogicalContainerProvider;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import org.eclipse.xtext.xbase.typesystem.computation.NumberLiterals;
import org.eclipse.xtext.xbase.typesystem.util.PendingLinkingCandidateResolver;
import org.eclipse.xtext.xbase.typesystem.util.TypeLiteralLinkingCandidateResolver;
import org.eclipse.xtext.xtype.XComputedTypeReference;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XImportSection;
import org.eclipse.xtext.xtype.impl.XComputedTypeReferenceImplCustom;

public class ConstantExpressionsInterpreter
extends AbstractConstantExpressionsInterpreter {
    @Inject
    private ILogicalContainerProvider containerProvider;
    @Inject
    private ProcessorInstanceForJvmTypeProvider classLoaderProvider;
    @Inject
    @Extension
    private NumberLiterals numberLiterals;
    @Inject
    private IScopeProvider scopeProvider;
    @Inject
    private IImportsConfiguration importSectionLocator;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private IResourceScopeCache cache;

    public Object evaluate(XExpression expression, JvmTypeReference expectedType) {
        ClassLoader classLoader = this.classLoaderProvider.getClassLoader((EObject)expression);
        Map<String, JvmIdentifiableElement> visibleFeatures = this.findVisibleFeatures(expression);
        JvmTypeReference _xifexpression = null;
        _xifexpression = expectedType instanceof XComputedTypeReference ? null : expectedType;
        ClassFinder _classFinder = new ClassFinder(classLoader);
        LinkedHashSet _newLinkedHashSet = CollectionLiterals.newLinkedHashSet();
        Context _context = new Context(_xifexpression, _classFinder, visibleFeatures, (Set)_newLinkedHashSet);
        Object result = this.evaluate(expression, _context);
        return result;
    }

    protected Map<String, JvmIdentifiableElement> findVisibleFeatures(XExpression expression) {
        JvmIdentifiableElement _nearestLogicalContainer;
        boolean _isLoadedFromStorage;
        Resource _eResource;
        HashMap _xblockexpression = null;
        Resource res = _eResource = expression.eResource();
        boolean _matched = false;
        if (res instanceof StorageAwareResource && (_isLoadedFromStorage = ((StorageAwareResource)res).isLoadedFromStorage())) {
            _matched = true;
            return CollectionLiterals.newHashMap();
        }
        JvmGenericType _switchResult_1 = null;
        JvmIdentifiableElement cont = _nearestLogicalContainer = this.containerProvider.getNearestLogicalContainer((EObject)expression);
        boolean _matched_1 = false;
        if (cont instanceof JvmGenericType) {
            _matched_1 = true;
            _switchResult_1 = (JvmGenericType)cont;
        }
        if (!_matched_1 && cont instanceof JvmMember) {
            _matched_1 = true;
            _switchResult_1 = ((JvmMember)cont).getDeclaringType();
        }
        JvmGenericType container = _switchResult_1;
        Pair _mappedTo = Pair.of((Object)"visibleFeaturesForAnnotationValues", (Object)container);
        Provider _function = () -> this.lambda$0(expression, (JvmDeclaredType)container);
        _xblockexpression = (HashMap)this.cache.get((Object)_mappedTo, expression.eResource(), _function);
        return _xblockexpression;
    }

    protected void collectAllVisibleFields(JvmDeclaredType type, Map<String, JvmIdentifiableElement> result) {
        if (type == null) {
            return;
        }
        this.collectAllVisibleFields(type.getDeclaringType(), result);
        result.putAll(this.getAllVisibleFields(type));
    }

    protected HashMap<String, JvmIdentifiableElement> getAllVisibleFields(JvmDeclaredType type) {
        HashMap result = CollectionLiterals.newHashMap();
        new VisibleFieldsCollector().collect(type, result);
        return result;
    }

    protected JvmType findTypeByName(EObject context, String qualifiedName) {
        IScope scope = this.scopeProvider.getScope(context, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE);
        QualifiedName qn = this.qualifiedNameConverter.toQualifiedName(qualifiedName);
        IEObjectDescription _singleElement = scope.getSingleElement(qn);
        EObject _eObjectOrProxy = null;
        if (_singleElement != null) {
            _eObjectOrProxy = _singleElement.getEObjectOrProxy();
        }
        return (JvmType)_eObjectOrProxy;
    }

    protected Object _internalEvaluate(XNumberLiteral it, Context ctx) {
        try {
            Class<?> _javaType;
            Number _xblockexpression = null;
            Class<?> _xifexpression = null;
            JvmTypeReference _expectedType = ctx.getExpectedType();
            boolean _tripleEquals = _expectedType == null;
            _xifexpression = _tripleEquals ? this.numberLiterals.getJavaType(it) : (_javaType = this.getJavaType(ctx.getExpectedType().getType(), ctx.getClassFinder()));
            Class<?> type = _xifexpression;
            _xblockexpression = this.numberLiterals.numberValue(it, type);
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected Object _internalEvaluate(XListLiteral it, Context ctx) {
        try {
            JvmTypeReference _expectedType;
            JvmTypeReference _switchResult = null;
            JvmTypeReference exp = _expectedType = ctx.getExpectedType();
            boolean _matched = false;
            if (exp instanceof JvmGenericArrayTypeReference) {
                _matched = true;
                _switchResult = ((JvmGenericArrayTypeReference)exp).getComponentType();
            }
            JvmTypeReference expectedComponentType = _switchResult;
            Functions.Function1 _function = it_1 -> this.evaluate((XExpression)it_1, ctx.cloneWithExpectation(expectedComponentType));
            List elements = ListExtensions.map((List)it.getElements(), (Functions.Function1)_function);
            Class<Object> _xifexpression = null;
            if (expectedComponentType != null) {
                _xifexpression = this.getJavaType(expectedComponentType.getType(), ctx.getClassFinder());
            } else {
                boolean _not;
                Class<Object> _xifexpression_1 = null;
                boolean _isEmpty = elements.isEmpty();
                boolean bl = _not = !_isEmpty;
                if (_not) {
                    Class<?> _class;
                    Class<Constable> _switchResult_1 = null;
                    Class<?> cl = _class = IterableExtensions.head((Iterable)elements).getClass();
                    boolean _matched_1 = false;
                    if (Objects.equals(cl, Integer.class)) {
                        _matched_1 = true;
                        _switchResult_1 = Integer.TYPE;
                    }
                    if (!_matched_1 && Objects.equals(cl, Long.class)) {
                        _matched_1 = true;
                        _switchResult_1 = Long.TYPE;
                    }
                    if (!_matched_1 && Objects.equals(cl, Short.class)) {
                        _matched_1 = true;
                        _switchResult_1 = Short.TYPE;
                    }
                    if (!_matched_1 && Objects.equals(cl, Boolean.class)) {
                        _matched_1 = true;
                        _switchResult_1 = Boolean.TYPE;
                    }
                    if (!_matched_1 && Objects.equals(cl, Double.class)) {
                        _matched_1 = true;
                        _switchResult_1 = Double.TYPE;
                    }
                    if (!_matched_1 && Objects.equals(cl, Byte.class)) {
                        _matched_1 = true;
                        _switchResult_1 = Byte.TYPE;
                    }
                    if (!_matched_1 && Objects.equals(cl, Float.class)) {
                        _matched_1 = true;
                        _switchResult_1 = Float.TYPE;
                    }
                    if (!_matched_1) {
                        _switchResult_1 = cl;
                    }
                    _xifexpression_1 = _switchResult_1;
                } else {
                    _xifexpression_1 = Object.class;
                }
                _xifexpression = _xifexpression_1;
            }
            Class<?> componentType = _xifexpression;
            return Conversions.unwrapArray((Object)elements, componentType);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected boolean isResolveProxies(EObject ctx) {
        Resource _eResource;
        boolean _switchResult = false;
        Resource res = _eResource = ctx.eResource();
        boolean _matched = false;
        if (res instanceof StorageAwareResource) {
            _matched = true;
            _switchResult = ((StorageAwareResource)res).isLoadedFromStorage();
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    protected Object _internalEvaluate(XFeatureCall it, Context ctx) {
        boolean _isEquivalentComputed;
        JvmTypeReference _expectedType;
        boolean _not;
        Object _eGet = it.eGet((EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, this.isResolveProxies((EObject)it));
        EObject feature = (EObject)_eGet;
        boolean _eIsProxy = feature.eIsProxy();
        boolean bl = _not = !_eIsProxy;
        if (_not) {
            Object _switchResult = null;
            boolean _matched = false;
            if (feature instanceof JvmEnumerationLiteral) {
                _matched = true;
                _switchResult = feature;
            }
            if (!_matched && feature instanceof JvmField) {
                _matched = true;
                _switchResult = this.evaluateField((XAbstractFeatureCall)it, (JvmField)feature, ctx);
            }
            if (!_matched && feature instanceof JvmType) {
                _matched = true;
                _switchResult = this.toTypeReference((JvmType)feature, 0);
            }
            return _switchResult;
        }
        String featureName = it.getConcreteSyntaxFeatureName();
        JvmType _switchResult_1 = null;
        JvmTypeReference it_1 = _expectedType = ctx.getExpectedType();
        boolean _matched_1 = false;
        if (it_1 instanceof XComputedTypeReferenceImplCustom && (_isEquivalentComputed = ((XComputedTypeReferenceImplCustom)it_1).isEquivalentComputed())) {
            _matched_1 = true;
            _switchResult_1 = ((XComputedTypeReferenceImplCustom)it_1).getType();
        }
        if (!_matched_1) {
            if (it_1 instanceof XComputedTypeReference) {
                _matched_1 = true;
            }
            if (!_matched_1 && it_1 == null) {
                _matched_1 = true;
            }
            if (_matched_1) {
                _switchResult_1 = null;
            }
        }
        if (!_matched_1) {
            _switchResult_1 = it_1.getType();
        }
        JvmType expectedRawType = _switchResult_1;
        HashMap _xifexpression = null;
        boolean _isEnumExpectationInAnnotationValue = this.isEnumExpectationInAnnotationValue(it, expectedRawType);
        if (_isEnumExpectationInAnnotationValue) {
            HashMap _xblockexpression = null;
            JvmEnumerationType _switchResult_2 = null;
            boolean _matched_2 = false;
            if (expectedRawType instanceof JvmEnumerationType) {
                _matched_2 = true;
                _switchResult_2 = (JvmEnumerationType)expectedRawType;
            }
            if (!_matched_2 && expectedRawType instanceof JvmArrayType) {
                _matched_2 = true;
                JvmComponentType _componentType = ((JvmArrayType)expectedRawType).getComponentType();
                _switchResult_2 = (JvmEnumerationType)_componentType;
            }
            JvmEnumerationType enumType = _switchResult_2;
            Map _visibleFeatures = ctx.getVisibleFeatures();
            HashMap copy = new HashMap(_visibleFeatures);
            Consumer<JvmEnumerationLiteral> _function = it_2 -> copy.put(it_2.getSimpleName(), it_2);
            enumType.getLiterals().forEach(_function);
            _xifexpression = _xblockexpression = copy;
        } else {
            _xifexpression = ctx.getVisibleFeatures();
        }
        HashMap visibleFeatures = _xifexpression;
        boolean _containsKey = visibleFeatures.containsKey(featureName);
        if (_containsKey) {
            Object _xblockexpression_1;
            JvmIdentifiableElement _get;
            JvmEnumerationLiteral _switchResult_2 = null;
            JvmIdentifiableElement visibleFeature = _get = (JvmIdentifiableElement)visibleFeatures.get(featureName);
            boolean _matched_2 = false;
            if (visibleFeature instanceof JvmEnumerationLiteral) {
                _matched_2 = true;
                _xblockexpression_1 = null;
                this.resolveFeature((XAbstractFeatureCall)it, visibleFeature);
                _switchResult_2 = _xblockexpression_1 = (JvmEnumerationLiteral)visibleFeature;
            }
            if (!_matched_2 && visibleFeature instanceof JvmField) {
                _matched_2 = true;
                _xblockexpression_1 = null;
                this.resolveFeature((XAbstractFeatureCall)it, visibleFeature);
                _switchResult_2 = _xblockexpression_1 = this.evaluateField((XAbstractFeatureCall)it, (JvmField)visibleFeature, ctx);
            }
            return _switchResult_2;
        }
        JvmType type = this.findTypeByName((EObject)it, featureName);
        if (type != null) {
            this.resolveType((XAbstractFeatureCall)it, (JvmIdentifiableElement)type);
            return this.toTypeReference(type, 0);
        }
        throw new UnresolvableFeatureException("Couldn't resolve feature " + featureName, (XExpression)it);
    }

    private boolean isEnumExpectationInAnnotationValue(XFeatureCall it, JvmType expectedRawType) {
        if (expectedRawType instanceof JvmEnumerationType || expectedRawType instanceof JvmArrayType && ((JvmArrayType)expectedRawType).getComponentType() instanceof JvmEnumerationType) {
            EObject container = it.eContainer();
            if (container instanceof XAnnotationElementValuePair) {
                return true;
            }
            if (container instanceof XAnnotation) {
                return true;
            }
            if (container instanceof XListLiteral) {
                if ((container = ((XListLiteral)container).eContainer()) instanceof XAnnotationElementValuePair) {
                    return true;
                }
                if (container instanceof XAnnotation) {
                    return true;
                }
            }
        }
        return false;
    }

    protected Object _internalEvaluate(XMemberFeatureCall it, Context ctx) {
        boolean _not;
        Object _eGet = it.eGet((EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, this.isResolveProxies((EObject)it));
        EObject feature = (EObject)_eGet;
        boolean _eIsProxy = feature.eIsProxy();
        boolean bl = _not = !_eIsProxy;
        if (_not) {
            Object _switchResult = null;
            boolean _matched = false;
            if (feature instanceof JvmEnumerationLiteral) {
                _matched = true;
                _switchResult = feature;
            }
            if (!_matched && feature instanceof JvmField) {
                _matched = true;
                _switchResult = this.evaluateField((XAbstractFeatureCall)it, (JvmField)feature, ctx);
            }
            if (!_matched && feature instanceof JvmType) {
                _matched = true;
                _switchResult = this.toTypeReference((JvmType)feature, 0);
            }
            return _switchResult;
        }
        String featureName = it.getConcreteSyntaxFeatureName();
        try {
            Object receiver = this.evaluate(it.getMemberCallTarget(), ctx);
            boolean _matched_1 = false;
            if (receiver instanceof JvmTypeReference) {
                JvmType _type;
                _matched_1 = true;
                JvmType type = _type = ((JvmTypeReference)receiver).getType();
                boolean _matched_2 = false;
                if (type instanceof JvmEnumerationType) {
                    _matched_2 = true;
                    Functions.Function1 _function = it_1 -> {
                        String _simpleName = it_1.getSimpleName();
                        return Objects.equals(_simpleName, featureName);
                    };
                    JvmEnumerationLiteral enumValue = (JvmEnumerationLiteral)IterableExtensions.findFirst((Iterable)((JvmEnumerationType)type).getLiterals(), (Functions.Function1)_function);
                    if (enumValue == null) {
                        String _simpleName = ((JvmTypeReference)receiver).getSimpleName();
                        String _plus = "Couldn't find enum value " + featureName + " on enum " + _simpleName;
                        throw new ConstantExpressionEvaluationException(_plus, (XExpression)it);
                    }
                    this.resolveFeature((XAbstractFeatureCall)it, (JvmIdentifiableElement)enumValue);
                    return enumValue;
                }
                if (!_matched_2 && type instanceof JvmGenericType) {
                    _matched_2 = true;
                    Functions.Function1 _function = it_1 -> {
                        String _simpleName = it_1.getSimpleName();
                        return Objects.equals(_simpleName, featureName);
                    };
                    JvmField field = (JvmField)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)((JvmGenericType)type).getAllFeatures(), JvmField.class), (Functions.Function1)_function);
                    if (field == null) {
                        String _simpleName = ((JvmTypeReference)receiver).getSimpleName();
                        String _plus = "Couldn't find field " + featureName + " on type " + _simpleName;
                        throw new ConstantExpressionEvaluationException(_plus, (XExpression)it);
                    }
                    this.resolveFeature((XAbstractFeatureCall)it, (JvmIdentifiableElement)field);
                    return this.evaluateField((XAbstractFeatureCall)it, field, ctx);
                }
            }
            throw new UnresolvableFeatureException("Unresolvable feature " + featureName + " on " + String.valueOf(receiver), (XExpression)it);
        }
        catch (Throwable _t) {
            if (_t instanceof UnresolvableFeatureException) {
                String typeName = this.getFullName((XExpression)it);
                JvmType type = this.findTypeByName((EObject)it, typeName);
                if (type != null) {
                    this.resolveType((XAbstractFeatureCall)it, (JvmIdentifiableElement)type);
                    return this.toTypeReference(type, 0);
                }
                throw new UnresolvableFeatureException("Unresolvable type " + typeName, (XExpression)it);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    protected String _getFullName(XExpression call) {
        String _text = this.toText(call);
        String _plus = "The expression '" + _text;
        String _plus_1 = _plus + "' cannot be used as a receiver within a constant expression.";
        throw new ConstantExpressionEvaluationException(_plus_1);
    }

    protected String _getFullName(XMemberFeatureCall call) {
        String prefix = this.getFullName(call.getMemberCallTarget());
        String _concreteSyntaxFeatureName = call.getConcreteSyntaxFeatureName();
        return prefix + "." + _concreteSyntaxFeatureName;
    }

    protected String _getFullName(XFeatureCall call) {
        return call.getConcreteSyntaxFeatureName();
    }

    protected Object evaluateField(XAbstractFeatureCall call, JvmField field, Context context) {
        if (field.isSetConstant() || field.eResource() instanceof TypeResource) {
            boolean _isConstant = field.isConstant();
            if (_isConstant) {
                return field.getConstantValue();
            }
            String _simpleName = field.getDeclaringType().getSimpleName();
            String _plus = "Field " + _simpleName;
            String _plus_1 = _plus + ".";
            String _simpleName_1 = field.getSimpleName();
            String _plus_2 = _plus_1 + _simpleName_1;
            String _plus_3 = _plus_2 + " is not a constant";
            throw new ConstantExpressionEvaluationException(_plus_3);
        }
        XExpression expression = this.containerProvider.getAssociatedExpression((JvmIdentifiableElement)field);
        boolean _contains = context.getAlreadyEvaluating().contains(expression);
        if (_contains) {
            throw new ConstantExpressionEvaluationException("Endless recursive evaluation detected.");
        }
        try {
            Map<String, JvmIdentifiableElement> visibleFeatures = this.findVisibleFeatures(expression);
            JvmTypeReference _type = field.getType();
            ClassFinder _classFinder = context.getClassFinder();
            Set _alreadyEvaluating = context.getAlreadyEvaluating();
            Context ctx = new Context(_type, _classFinder, visibleFeatures, _alreadyEvaluating);
            return this.evaluate(expression, ctx);
        }
        catch (Throwable _t) {
            if (_t instanceof ConstantExpressionEvaluationException) {
                ConstantExpressionEvaluationException e = (ConstantExpressionEvaluationException)_t;
                throw new StackedConstantExpressionEvaluationException((XExpression)call, field, e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    protected Class<?> getJavaType(JvmType type, ClassFinder classFinder) throws ClassNotFoundException {
        if (type instanceof JvmArrayType) {
            JvmType t = type;
            Object dimensions = "";
            while (t instanceof JvmArrayType) {
                dimensions = (String)dimensions + "[]";
                t = ((JvmArrayType)t).getComponentType();
            }
            Class<?> componentClass = this.getJavaType(t, classFinder);
            String _name = componentClass.getName();
            String _plus = _name + (String)dimensions;
            return (Class)classFinder.forName(_plus);
        }
        String _identifier = type.getIdentifier();
        boolean _equals = Objects.equals(_identifier, "java.lang.Class");
        if (_equals) {
            return JvmTypeReference.class;
        }
        if (type instanceof JvmEnumerationType) {
            return JvmEnumerationLiteral.class;
        }
        if (type instanceof JvmAnnotationType) {
            return XAnnotation.class;
        }
        return (Class)classFinder.forName(type.getIdentifier());
    }

    protected void resolveType(XAbstractFeatureCall featureCall, JvmIdentifiableElement feature) {
        new TypeLiteralLinkingCandidateResolver(featureCall).resolveLinkingProxy((InternalEObject)featureCall, feature, XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, 0);
    }

    protected void resolveFeature(XAbstractFeatureCall featureCall, JvmIdentifiableElement feature) {
        new PendingLinkingCandidateResolver((XExpression)featureCall).resolveLinkingProxy((InternalEObject)featureCall, feature, XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, 0);
    }

    @XbaseGenerated
    public Object internalEvaluate(XExpression it, Context ctx) {
        if (it instanceof XBinaryOperation) {
            return this._internalEvaluate((XBinaryOperation)it, ctx);
        }
        if (it instanceof XFeatureCall) {
            return this._internalEvaluate((XFeatureCall)it, ctx);
        }
        if (it instanceof XListLiteral) {
            return this._internalEvaluate((XListLiteral)it, ctx);
        }
        if (it instanceof XMemberFeatureCall) {
            return this._internalEvaluate((XMemberFeatureCall)it, ctx);
        }
        if (it instanceof XUnaryOperation) {
            return this._internalEvaluate((XUnaryOperation)it, ctx);
        }
        if (it instanceof XBooleanLiteral) {
            return this._internalEvaluate((XBooleanLiteral)it, ctx);
        }
        if (it instanceof XCastedExpression) {
            return this._internalEvaluate((XCastedExpression)it, ctx);
        }
        if (it instanceof XNumberLiteral) {
            return this._internalEvaluate((XNumberLiteral)it, ctx);
        }
        if (it instanceof XStringLiteral) {
            return this._internalEvaluate((XStringLiteral)it, ctx);
        }
        if (it instanceof XTypeLiteral) {
            return this._internalEvaluate((XTypeLiteral)it, ctx);
        }
        if (it instanceof XAnnotation) {
            return this._internalEvaluate((XAnnotation)it, ctx);
        }
        if (it != null) {
            return this._internalEvaluate(it, ctx);
        }
        if (it == null) {
            return this._internalEvaluate(null, ctx);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, ctx).toString());
    }

    @XbaseGenerated
    public String getFullName(XExpression call) {
        if (call instanceof XFeatureCall) {
            return this._getFullName((XFeatureCall)call);
        }
        if (call instanceof XMemberFeatureCall) {
            return this._getFullName((XMemberFeatureCall)call);
        }
        if (call != null) {
            return this._getFullName(call);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(call).toString());
    }

    private /* synthetic */ HashMap lambda$0(XExpression xExpression, JvmDeclaredType jvmDeclaredType) {
        HashMap result = CollectionLiterals.newHashMap();
        Resource _eResource_1 = xExpression.eResource();
        XImportSection section = this.importSectionLocator.getImportSection((XtextResource)_eResource_1);
        if (section != null) {
            EList _importDeclarations = section.getImportDeclarations();
            for (XImportDeclaration imp : _importDeclarations) {
                String importedTypeName;
                boolean _isStatic = imp.isStatic();
                if (!_isStatic || (importedTypeName = imp.getImportedTypeName()) == null) continue;
                JvmType type = this.findTypeByName((EObject)imp, importedTypeName);
                boolean _matched_2 = false;
                if (type instanceof JvmGenericType) {
                    _matched_2 = true;
                    this.collectAllVisibleFields((JvmDeclaredType)type, result);
                }
                if (_matched_2 || !(type instanceof JvmEnumerationType)) continue;
                _matched_2 = true;
                EList _literals = ((JvmEnumerationType)type).getLiterals();
                for (JvmEnumerationLiteral feature : _literals) {
                    result.put(feature.getSimpleName(), feature);
                }
            }
        }
        this.collectAllVisibleFields(jvmDeclaredType, result);
        return result;
    }

    public static class VisibleFieldsCollector {
        public void collect(JvmDeclaredType type, Map<String, JvmIdentifiableElement> result) {
            this.collect(type, CollectionLiterals.newHashSet(), result);
        }

        private void collect(JvmDeclaredType type, Set<JvmType> seen, Map<String, JvmIdentifiableElement> result) {
            boolean _add = seen.add((JvmType)type);
            if (_add) {
                EList _members = type.getMembers();
                for (JvmMember member : _members) {
                    JvmIdentifiableElement existing;
                    if (!(member instanceof JvmField) || !((JvmField)member).isFinal() || !((JvmField)member).isStatic() || (existing = result.put(((JvmField)member).getSimpleName(), (JvmIdentifiableElement)member)) == null) continue;
                    result.put(existing.getSimpleName(), existing);
                }
                EList _superTypes = type.getSuperTypes();
                for (JvmTypeReference superType : _superTypes) {
                    JvmType rawSuperType;
                    JvmType _type = null;
                    if (superType != null) {
                        _type = superType.getType();
                    }
                    if (!((rawSuperType = _type) instanceof JvmDeclaredType) || rawSuperType.eIsProxy()) continue;
                    this.collect((JvmDeclaredType)rawSuperType, seen, result);
                }
            }
        }
    }
}

