/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.templates;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.ui.codetemplates.templates.TemplatesPackage;
import org.eclipse.xtext.ui.codetemplates.templates.Variable;
import org.eclipse.xtext.ui.codetemplates.ui.resolvers.IInspectableTemplateVariableResolver;
import org.eclipse.xtext.ui.editor.templates.AbstractTemplateVariableResolver;
import org.eclipse.xtext.ui.editor.templates.XtextTemplateContext;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;
import org.eclipse.xtext.xbase.conversion.XbaseValueConverterService;
import org.eclipse.xtext.xbase.ui.templates.Messages;
import org.eclipse.xtext.xbase.ui.templates.XbaseTemplateContext;

public class ImportsVariableResolver
extends AbstractTemplateVariableResolver
implements IInspectableTemplateVariableResolver {
    @Inject
    private IValueConverterService valueConverterService;

    public ImportsVariableResolver() {
        super(Messages.ImportsVariableResolver_0, Messages.ImportsVariableResolver_1);
    }

    public List<String> resolveValues(TemplateVariable variable, XtextTemplateContext xtextTemplateContext) {
        variable.setUnambiguous(true);
        variable.setValue("");
        if (xtextTemplateContext instanceof XbaseTemplateContext) {
            XbaseTemplateContext xbaseCtx = (XbaseTemplateContext)xtextTemplateContext;
            List params = variable.getVariableType().getParams();
            if (params.size() > 0) {
                for (String typeName : params) {
                    xbaseCtx.addImport(typeName);
                }
            }
        }
        return new ArrayList<String>();
    }

    protected boolean isUnambiguous(TemplateContext context) {
        return true;
    }

    protected String[] resolveAll(TemplateContext context) {
        return new String[0];
    }

    public boolean hasMandatoryParameters() {
        return true;
    }

    public boolean canHaveParameters() {
        return true;
    }

    public void validateParameters(Variable variable, ValidationMessageAcceptor validationMessageAcceptor) {
        if (variable.getParameters().isEmpty()) {
            validationMessageAcceptor.acceptError(String.valueOf(this.getType()) + "-variables have mandatory parameters.", (EObject)variable, (EStructuralFeature)TemplatesPackage.Literals.VARIABLE__TYPE, -1, null, new String[0]);
        } else {
            EList parameters = variable.getParameters();
            int i = 0;
            while (i < parameters.size()) {
                String param = (String)parameters.get(i);
                try {
                    IValueConverter converter = ((XbaseValueConverterService)this.valueConverterService).getQualifiedNameWithWildCardValueConverter();
                    converter.toString((Object)param);
                }
                catch (ValueConverterException e) {
                    validationMessageAcceptor.acceptError(String.valueOf(this.getType()) + " - parameter " + param + " is not a valid qualifier.", (EObject)variable, (EStructuralFeature)TemplatesPackage.Literals.VARIABLE__PARAMETERS, i, null, new String[0]);
                }
                ++i;
            }
        }
    }
}

