/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.shared.internal;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.ui.IEditorPart;
import org.eclipse.xtext.ui.generator.trace.FileOpener;
import org.eclipse.xtext.ui.generator.trace.OppositeFileOpenerContributor;
import org.eclipse.xtext.ui.shared.contribution.ISharedStateContributionRegistry;
import org.eclipse.xtext.util.IAcceptor;

public class OpenSourceFilePropertyTester
extends PropertyTester {
    private List<? extends OppositeFileOpenerContributor> oppositeFileOpenerContributors;

    protected boolean canOpenSourceFile(IEditorPart editorPart) {
        ExceptionThrowingOpenerAcceptor acceptor = new ExceptionThrowingOpenerAcceptor();
        try {
            for (OppositeFileOpenerContributor oppositeFileOpenerContributor : this.oppositeFileOpenerContributors) {
                oppositeFileOpenerContributor.collectSourceFileOpeners(editorPart, (IAcceptor)acceptor);
            }
            return false;
        }
        catch (SourceFileFound sourceFileFound) {
            return true;
        }
    }

    @Inject
    protected void initialize(ISharedStateContributionRegistry registry) {
        this.oppositeFileOpenerContributors = registry.getContributedInstances(OppositeFileOpenerContributor.class);
    }

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof IEditorPart && "canOpenSourceFile".equals(property)) {
            return this.canOpenSourceFile((IEditorPart)receiver);
        }
        return false;
    }

    private static class ExceptionThrowingOpenerAcceptor
    implements IAcceptor<FileOpener> {
        private ExceptionThrowingOpenerAcceptor() {
        }

        public void accept(FileOpener t) {
            throw new SourceFileFound();
        }
    }

    private static class SourceFileFound
    extends RuntimeException {
        private SourceFileFound() {
        }
    }
}

