/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.jvmmodel.refactoring;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.resource.DerivedStateAwareResource;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.ui.refactoring.XbaseRenameStrategy;

public class DefaultJvmModelRenameStrategy
extends XbaseRenameStrategy {
    @Inject
    private IJvmModelAssociations jvmModelAssociations;

    public void applyDeclarationChange(String newName, ResourceSet resourceSet) {
        super.applyDeclarationChange(newName, resourceSet);
        this.setInferredJvmElementName(newName, resourceSet);
    }

    public void revertDeclarationChange(ResourceSet resourceSet) {
        super.revertDeclarationChange(resourceSet);
        this.setInferredJvmElementName(this.getOriginalName(), resourceSet);
    }

    protected void setInferredJvmElementName(String newName, ResourceSet resourceSet) {
        EObject renamedElement = resourceSet.getEObject(this.getTargetElementNewURI(), false);
        this.setInferredJvmElementName(newName, renamedElement);
    }

    protected void setInferredJvmElementName(String name, EObject renamedElement) {
        if (renamedElement.eResource() instanceof DerivedStateAwareResource) {
            DerivedStateAwareResource resource = (DerivedStateAwareResource)renamedElement.eResource();
            resource.discardDerivedState();
            resource.installDerivedState(false);
        }
    }

    protected IJvmModelAssociations getJvmModelAssociations() {
        return this.jvmModelAssociations;
    }
}

