/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.editor.model;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.eclipse.xtend.core.parser.antlr.internal.FlexTokenSource;
import org.eclipse.xtend.core.parser.antlr.internal.FlexerFactory;
import org.eclipse.xtext.parser.antlr.ITokenDefProvider;
import org.eclipse.xtext.ui.editor.model.DocumentTokenSource;

public class XtendDocumentTokenSource
extends DocumentTokenSource {
    public static final int JAVA_DOC_TOKEN_TYPE = -10000;
    protected int multilineTokenType = -1;
    @Inject
    private FlexerFactory flexerFactory;

    @Inject
    public void setTokenDefProvider(@Named(value="org.eclipse.xtext.ui.editor.contentassist.antlr.internal.Lexer.HIGHLIGHTING") ITokenDefProvider tokenDefProvider) {
        Map tokenDefMap = tokenDefProvider.getTokenDefMap();
        Set entrySet = tokenDefMap.entrySet();
        for (Map.Entry entry : entrySet) {
            if (!((String)entry.getValue()).equals("RULE_ML_COMMENT")) continue;
            this.multilineTokenType = (Integer)entry.getKey();
            return;
        }
        throw new RuntimeException("No Token for RULE ML_COMMENT found in tokenTypeDefs!");
    }

    protected TokenSource createTokenSource(String string) {
        final FlexTokenSource delegate = this.flexerFactory.createTokenSource((Reader)new StringReader(string));
        return new TokenSource(){

            public Token nextToken() {
                String text;
                Token token = delegate.nextToken();
                if (token.getType() == XtendDocumentTokenSource.this.multilineTokenType && (text = token.getText()).startsWith("/**") && !text.startsWith("/***")) {
                    token.setType(-10000);
                }
                return token;
            }

            public String getSourceName() {
                return delegate.getSourceName();
            }
        };
    }

    public void setFlexerFactory(FlexerFactory flexerFactory) {
        this.flexerFactory = flexerFactory;
    }
}

