/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.parser.antlr.ex;

import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.generator.BindFactory;
import org.eclipse.xtext.generator.Binding;
import org.eclipse.xtext.generator.DefaultGeneratorFragment;
import org.eclipse.xtext.generator.Naming;
import org.eclipse.xtext.generator.NamingAware;
import org.eclipse.xtext.generator.NewlineNormalizer;
import org.eclipse.xtext.generator.parser.antlr.AntlrToolFacade;
import org.eclipse.xtext.generator.parser.antlr.postProcessing.SuppressWarningsProcessor;
import org.eclipse.xtext.parser.antlr.Lexer;
import org.eclipse.xtext.util.Strings;

public class ExternalAntlrLexerFragment
extends DefaultGeneratorFragment
implements NamingAware {
    private String lexerGrammar;
    private boolean highlighting;
    private boolean runtime;
    private boolean contentAssist;
    private List<String> antlrParams = Lists.newArrayList();
    private Naming naming;
    private AntlrToolFacade antlrTool = new AntlrToolFacade();

    @Override
    public void registerNaming(Naming naming) {
        this.naming = naming;
    }

    private String getLineDelimiter() {
        return this.naming.getLineDelimiter();
    }

    public void addAntlrParam(String param) {
        this.antlrParams.add(param);
    }

    public String[] getAntlrParams() {
        ArrayList<String> params = new ArrayList<String>(this.antlrParams);
        if (!params.contains("-Xconversiontimeout")) {
            params.add("-Xconversiontimeout");
            params.add("100000");
        }
        String[] result = params.toArray(new String[params.size()]);
        return result;
    }

    public void setAntlrTool(AntlrToolFacade facade) {
        this.antlrTool = facade;
    }

    public AntlrToolFacade getAntlrTool() {
        return this.antlrTool;
    }

    @Override
    public void generate(Grammar grammar, XpandExecutionContext ctx) {
        super.generate(grammar, ctx);
        String srcGen = "SRC_GEN";
        String src = "SRC";
        if (this.contentAssist || this.highlighting) {
            srcGen = "SRC_GEN_IDE";
            src = "SRC_IDE";
        }
        String srcGenPath = ctx.getOutput().getOutlet(srcGen).getPath();
        String srcPath = ctx.getOutput().getOutlet(src).getPath();
        String grammarFile = String.valueOf(srcPath) + "/" + this.getLexerGrammar().replace('.', '/') + ".g";
        String generateTo = "";
        if (this.lexerGrammar.lastIndexOf(46) != -1) {
            generateTo = this.lexerGrammar.substring(0, this.lexerGrammar.lastIndexOf(46));
        }
        generateTo = String.valueOf(srcGenPath) + "/" + generateTo.replace('.', '/');
        this.addAntlrParam("-fo");
        this.addAntlrParam(generateTo);
        String encoding = this.getEncoding(ctx, srcGen);
        this.getAntlrTool().runWithEncodingAndParams(grammarFile, encoding, this.getAntlrParams());
        String javaFile = String.valueOf(srcGenPath) + "/" + this.getLexerGrammar().replace('.', '/') + ".java";
        this.suppressWarningsImpl(javaFile, Charset.forName(encoding));
        this.normalizeTokens(javaFile, Charset.forName(encoding));
    }

    private void normalizeTokens(String grammarFileName, Charset encoding) {
        String tokenFile = this.toTokenFileName(grammarFileName);
        String content = this.readFileIntoString(tokenFile, encoding);
        content = new NewlineNormalizer(this.getLineDelimiter()).normalizeLineDelimiters(content);
        List splitted = Strings.split((String)content, (String)this.getLineDelimiter());
        Collections.sort(splitted);
        content = String.valueOf(Strings.concat((String)this.getLineDelimiter(), (List)splitted)) + this.getLineDelimiter();
        this.writeStringIntoFile(tokenFile, content, encoding);
    }

    private String toTokenFileName(String grammarFileName) {
        return grammarFileName.replaceAll("\\.java$", ".tokens");
    }

    private String getEncoding(XpandExecutionContext xpt, String outlet) {
        return xpt.getOutput().getOutlet(outlet).getFileEncoding();
    }

    @Deprecated
    protected void suppressWarningsImpl(String javaFile) {
        this.suppressWarningsImpl(javaFile, Charset.defaultCharset());
    }

    protected void suppressWarningsImpl(String javaFile, Charset encoding) {
        String content = this.readFileIntoString(javaFile, encoding);
        content = new SuppressWarningsProcessor().process(content);
        this.writeStringIntoFile(javaFile, content, encoding);
    }

    @Override
    public void checkConfiguration(Issues issues) {
        if (this.contentAssist && this.highlighting || this.runtime && this.highlighting || this.contentAssist && this.runtime) {
            issues.addError("Only one of those flags is allowed: contentAssist, runtime, highlighting flag");
        }
    }

    @Override
    public Set<Binding> getGuiceBindingsRt(Grammar grammar) {
        if (this.runtime) {
            return new BindFactory().addConfiguredBinding("RuntimeLexer", "binder.bind(" + Lexer.class.getName() + ".class)" + ".annotatedWith(com.google.inject.name.Names.named(" + "org.eclipse.xtext.parser.antlr.LexerBindings.RUNTIME" + ")).to(" + this.lexerGrammar + ".class)").getBindings();
        }
        return Collections.emptySet();
    }

    @Override
    public Set<Binding> getGuiceBindingsUi(Grammar grammar) {
        if (this.highlighting) {
            if (this.naming.hasIde()) {
                return new BindFactory().addConfiguredBinding("HighlightingLexer", "binder.bind(" + Lexer.class.getName() + ".class)" + ".annotatedWith(com.google.inject.name.Names.named(" + "org.eclipse.xtext.ide.LexerIdeBindings.HIGHLIGHTING" + ")).to(" + this.lexerGrammar + ".class)").getBindings();
            }
            return new BindFactory().addConfiguredBinding("HighlightingLexer", "binder.bind(" + Lexer.class.getName() + ".class)" + ".annotatedWith(com.google.inject.name.Names.named(" + "org.eclipse.xtext.ui.LexerUIBindings.HIGHLIGHTING" + ")).to(" + this.lexerGrammar + ".class)").getBindings();
        }
        if (this.contentAssist) {
            if (this.naming.hasIde()) {
                return new BindFactory().addConfiguredBinding("ContentAssistLexer", "binder.bind(org.eclipse.xtext.ide.editor.contentassist.antlr.internal.Lexer.class).annotatedWith(com.google.inject.name.Names.named(org.eclipse.xtext.ide.LexerIdeBindings.CONTENT_ASSIST)).to(" + this.lexerGrammar + ".class)").getBindings();
            }
            return new BindFactory().addConfiguredBinding("ContentAssistLexer", "binder.bind(org.eclipse.xtext.ui.editor.contentassist.antlr.internal.Lexer.class).annotatedWith(com.google.inject.name.Names.named(org.eclipse.xtext.ui.LexerUIBindings.CONTENT_ASSIST)).to(" + this.lexerGrammar + ".class)").getBindings();
        }
        return Collections.emptySet();
    }

    public void setLexerGrammar(String lexerGrammar) {
        this.lexerGrammar = lexerGrammar;
    }

    public String getLexerGrammar() {
        return this.lexerGrammar;
    }

    public void setHighlighting(boolean highlighting) {
        this.highlighting = highlighting;
    }

    public boolean isHighlighting() {
        return this.highlighting;
    }

    public void setRuntime(boolean runtime) {
        this.runtime = runtime;
    }

    public boolean isRuntime() {
        return this.runtime;
    }

    public void setContentAssist(boolean contentAssist) {
        this.contentAssist = contentAssist;
    }

    public boolean isContentAssist() {
        return this.contentAssist;
    }

    private String readFileIntoString(String filename, Charset encoding) {
        try {
            String result = Files.toString((File)new File(filename), (Charset)encoding);
            return result;
        }
        catch (IOException e) {
            throw new WrappedException((Exception)e);
        }
    }

    private void writeStringIntoFile(String filename, String content, Charset encoding) {
        try {
            Files.write((CharSequence)content, (File)new File(filename), (Charset)encoding);
        }
        catch (IOException e) {
            throw new WrappedException((Exception)e);
        }
    }
}

