/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder;

import com.google.common.base.Objects;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.builder.EclipseResourceFileSystemAccess2;
import org.eclipse.xtext.generator.AbstractFileSystemAccess;
import org.eclipse.xtext.generator.FileSystemAccessQueue;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IFileSystemAccessExtension;
import org.eclipse.xtext.generator.IFileSystemAccessExtension2;
import org.eclipse.xtext.generator.IFileSystemAccessExtension3;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.util.RuntimeIOException;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ParallelFileSystemAccess
implements IFileSystemAccess,
IFileSystemAccessExtension,
IFileSystemAccessExtension2,
IFileSystemAccessExtension3 {
    private IResourceDescription.Delta delta;
    private String sourceFolder;
    private IFileSystemAccess delegate;
    private FileSystemAccessQueue fileSystemAccessQueue;
    private EclipseResourceFileSystemAccess2.IFileCallback fileCallback;

    public ParallelFileSystemAccess(IFileSystemAccess delegate, IResourceDescription.Delta delta, FileSystemAccessQueue fileSystemAccessQueue, String sourceFolder, EclipseResourceFileSystemAccess2.IFileCallback fileCallback) {
        this.delta = delta;
        this.delegate = delegate;
        this.fileCallback = fileCallback;
        this.sourceFolder = sourceFolder;
        this.fileSystemAccessQueue = fileSystemAccessQueue;
    }

    protected <T> void sendAsync(final Procedures.Procedure1<? super T> procedure) {
        URI _uri = this.delta.getUri();
        Procedures.Procedure0 _function = new Procedures.Procedure0(){

            public void apply() {
                boolean _notEquals;
                if (ParallelFileSystemAccess.this.delegate instanceof EclipseResourceFileSystemAccess2) {
                    ((EclipseResourceFileSystemAccess2)ParallelFileSystemAccess.this.delegate).setPostProcessor(ParallelFileSystemAccess.this.fileCallback);
                }
                boolean bl = _notEquals = !Objects.equal((Object)ParallelFileSystemAccess.this.sourceFolder, null);
                if (_notEquals && ParallelFileSystemAccess.this.delegate instanceof AbstractFileSystemAccess) {
                    ((AbstractFileSystemAccess)ParallelFileSystemAccess.this.delegate).setCurrentSource(ParallelFileSystemAccess.this.sourceFolder);
                }
                procedure.apply((Object)ParallelFileSystemAccess.this.delegate);
            }
        };
        this.fileSystemAccessQueue.sendAsync(_uri, _function);
    }

    public void deleteFile(final String fileName) {
        Procedures.Procedure1<IFileSystemAccess> _function = new Procedures.Procedure1<IFileSystemAccess>(){

            public void apply(IFileSystemAccess access) {
                access.deleteFile(fileName);
            }
        };
        this.sendAsync(_function);
    }

    public void generateFile(final String fileName, final CharSequence contents) {
        Procedures.Procedure1<IFileSystemAccess> _function = new Procedures.Procedure1<IFileSystemAccess>(){

            public void apply(IFileSystemAccess access) {
                access.generateFile(fileName, contents);
            }
        };
        this.sendAsync(_function);
    }

    public void generateFile(final String fileName, final String outputConfigurationName, final CharSequence contents) {
        Procedures.Procedure1<IFileSystemAccess> _function = new Procedures.Procedure1<IFileSystemAccess>(){

            public void apply(IFileSystemAccess access) {
                access.generateFile(fileName, outputConfigurationName, contents);
            }
        };
        this.sendAsync(_function);
    }

    public void deleteFile(final String fileName, final String outputConfigurationName) {
        Procedures.Procedure1<IFileSystemAccessExtension> _function = new Procedures.Procedure1<IFileSystemAccessExtension>(){

            public void apply(IFileSystemAccessExtension access) {
                access.deleteFile(fileName, outputConfigurationName);
            }
        };
        this.sendAsync(_function);
    }

    public URI getURI(String path, String outputConfiguration) {
        if (this.delegate instanceof EclipseResourceFileSystemAccess2) {
            NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
            return ((EclipseResourceFileSystemAccess2)this.delegate).getURI(path, outputConfiguration, (IProgressMonitor)_nullProgressMonitor);
        }
        return ((IFileSystemAccessExtension2)this.delegate).getURI(path, outputConfiguration);
    }

    public URI getURI(String path) {
        if (this.delegate instanceof EclipseResourceFileSystemAccess2) {
            NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
            return ((EclipseResourceFileSystemAccess2)this.delegate).getURI(path, (IProgressMonitor)_nullProgressMonitor);
        }
        return ((IFileSystemAccessExtension2)this.delegate).getURI(path);
    }

    public void generateFile(final String fileName, final String outputCfgName, final InputStream content) throws RuntimeIOException {
        Procedures.Procedure1<IFileSystemAccessExtension3> _function = new Procedures.Procedure1<IFileSystemAccessExtension3>(){

            public void apply(IFileSystemAccessExtension3 access) {
                access.generateFile(fileName, outputCfgName, content);
            }
        };
        this.sendAsync(_function);
    }

    public void generateFile(final String fileName, final InputStream content) throws RuntimeIOException {
        Procedures.Procedure1<IFileSystemAccessExtension3> _function = new Procedures.Procedure1<IFileSystemAccessExtension3>(){

            public void apply(IFileSystemAccessExtension3 access) {
                access.generateFile(fileName, content);
            }
        };
        this.sendAsync(_function);
    }

    public InputStream readBinaryFile(String fileName, String outputCfgName) throws RuntimeIOException {
        if (this.delegate instanceof EclipseResourceFileSystemAccess2) {
            NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
            return ((EclipseResourceFileSystemAccess2)this.delegate).readBinaryFile(fileName, outputCfgName, (IProgressMonitor)_nullProgressMonitor);
        }
        return ((IFileSystemAccessExtension3)this.delegate).readBinaryFile(fileName, outputCfgName);
    }

    public InputStream readBinaryFile(String fileName) throws RuntimeIOException {
        if (this.delegate instanceof EclipseResourceFileSystemAccess2) {
            NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
            return ((EclipseResourceFileSystemAccess2)this.delegate).readBinaryFile(fileName, (IProgressMonitor)_nullProgressMonitor);
        }
        return ((IFileSystemAccessExtension3)this.delegate).readBinaryFile(fileName);
    }

    public CharSequence readTextFile(String fileName, String outputCfgName) throws RuntimeIOException {
        if (this.delegate instanceof EclipseResourceFileSystemAccess2) {
            NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
            return ((EclipseResourceFileSystemAccess2)this.delegate).readTextFile(fileName, outputCfgName, (IProgressMonitor)_nullProgressMonitor);
        }
        return ((IFileSystemAccessExtension3)this.delegate).readTextFile(fileName, outputCfgName);
    }

    public CharSequence readTextFile(String fileName) throws RuntimeIOException {
        if (this.delegate instanceof EclipseResourceFileSystemAccess2) {
            NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
            return ((EclipseResourceFileSystemAccess2)this.delegate).readTextFile(fileName, (IProgressMonitor)_nullProgressMonitor);
        }
        return ((IFileSystemAccessExtension3)this.delegate).readTextFile(fileName);
    }
}

