/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.labeling;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.ui.label.DefaultEObjectLabelProvider;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedConstructor;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedField;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.ui.labeling.XbaseImageAdornments;
import org.eclipse.xtext.xbase.ui.labeling.XbaseImages2;
import org.eclipse.xtext.xbase.validation.UIStrings;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XImportSection;

public class XbaseLabelProvider
extends DefaultEObjectLabelProvider {
    @Inject
    private XbaseImages2 images;
    @Inject
    private UIStrings uiStrings;
    @Inject
    private IBatchTypeResolver typeResolver;
    @Inject
    private XbaseImageAdornments adornments;
    @Inject
    private CommonTypeComputationServices services;

    @Inject
    public XbaseLabelProvider(AdapterFactoryLabelProvider delegate) {
        super(delegate);
    }

    protected ImageDescriptor _imageDescriptor(XImportSection importSection) {
        return this.images.forImportContainer();
    }

    protected ImageDescriptor _imageDescriptor(XImportDeclaration importDeclaration) {
        return this.images.forImport();
    }

    protected ImageDescriptor _imageDescriptor(JvmGenericType genericType) {
        ImageDescriptor _xifexpression = null;
        boolean _isInterface = genericType.isInterface();
        if (_isInterface) {
            JvmVisibility _visibility = genericType.getVisibility();
            int _get = this.adornments.get((JvmIdentifiableElement)genericType);
            _xifexpression = this.images.forInterface(_visibility, _get);
        } else {
            JvmVisibility _visibility_1 = genericType.getVisibility();
            int _get_1 = this.adornments.get((JvmIdentifiableElement)genericType);
            _xifexpression = this.images.forClass(_visibility_1, _get_1);
        }
        return _xifexpression;
    }

    protected ImageDescriptor _imageDescriptor(JvmEnumerationType enumerationType) {
        JvmVisibility _visibility = enumerationType.getVisibility();
        int _get = this.adornments.get((JvmIdentifiableElement)enumerationType);
        return this.images.forEnum(_visibility, _get);
    }

    protected ImageDescriptor _imageDescriptor(JvmAnnotationType annotationType) {
        JvmVisibility _visibility = annotationType.getVisibility();
        int _get = this.adornments.get((JvmIdentifiableElement)annotationType);
        return this.images.forAnnotation(_visibility, _get);
    }

    protected String text(JvmGenericType genericType) {
        return genericType.getSimpleName();
    }

    protected ImageDescriptor _imageDescriptor(JvmOperation operation) {
        JvmVisibility _visibility = operation.getVisibility();
        int _get = this.adornments.get((JvmIdentifiableElement)operation);
        return this.images.forOperation(_visibility, _get);
    }

    protected ImageDescriptor _imageDescriptor(IResolvedOperation operation) {
        JvmOperation _declaration = operation.getDeclaration();
        return this.imageDescriptor(_declaration);
    }

    protected Object text(JvmOperation element) {
        String _simpleName = element.getSimpleName();
        return this.signature(_simpleName, (JvmIdentifiableElement)element);
    }

    protected Object text(IResolvedOperation element) {
        boolean _not;
        LightweightTypeReference _resolvedReturnType = element.getResolvedReturnType();
        String returnTypeString = _resolvedReturnType.getSimpleName();
        String decoratedPart = " : " + returnTypeString;
        List _typeParameters = element.getTypeParameters();
        boolean _isEmpty = _typeParameters.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            String _plus_2;
            List _typeParameters_1 = element.getTypeParameters();
            String _string = this.uiStrings.toString((Iterable)_typeParameters_1);
            String _plus = " <" + _string;
            String _plus_1 = String.valueOf(_plus) + "> : ";
            decoratedPart = _plus_2 = String.valueOf(_plus_1) + returnTypeString;
        }
        JvmOperation _declaration = element.getDeclaration();
        String _simpleName = _declaration.getSimpleName();
        String _plus_3 = String.valueOf(_simpleName) + "(";
        List _resolvedParameterTypes = element.getResolvedParameterTypes();
        Functions.Function1<LightweightTypeReference, String> _function = new Functions.Function1<LightweightTypeReference, String>(){

            public String apply(LightweightTypeReference it) {
                return it.getHumanReadableName();
            }
        };
        List _map = ListExtensions.map((List)_resolvedParameterTypes, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)", ");
        String _plus_4 = String.valueOf(_plus_3) + _join;
        String _plus_5 = String.valueOf(_plus_4) + ")";
        StyledString _styledString = new StyledString(_plus_5);
        StyledString _styledString_1 = new StyledString(decoratedPart, StyledString.DECORATIONS_STYLER);
        return _styledString.append(_styledString_1);
    }

    protected ImageDescriptor _imageDescriptor(JvmConstructor constructor) {
        JvmVisibility _visibility = constructor.getVisibility();
        int _get = this.adornments.get((JvmIdentifiableElement)constructor);
        return this.images.forConstructor(_visibility, _get);
    }

    protected String text(JvmConstructor constructor) {
        String _parameters = this.uiStrings.parameters((JvmIdentifiableElement)constructor);
        return "new" + _parameters;
    }

    protected ImageDescriptor _imageDescriptor(IResolvedConstructor constructor) {
        JvmConstructor _declaration = constructor.getDeclaration();
        return this._imageDescriptor(_declaration);
    }

    protected Object text(IResolvedConstructor constructor) {
        List _resolvedParameterTypes = constructor.getResolvedParameterTypes();
        Functions.Function1<LightweightTypeReference, String> _function = new Functions.Function1<LightweightTypeReference, String>(){

            public String apply(LightweightTypeReference it) {
                return it.getHumanReadableName();
            }
        };
        List _map = ListExtensions.map((List)_resolvedParameterTypes, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map, (CharSequence)", ");
        String _plus = "new(" + _join;
        String _plus_1 = String.valueOf(_plus) + ")";
        return new StyledString(_plus_1);
    }

    protected ImageDescriptor _imageDescriptor(IResolvedField field) {
        JvmField _declaration = field.getDeclaration();
        return this._imageDescriptor(_declaration);
    }

    protected Object text(IResolvedField field) {
        String _simpleSignature = field.getSimpleSignature();
        String _plus = String.valueOf(_simpleSignature) + " : ";
        LightweightTypeReference _resolvedType = field.getResolvedType();
        String _humanReadableName = _resolvedType.getHumanReadableName();
        String _plus_1 = String.valueOf(_plus) + _humanReadableName;
        return new StyledString(_plus_1);
    }

    protected ImageDescriptor _imageDescriptor(JvmField field) {
        JvmVisibility _visibility = field.getVisibility();
        int _get = this.adornments.get((JvmIdentifiableElement)field);
        return this.images.forField(_visibility, _get);
    }

    protected Object text(JvmField field) {
        String _simpleName = field.getSimpleName();
        String _plus = String.valueOf(_simpleName) + " : ";
        JvmTypeReference _type = field.getType();
        String _simpleName_1 = _type.getSimpleName();
        return String.valueOf(_plus) + _simpleName_1;
    }

    protected ImageDescriptor _imageDescriptor(JvmFormalParameter parameter) {
        int _get = this.adornments.get((JvmIdentifiableElement)parameter);
        return this.images.forLocalVariable(_get);
    }

    protected String text(JvmFormalParameter parameter) {
        String _xblockexpression = null;
        JvmTypeReference parameterType = parameter.getParameterType();
        String _xifexpression = null;
        boolean _equals = Objects.equal((Object)parameterType, null);
        if (_equals) {
            _xifexpression = parameter.getName();
        } else {
            String _simpleName = parameterType.getSimpleName();
            String _plus = String.valueOf(_simpleName) + " ";
            String _name = parameter.getName();
            _xifexpression = String.valueOf(_plus) + _name;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected ImageDescriptor _imageDescriptor(XVariableDeclaration variableDeclaration) {
        int _get = this.adornments.get((JvmIdentifiableElement)variableDeclaration);
        return this.images.forLocalVariable(_get);
    }

    protected String text(XImportDeclaration it) {
        StringConcatenation _builder = new StringConcatenation();
        String _importedTypeName = it.getImportedTypeName();
        _builder.append((Object)_importedTypeName, "");
        boolean _isWildcard = it.isWildcard();
        if (_isWildcard) {
            _builder.append((Object)".*");
        } else {
            boolean _notEquals;
            String _memberName = it.getMemberName();
            boolean bl = _notEquals = !Objects.equal((Object)_memberName, null);
            if (_notEquals) {
                _builder.append((Object)".");
                String _memberName_1 = it.getMemberName();
                _builder.append((Object)_memberName_1, "");
            }
        }
        return _builder.toString();
    }

    protected String text(XImportSection importSection) {
        return "import declarations";
    }

    protected String text(XVariableDeclaration variableDeclaration) {
        boolean _notEquals;
        String _xblockexpression = null;
        IResolvedTypes resolvedTypes = this.typeResolver.resolveTypes((EObject)variableDeclaration);
        LightweightTypeReference type = resolvedTypes.getActualType((JvmIdentifiableElement)variableDeclaration);
        String _xifexpression = null;
        boolean bl = _notEquals = !Objects.equal((Object)type, null);
        if (_notEquals) {
            String _humanReadableName = type.getHumanReadableName();
            String _plus = String.valueOf(_humanReadableName) + " ";
            String _name = variableDeclaration.getName();
            _xifexpression = String.valueOf(_plus) + _name;
        } else {
            _xifexpression = variableDeclaration.getName();
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected ImageDescriptor _imageDescriptor(JvmTypeParameter parameter) {
        int _get = this.adornments.get((JvmIdentifiableElement)parameter);
        return this.images.forTypeParameter(_get);
    }

    protected StyledString signature(String simpleName, JvmIdentifiableElement element) {
        boolean _notEquals;
        JvmTypeReference _xifexpression = null;
        if (element instanceof JvmOperation) {
            _xifexpression = ((JvmOperation)element).getReturnType();
        } else {
            JvmTypeReference _xifexpression_1 = null;
            _xifexpression_1 = element instanceof JvmField ? ((JvmField)element).getType() : null;
            _xifexpression = _xifexpression_1;
        }
        JvmTypeReference returnType = _xifexpression;
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.services, (EObject)element);
        String _xifexpression_2 = null;
        boolean _equals = Objects.equal((Object)returnType, null);
        if (_equals) {
            _xifexpression_2 = "void";
        } else {
            LightweightTypeReference _lightweightTypeReference = owner.toLightweightTypeReference(returnType);
            _xifexpression_2 = _lightweightTypeReference.getHumanReadableName();
        }
        String returnTypeString = _xifexpression_2;
        String decoratedPart = " : " + returnTypeString;
        String _elvis = null;
        String _typeParameters = this.uiStrings.typeParameters(element);
        _elvis = _typeParameters != null ? _typeParameters : "";
        String typeParam = _elvis;
        boolean bl = _notEquals = !Objects.equal((Object)typeParam, (Object)"");
        if (_notEquals) {
            decoratedPart = " " + typeParam + " : " + returnTypeString;
        }
        String _parameters = this.uiStrings.parameters(element);
        String _plus = String.valueOf(simpleName) + _parameters;
        StyledString _styledString = new StyledString(_plus);
        StyledString _styledString_1 = new StyledString(decoratedPart, StyledString.DECORATIONS_STYLER);
        return _styledString.append(_styledString_1);
    }

    protected ImageDescriptor _imageDescriptor(Object element) {
        return null;
    }

    protected Object doGetImage(Object element) {
        Object _elvis = null;
        ImageDescriptor _imageDescriptor = null;
        if (element != null) {
            _imageDescriptor = this.imageDescriptor(element);
        }
        if (_imageDescriptor != null) {
            _elvis = _imageDescriptor;
        } else {
            Object _doGetImage = super.doGetImage(element);
            _elvis = _doGetImage;
        }
        return _elvis;
    }

    protected IBatchTypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    protected ImageDescriptor imageDescriptor(Object constructor) {
        if (constructor instanceof JvmConstructor) {
            return this._imageDescriptor((JvmConstructor)constructor);
        }
        if (constructor instanceof JvmOperation) {
            return this._imageDescriptor((JvmOperation)constructor);
        }
        if (constructor instanceof JvmAnnotationType) {
            return this._imageDescriptor((JvmAnnotationType)constructor);
        }
        if (constructor instanceof JvmEnumerationType) {
            return this._imageDescriptor((JvmEnumerationType)constructor);
        }
        if (constructor instanceof JvmField) {
            return this._imageDescriptor((JvmField)constructor);
        }
        if (constructor instanceof JvmGenericType) {
            return this._imageDescriptor((JvmGenericType)constructor);
        }
        if (constructor instanceof JvmTypeParameter) {
            return this._imageDescriptor((JvmTypeParameter)constructor);
        }
        if (constructor instanceof JvmFormalParameter) {
            return this._imageDescriptor((JvmFormalParameter)constructor);
        }
        if (constructor instanceof XVariableDeclaration) {
            return this._imageDescriptor((XVariableDeclaration)constructor);
        }
        if (constructor instanceof IResolvedConstructor) {
            return this._imageDescriptor((IResolvedConstructor)constructor);
        }
        if (constructor instanceof IResolvedOperation) {
            return this._imageDescriptor((IResolvedOperation)constructor);
        }
        if (constructor instanceof XImportDeclaration) {
            return this._imageDescriptor((XImportDeclaration)constructor);
        }
        if (constructor instanceof XImportSection) {
            return this._imageDescriptor((XImportSection)constructor);
        }
        if (constructor instanceof IResolvedField) {
            return this._imageDescriptor((IResolvedField)constructor);
        }
        if (constructor != null) {
            return this._imageDescriptor(constructor);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(constructor).toString());
    }
}

