/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.file;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.builder.EclipseOutputConfigurationProvider;
import org.eclipse.xtext.xbase.file.ProjectConfig;
import org.eclipse.xtext.xbase.file.WorkspaceConfig;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;
import org.eclipse.xtext.xbase.ui.file.EclipseProjectConfig;

@Data
public class EclipseWorkspaceConfig
extends WorkspaceConfig {
    private final IWorkspaceRoot workspaceRoot;
    private final EclipseOutputConfigurationProvider configurationProvider;

    public String getAbsoluteFileSystemPath() {
        IPath _location = this.workspaceRoot.getLocation();
        return _location.toString();
    }

    public ProjectConfig getProject(String name) {
        try {
            IProject project = this.workspaceRoot.getProject(name);
            boolean _exists = project.exists();
            if (_exists) {
                return new EclipseProjectConfig(project, this.configurationProvider);
            }
            return null;
        }
        catch (Throwable _t) {
            if (_t instanceof IllegalArgumentException) {
                IllegalArgumentException e = (IllegalArgumentException)_t;
                return null;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public Collection<? extends ProjectConfig> getProjects() {
        IProject[] _projects = this.workspaceRoot.getProjects();
        Functions.Function1<IProject, EclipseProjectConfig> _function = new Functions.Function1<IProject, EclipseProjectConfig>(){

            public EclipseProjectConfig apply(IProject it) {
                return new EclipseProjectConfig(it, EclipseWorkspaceConfig.this.configurationProvider);
            }
        };
        List _map = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)_projects)), (Functions.Function1)_function);
        return Collections.unmodifiableList(_map);
    }

    public EclipseWorkspaceConfig(IWorkspaceRoot workspaceRoot, EclipseOutputConfigurationProvider configurationProvider) {
        this.workspaceRoot = workspaceRoot;
        this.configurationProvider = configurationProvider;
    }

    @Pure
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.workspaceRoot == null ? 0 : this.workspaceRoot.hashCode());
        result = 31 * result + (this.configurationProvider == null ? 0 : this.configurationProvider.hashCode());
        return result;
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        EclipseWorkspaceConfig other = (EclipseWorkspaceConfig)((Object)obj);
        if (this.workspaceRoot == null ? other.workspaceRoot != null : !this.workspaceRoot.equals((Object)other.workspaceRoot)) {
            return false;
        }
        return !(this.configurationProvider == null ? other.configurationProvider != null : !this.configurationProvider.equals(other.configurationProvider));
    }

    @Pure
    public String toString() {
        String result = new ToStringBuilder((Object)this).addAllFields().toString();
        return result;
    }

    @Pure
    public IWorkspaceRoot getWorkspaceRoot() {
        return this.workspaceRoot;
    }

    @Pure
    public EclipseOutputConfigurationProvider getConfigurationProvider() {
        return this.configurationProvider;
    }
}

