/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.javaconverter;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtend.core.javaconverter.JavaConverter;
import org.eclipse.xtend.ide.javaconverter.ConversionProblemsDialog;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.formatting2.FormatterPreferences;
import org.eclipse.xtext.formatting2.FormatterRequest;
import org.eclipse.xtext.formatting2.IFormatter2;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.TextRegionAccessBuilder;
import org.eclipse.xtext.preferences.IPreferenceValues;
import org.eclipse.xtext.preferences.IPreferenceValuesProvider;
import org.eclipse.xtext.preferences.TypedPreferenceValues;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.ui.util.DontAskAgainDialogs;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.LazyStringInputStream;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.Issue;

public class ConvertJavaCode {
    private static String DELETE_JAVA_FILES_AFTER_CONVERSION = "delete_java_file_after_conversion";
    @Inject
    private Provider<JavaConverter> converterProvider;
    @Inject
    private IResourceSetProvider resourceSetProvider;
    @Inject
    private FileExtensionProvider fileExtensionProvider;
    @Inject
    @FormatterPreferences
    private IPreferenceValuesProvider cfgProvider;
    @Inject
    private IFormatter2 formatter;
    @Inject
    private Provider<TextRegionAccessBuilder> regionAccessBuilder;
    @Inject
    private DontAskAgainDialogs dialogs;
    private static final Logger LOG = Logger.getLogger(ConvertJavaCode.class);

    public void runJavaConverter(Set<ICompilationUnit> compilationUnits, Shell activeShell) throws ExecutionException {
        HashMap conversionResults = Maps.newHashMap();
        boolean canceled = this.convertAllWithProgress(activeShell, compilationUnits, conversionResults);
        if (canceled) {
            return;
        }
        boolean hasConversionFailures = Iterables.any(conversionResults.values(), (Predicate)new Predicate<JavaConverter.ConversionResult>(){

            public boolean apply(JavaConverter.ConversionResult input) {
                return input.getProblems().iterator().hasNext();
            }
        });
        if (hasConversionFailures) {
            ConversionProblemsDialog problemsDialog = new ConversionProblemsDialog(activeShell, conversionResults);
            problemsDialog.open();
            if (problemsDialog.getReturnCode() == 1) {
                return;
            }
        }
        String storedValue = this.dialogs.getUserDecision(DELETE_JAVA_FILES_AFTER_CONVERSION);
        boolean deleteJavaFiles = false;
        if ("prompt".equals(storedValue)) {
            int userAnswer = this.dialogs.askUser("Delete Java source files?", "Xtend converter", DELETE_JAVA_FILES_AFTER_CONVERSION, activeShell);
            if (userAnswer == 1) {
                return;
            }
            if (userAnswer == 2) {
                deleteJavaFiles = true;
            }
        } else if ("always".equals(storedValue)) {
            deleteJavaFiles = true;
        }
        for (Map.Entry result : conversionResults.entrySet()) {
            String formattedCode;
            ICompilationUnit compilationUnit = (ICompilationUnit)result.getKey();
            JavaConverter.ConversionResult conversionResult = (JavaConverter.ConversionResult)result.getValue();
            String xtendCode = conversionResult.getXtendCode();
            IFile xtendFileToCreate = this.xtendFileToCreate(compilationUnit);
            if (!conversionResult.getProblems().iterator().hasNext() && (formattedCode = this.formatXtendCode(xtendFileToCreate, xtendCode)) != null) {
                xtendCode = formattedCode;
            }
            this.writeToFile(xtendFileToCreate, xtendCode);
            if (!deleteJavaFiles) continue;
            try {
                compilationUnit.delete(true, null);
            }
            catch (JavaModelException e) {
                this.handleException("Unable to delete Java file.", e, compilationUnit.getResource());
            }
        }
    }

    private boolean convertAllWithProgress(Shell shell, final Set<ICompilationUnit> compilationUnits, final Map<ICompilationUnit, JavaConverter.ConversionResult> conversionResults) throws ExecutionException {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask("Converting files.", compilationUnits.size());
                try {
                    ConvertJavaCode.this.doConvert(compilationUnits, monitor, conversionResults);
                }
                catch (ExecutionException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            new ProgressMonitorDialog(shell).run(true, true, op);
        }
        catch (InvocationTargetException e) {
            this.handleException("An exception occures during conversion proccess.", e, null);
        }
        catch (InterruptedException e) {
            return true;
        }
        return false;
    }

    private void doConvert(Set<ICompilationUnit> compilationUnits, IProgressMonitor monitor, Map<ICompilationUnit, JavaConverter.ConversionResult> conversionResults) throws ExecutionException, InterruptedException {
        for (ICompilationUnit iCompilationUnit : compilationUnits) {
            IFile file;
            Resource resource;
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            JavaConverter converter = (JavaConverter)this.converterProvider.get();
            JavaConverter.ConversionResult conversionResult = converter.toXtend(iCompilationUnit);
            monitor.subTask("Working with " + iCompilationUnit.getElementName());
            if (!conversionResult.getProblems().iterator().hasNext() && !this.validateResource(resource = this.createResource(file = this.xtendFileToCreate(iCompilationUnit), conversionResult.getXtendCode()))) {
                monitor.subTask("Conversion was not successfull. Re-trying with another strategy.");
                conversionResult = converter.useRobustSyntax().toXtend(iCompilationUnit);
            }
            conversionResults.put(iCompilationUnit, conversionResult);
            monitor.worked(1);
        }
    }

    private String formatXtendCode(IFile xtendFile, String xtendCode) {
        try {
            XtextResource resource = (XtextResource)this.createResource(xtendFile, xtendCode);
            ITextRegionAccess regionAccess = ((TextRegionAccessBuilder)this.regionAccessBuilder.get()).forNodeModel(resource).create();
            FormatterRequest request = new FormatterRequest();
            request.setAllowIdentityEdits(false);
            request.setTextRegionAccess(regionAccess);
            request.setPreferences(TypedPreferenceValues.castOrWrap((IPreferenceValues)this.cfgProvider.getPreferenceValues((Resource)resource)));
            List replacements = this.formatter.format(request);
            String formatted = regionAccess.getRewriter().renderToString((Iterable)replacements);
            return formatted;
        }
        catch (Exception e) {
            LOG.error((Object)"Formatting step canceled due to an exception.", (Throwable)e);
            return null;
        }
    }

    private IFile xtendFileToCreate(ICompilationUnit iCompilationUnit) {
        IContainer parent = iCompilationUnit.getResource().getParent();
        String xtendFileName = String.valueOf(Files.getNameWithoutExtension((String)iCompilationUnit.getElementName())) + "." + this.fileExtensionProvider.getPrimaryFileExtension();
        IFile file = parent.getFile((IPath)new Path(xtendFileName));
        return file;
    }

    private void writeToFile(IFile file, String content) throws ExecutionException {
        try {
            ByteArrayInputStream source = new ByteArrayInputStream(content.getBytes(file.getCharset()));
            if (!file.exists()) {
                file.create((InputStream)source, true, null);
            } else {
                file.setContents((InputStream)source, true, false, null);
            }
        }
        catch (CoreException e) {
            this.handleException("Failed to create file.", e, (IResource)file);
        }
        catch (UnsupportedEncodingException e) {
            this.handleException("Failed to write to file.", e, (IResource)file);
        }
    }

    private boolean validateResource(Resource resource) {
        if (resource.getErrors().size() == 0) {
            ArrayList issues = Lists.newArrayList((Iterable)Iterables.filter((Iterable)((XtextResource)resource).getResourceServiceProvider().getResourceValidator().validate(resource, CheckMode.ALL, CancelIndicator.NullImpl), (Predicate)new Predicate<Issue>(){

                public boolean apply(Issue issue) {
                    String code = issue.getCode();
                    return issue.getSeverity() == Severity.ERROR && !"org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_type".equals(code) && !"org.eclipse.xtend.core.validation.IssueCodes.xbase_lib_not_on_classpath".equals(code);
                }
            }));
            return issues.size() == 0;
        }
        return false;
    }

    private Resource createResource(IFile file, String content) throws ExecutionException {
        ResourceSet set = this.resourceSetProvider.get(file.getProject());
        Resource resource = set.createResource(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)false));
        try {
            resource.load((InputStream)new LazyStringInputStream(content, file.getCharset()), null);
        }
        catch (CoreException e) {
            this.handleException("Failed to read file content", e, (IResource)file);
        }
        catch (IOException e) {
            this.handleException("Failed to load resource.", e, (IResource)file);
        }
        return resource;
    }

    private void handleException(String message, Throwable e, IResource file) throws ExecutionException {
        throw new ExecutionException(String.valueOf(message) + (file != null ? " " + file.getFullPath() : ""), e);
    }
}

